/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Aug 19, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
package gov.va.med.imaging.dicomviewer;

import java.awt.Canvas;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;

/**
 * 
 * @author DNS
 *
 */
public class ImageCanvas
extends Canvas
{
	private static final float DEFAULT_OFFSET = 0.0f;
	private static final float DEFAULT_SCALE = 1.0f;
	private static final float DEFAULT_MAGNIFICATION = 1.0f;
	private final static float MINIMUM_MAGNIFICATION = 0.1f;
	private final static float MAXIMIM_MAGNIFICATION = 10.0f;
	
	private static final long serialVersionUID = 1L;
	private BufferedImage image;
	
	private float magnification = DEFAULT_MAGNIFICATION;
	private float scale = DEFAULT_SCALE;
	private float offset = DEFAULT_OFFSET;
	
	private ImageScaleOffsetMouseListener scaleOffsetListener;
	private ImageMagnificationMouseWheelListener magnificationListener;
	
	public ImageCanvas(BufferedImage image)
	{
		this.image = image;
		
		this.scaleOffsetListener = new ImageScaleOffsetMouseListener();
		this.magnificationListener = new ImageMagnificationMouseWheelListener();
		
		this.addMouseListener(scaleOffsetListener);
		this.addMouseMotionListener(scaleOffsetListener);
		this.addMouseWheelListener(magnificationListener);
	}
	
	/**
	 * 
	 * @see java.awt.Canvas#paint(java.awt.Graphics)
	 */
    public void paint(Graphics g)
    {
    	BufferedImage renderedImage = null;
    	
    	if(getScale() != DEFAULT_SCALE || getOffset() != DEFAULT_OFFSET)
    	{
    		//RenderingHints rh = new RenderingHints();
    		RescaleOp op = new RescaleOp(getScale(), getOffset(), null);
    		renderedImage = op.filter(this.image, null);
    	}
    	else
    		renderedImage = this.image;
    	
    	Graphics2D g2 = (Graphics2D)g;
    	
    	AffineTransform zoomTransform = AffineTransform.getScaleInstance(getMagnification(), getMagnification());
    	g2.drawImage(
    		renderedImage,
			new AffineTransformOp(zoomTransform, AffineTransformOp.TYPE_BILINEAR), 
			0, 0);
    	
    	//FontRenderContext frc = new FontRenderContext(zoomTransform, false, false);
    	//TextLayout disclaimerTextLayout = new TextLayout("Not for diagnostic use", Font.getFont(Font.DIALOG), frc);
    	//disclaimerTextLayout.draw(g2, 10, 100);
    	
    	//((Graphics2D)g).drawImage( this.image, 0, 0, 800, 600, this );
    }

    /**
     * Zoom level is set in terms of magnification, 1.0 is unit magnification, 2.0 is zoomed in
     * to double size, .5 is zoomed out to half size.
     * 
     * @param magnification
     */
	public void setMagnification(float magnification)
    {
		this.magnification = magnification;
		repaint();
    }
	protected float getMagnification()
    {
    	return magnification;
    }

	/**
	 * Scale and offset define the brightness operation.
	 * @param scale
	 */
	public void setScaleAndOffset(float scale, float offset)
    {
		this.scale = scale;
		this.offset = offset;
		System.out.println("scale=" + scale + ", offset=" + offset);
		repaint();
    }
	
	public void setScale(float scale)
    {
		this.scale = scale;
		repaint();
    }
	public float getScale()
    {
    	return scale;
    }

	public void setOffset(float offset)
    {
		this.offset = offset;
		repaint();
    }
	public float getOffset()
    {
    	return offset;
    }
	
	class ImageScaleOffsetMouseListener
	implements MouseMotionListener, MouseListener
	{
		private float scale = DEFAULT_SCALE;
		private float offset = DEFAULT_OFFSET;
		
		private int startX;
		private int startY;
		
		@Override
        public void mouseDragged(MouseEvent e)
        {
			int deltaX = e.getX() - startX;
			int deltaY = e.getY() - startY;
			
			System.out.println("deltaX=" + deltaX + ", deltaY=" + deltaY);
			
			scale += (float)deltaX * .0001f;
			offset += (float)deltaY * .0001f;
			
			setScaleAndOffset(scale, offset);
        }

		@Override
        public void mouseMoved(MouseEvent e)
        {
	        
        }

		@Override
        public void mouseClicked(MouseEvent e)
        {
        }

		@Override
        public void mouseEntered(MouseEvent e)
        {
        }

		@Override
        public void mouseExited(MouseEvent e)
        {
        }

		@Override
        public void mousePressed(MouseEvent e)
        {
        	startX = e.getX();
        	startY = e.getY();
			System.out.println("startX=" + startX + ", startY=" + startY);
        }

		@Override
        public void mouseReleased(MouseEvent e)
        {
        }
	}
	
	class ImageMagnificationMouseWheelListener
	implements MouseWheelListener
	{
		private float magnification = DEFAULT_MAGNIFICATION;
		@Override
	    public void mouseWheelMoved(MouseWheelEvent e)
	    {
			// negative clicks is up (zoom out)
			// positive clicks is down (zoom in)
	        int clicks = e.getWheelRotation();
	        float magnificationDelta = caclulateMagnificationDelta(magnification, clicks);
	        magnification += magnificationDelta;
	        magnification = Math.max(magnification, MINIMUM_MAGNIFICATION);
	        magnification = Math.min(magnification, MAXIMIM_MAGNIFICATION);
	        setMagnification(magnification);
	    }
		
		private float caclulateMagnificationDelta(float currentZoomLevel, int clicks)
        {
			float delta = (float)clicks * .1f;
	        return delta;
        }
	}

}