/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Aug 18, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author       DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
package gov.va.med.imaging.dicomviewer;

import gov.va.med.imaging.dicom.DataSet;
import gov.va.med.imaging.dicom.exceptions.ValueRepresentationInterpretationException;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;

import javax.swing.JDialog;
import javax.swing.JInternalFrame;

/**
 * @author       DNS
 *
 */
public class DicomPropertiesDialog 
extends JInternalFrame
{
	private static final long serialVersionUID = 1L;
	
	private DicomHeaderPanel dicomHeaderPanel;
	
	public DicomPropertiesDialog(DataSet dataSet)
	{
		initGui(dataSet);
		try
        {
	        this.setTitle(dataSet.getPatientId());
        } 
		catch (Throwable e)
        {
	        this.setTitle("<Unknown Patient ID>");
        }
	}
	/**
	 * 
	 */
	public DicomPropertiesDialog(DataSet dataSet, String title)
	{
		initGui(dataSet);
		this.setTitle(title);
	}

	/**
	 * @param owner
	 */
	public DicomPropertiesDialog(Frame owner, DataSet dataSet, String title)
	{
		super();
		initGui(dataSet);
		this.setTitle(title);
	}

	/**
	 * @param owner
	 */
	public DicomPropertiesDialog(Dialog owner, DataSet dataSet, String title)
	{
		super();
		initGui(dataSet);
		this.setTitle(title);
	}

	/**
	 * @param owner
	 */
	public DicomPropertiesDialog(Window owner, DataSet dataSet, String title)
	{
		super();
		initGui(dataSet);
		this.setTitle(title);
	}

	private void initGui(DataSet dataSet)
    {
		this.setLayout(new BorderLayout());
		dicomHeaderPanel = new DicomHeaderPanel(dataSet);
		
		this.add(dicomHeaderPanel, BorderLayout.CENTER);
		
		this.pack();
    }
	
}
