/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Jul 23, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author       DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
package gov.va.med.imaging.dicomviewer;

import java.awt.Dimension;

import gov.va.med.imaging.dicom.DataSet;

import javax.swing.JTabbedPane;

/**
 * @author       DNS
 *
 */
public class DicomHeaderPanel 
extends JTabbedPane
{
	private static final long serialVersionUID = 1L;
	private AbstractDicomGroupPanel[] tabs;
	private final DataSet dataSet;

	public DicomHeaderPanel(DataSet dataSet)
    {
	    super();
	    this.dataSet = dataSet;
	    init();
    }

	public DicomHeaderPanel(DataSet dataSet, int tabPlacement, int tabLayoutPolicy)
    {
	    super(tabPlacement, tabLayoutPolicy);
	    this.dataSet = dataSet;
	    init();
    }

	public DicomHeaderPanel(DataSet dataSet, int tabPlacement)
    {
	    super(tabPlacement);
	    this.dataSet = dataSet;
	    init();
    }

	private void init()
    {
		tabs = new AbstractDicomGroupPanel[]
		{
			new DicomGroupPanel(dataSet, 0x02),
			new DicomGroupPanel(dataSet, 0x08),
			new DicomGroupPanel(dataSet, 0x10),
			new DicomGroupPanel(dataSet, 0x12),
			new DicomGroupPanel(dataSet, 0x18),
			new DicomGroupPanel(dataSet, 0x20),
			new DicomGroupPanel(dataSet, 0x22),
			new DicomGroupPanel(dataSet, 0x28),
			new DicomGroupPanel(dataSet, 0x32),
			new DicomGroupPanel(dataSet, 0x38),
			new DicomGroupPanel(dataSet, 0x3A),
			new DicomGroupPanel(dataSet, 0x40),
			new DicomGroupPanel(dataSet, 0x42),
			new DicomGroupPanel(dataSet, 0x50),
			new DicomGroupPanel(dataSet, 0x54),
			new DicomGroupPanel(dataSet, 0x60),
			new DicomGroupPanel(dataSet, 0x62),
			new DicomGroupPanel_7FE0(dataSet, 0x7FE0)
		};
		
		int index = 0;
		for(AbstractDicomGroupPanel tab : tabs)
		{
			this.add(tab);
			this.setTitleAt(index++, tab.getTitle());
		}
		
		setPreferredSize(new Dimension(450, 600));
    }
}
