/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Aug 18, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author       DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
package gov.va.med.imaging.dicomviewer;

import gov.va.med.imaging.dicom.DataElement;
import gov.va.med.imaging.dicom.DataSet;
import gov.va.med.imaging.dicom.exceptions.ValueRepresentationInterpretationException;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;

import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

/**
 * @author       DNS
 *
 */
public class DicomGroupTableModel 
implements TableModel
{
	private final Collection<DataElement<?>> groupCollection;
	
	/**
	 * 
	 */
	public DicomGroupTableModel(DataSet dataSet, int groupNumber)
	{
		this.groupCollection = dataSet.subset(groupNumber);
	}

	/**
	 * @see javax.swing.table.TableModel#getColumnClass(int)
	 */
	@Override
	public Class<?> getColumnClass(int columnIndex)
	{
		return java.lang.String.class;
	}

	/**
	 * @see javax.swing.table.TableModel#getColumnCount()
	 */
	@Override
	public int getColumnCount()
	{
		return 2;
	}

	/**
	 * @see javax.swing.table.TableModel#getColumnName(int)
	 */
	@Override
	public String getColumnName(int columnIndex)
	{
		return columnIndex == 0 ? "Element Tag" : "Value";
	}

	/**
	 * @see javax.swing.table.TableModel#getRowCount()
	 */
	@Override
	public int getRowCount()
	{
		return groupCollection.size();
	}

	/**
	 * @see javax.swing.table.TableModel#getValueAt(int, int)
	 */
	@Override
	public Object getValueAt(int rowIndex, int columnIndex)
	{
		int index = 0;
		DataElement<?> element = null;
		
		for(DataElement<?> dataElement : groupCollection)
		{
			if(index++ == rowIndex)
			{
				element = dataElement;
				break;
			}
		}
		
		if(element != null && columnIndex == 0)
		{
			return element.getDataElementTag().toString();
		}
		else if(element != null && columnIndex == 1)
		{
	        try
            {
	        	if( element.getValue() == null )
	        		return "<null value>";
	        	else
	        		return element.getValue().toString();
            } 
			catch (ValueRepresentationInterpretationException e)
            {
	            return e.getMessage();
            }
		}
		
		return null;
	}

	/**
	 * @see javax.swing.table.TableModel#isCellEditable(int, int)
	 */
	@Override
	public boolean isCellEditable(int rowIndex, int columnIndex)
	{
		return false;
	}

	/**
	 * @see javax.swing.table.TableModel#setValueAt(java.lang.Object, int, int)
	 */
	@Override
	public void setValueAt(Object value, int rowIndex, int columnIndex)
	{

	}

	// =============================================================================================================
	//
	// =============================================================================================================
	private Set<TableModelListener> tableModelListeners = new HashSet<TableModelListener>();
	
	private void notifyListenersOfInsert(int firstRow, int lastRow, int column)
	{
		TableModelEvent event = new TableModelEvent(this, firstRow, lastRow, column, TableModelEvent.INSERT);
		notifyListeners(event);
	}
	
	private void notifyListenersOfUpdate(int firstRow, int lastRow, int column)
	{
		TableModelEvent event = new TableModelEvent(this, firstRow, lastRow, column, TableModelEvent.UPDATE);
		notifyListeners(event);
	}
	
	private void notifyListenersOfDelete(int firstRow, int lastRow, int column)
	{
		TableModelEvent event = new TableModelEvent(this, firstRow, lastRow, column, TableModelEvent.DELETE);
		notifyListeners(event);
	}
	
	private void notifyListeners(TableModelEvent event)
	{
		for(TableModelListener tableModelListener : tableModelListeners)
			tableModelListener.tableChanged(event);
	}
	
	/**
	 * @see javax.swing.table.TableModel#addTableModelListener(javax.swing.event.TableModelListener)
	 */
	@Override
	public void addTableModelListener(TableModelListener l)
	{
		tableModelListeners.add(l);
	}

	/**
	 * @see javax.swing.table.TableModel#removeTableModelListener(javax.swing.event.TableModelListener)
	 */
	@Override
	public void removeTableModelListener(TableModelListener l)
	{
		tableModelListeners.remove(l);
	}

}
