/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Sep 16, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author       DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
package gov.va.med.imaging.dicomviewer;

import gov.va.med.imaging.dicom.DataSet;
import gov.va.med.imaging.dicom.DicomUtilities;

import javax.swing.JPanel;

/**
 * @author       DNS
 *
 */
public abstract class AbstractDicomGroupPanel 
extends JPanel
{
	protected final DataSet dataSet;
	protected final int groupNumber;

	public AbstractDicomGroupPanel(DataSet dataSet, int groupNumber)
    {
	    super();
	    this.dataSet = dataSet;
	    this.groupNumber = groupNumber;
	    
	    initGui();
    }

	protected abstract void initGui();

	public DataSet getDataSet()
    {
    	return dataSet;
    }

	public int getGroupNumber()
    {
    	return groupNumber;
    }

	public String getTitle()
    {
    	return "Group " + DicomUtilities.toFourDigitHex(groupNumber);
    }

}
