/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Jun 16, 2011
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.exchange.business.annotations;

/**
 * Information about the user who created the annotation layer
 * 
 * @author       DNS
 *
 */
public class ImageAnnotationUser
{
	private final String userId;
	private final String name;
	private final String service;
	
	/**
	 * 
	 * @param userId
	 * @param name
	 * @param service
	 */
	public ImageAnnotationUser(String userId, String name, String service)
	{
		super();
		this.userId = userId;
		this.name = name;
		this.service = service;
	}
	
	/**
	 * Returns the unique identification of the user at the site where the annotation layer was
	 * created.  In VistA this will be the user DUZ
	 * @return
	 */
	public String getUserId()
	{
		return userId;
	}
	
	/**
	 * Return the users name
	 * @return
	 */
	public String getName()
	{
		return name;
	}
	
	/**
	 * Return the users service
	 * @return
	 */
	public String getService()
	{
		return service;
	}

	@Override
	public String toString()
	{
		return "ImageAnnotationUser [userId=" + userId + ", name=" + name
				+ ", service=" + service + "]";
	}
}
