﻿using System;
using System.Collections.Generic;
using System.Text;

namespace VixBuilderBusiness
{
    public enum RepositoryEnum
    {
        ConcurrentVersionsSystem, VisualSourceSafe, TeamFoundationServer, ClearCase, none
    };

    public class RepositoryType
    {
        private static List<RepositoryType> buildRepositories = null;
        private static List<RepositoryType> deployRepositories = null;

        public static RepositoryType[] GetBuildRepositories()
        {
            if (buildRepositories == null)
            {
                buildRepositories = new List<RepositoryType>();
                buildRepositories.Add(new RepositoryType(RepositoryEnum.ConcurrentVersionsSystem));
                buildRepositories.Add(new RepositoryType(RepositoryEnum.TeamFoundationServer));
                buildRepositories.Add(new RepositoryType(RepositoryEnum.none));
            }
            return buildRepositories.ToArray();
        }

        public static RepositoryType[] GetDeployRepositories()
        {
            if (deployRepositories == null)
            {
                deployRepositories = new List<RepositoryType>();
                deployRepositories.Add(new RepositoryType(RepositoryEnum.TeamFoundationServer));
                deployRepositories.Add(new RepositoryType(RepositoryEnum.VisualSourceSafe));
                deployRepositories.Add(new RepositoryType(RepositoryEnum.none));
            }
            return deployRepositories.ToArray();
        }

        public string Description { get; set; }
        public RepositoryEnum Id { get; set; }



        private RepositoryType(RepositoryEnum action)
        {
            Id = action;
            Description = action.ToString();
        }
    }
}
