using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;

namespace VixBuilderBusiness
{
    public enum InstallationTypeEnum { VIX, CVIX, HDIG, RVIX };

    public class InstallationType
    {
        private static List<InstallationType> installationTypes = null;

        public static InstallationType[] GetInstallationTypes()
        {
            if (installationTypes == null)
            {
                installationTypes = new List<InstallationType>();
                installationTypes.Add(new InstallationType(InstallationTypeEnum.VIX, "VIX Installer", "VixInstaller", "VIX Service Installation Wizard"));
                installationTypes.Add(new InstallationType(InstallationTypeEnum.CVIX, "CVIX Installer", "CvixInstaller", "CVIX Service Installation Wizard"));
                installationTypes.Add(new InstallationType(InstallationTypeEnum.HDIG, "HDIG Installer", "HdigInstaller", "HDIG Installation Wizard"));
                installationTypes.Add(new InstallationType(InstallationTypeEnum.RVIX, "RVIX Installer", "RvixInstaller", "RVIX Service Installation Wizard"));
            }
            return installationTypes.ToArray();
        }

        public static InstallationType GetInstallationTypeByID(InstallationTypeEnum id)
        {
            InstallationType specifiedInstallationType = null;
            foreach (InstallationType installationType in GetInstallationTypes())
            {
                if (installationType.Id == id)
                {
                    specifiedInstallationType = installationType;
                    break;
                }
            }
            Debug.Assert(specifiedInstallationType != null);
            return specifiedInstallationType;
        }

        private string description;
        public string Description
        {
            get { return description; }
            set { description = value; }
        }

        private InstallationTypeEnum id;
        public InstallationTypeEnum Id
        {
            get { return id; }
            set { id = value; }
        }

        private string installerMsiApplicationFolder;
        public string InstallerMsiApplicationFolder
        {
            get { return installerMsiApplicationFolder; }
            set { installerMsiApplicationFolder = value; }
        }

        private string installerDisplayName;
        public string InstallerDisplayName
        {
            get { return installerDisplayName; }
            set { installerDisplayName = value; }
        }

        //private string msiFilename;

        //public string MsiFilename
        //{
        //    get { return msiFilename; }
        //    set { msiFilename = value; }
        //}

        private InstallationType(InstallationTypeEnum installationType, string description, string installerMsiApplicationFolder, string installerDisplayName)
        {
            this.id = installationType;
            this.description = description;
            this.installerMsiApplicationFolder = installerMsiApplicationFolder;
            this.installerDisplayName = installerDisplayName;
            //this.msiFilename = msiFilename;
        }

    }
}
