﻿using System;
using System.Collections.Generic;
using System.Text;

namespace VixBuilderBusiness
{
    public interface IDeployRepository
    {
        InfoDelegate Info { get; set; } // used to display a line of text in the main form's info text box
        OutputDelegate Output { get; set; } // used to display combined standard output and error to output text box
        DoEventsDelegate DoEvents { get; set; } // keep the UI responsive
        bool CanRun { get; set; }
        void GetDeployProjects();
        bool UndoFileCheckout(string fileSpec); // true indicates success
        bool CheckoutFile(string fileSpec); // true indicates success
        bool CheckinFile(string filespec, string comment); // true indicates success
        void CopyPayloadArtifacts(); // copy the payload artifacts and directory strucure from the repository to the payload construction directory
        string GetVixInstallerSolutionRootDirspec(); // the absolute dirspec of VixInstallerSolution20xx.root
        string GetVixPayloadRootDirspec(); // the absolute dirspec of Vix Installer Payload Directory
        string GetNextMsiVersion(bool performCheckout); // return the next MSI version number or null
        string GetLocalFolderSpecFromRepositoryWorkspace(string repositoryFileSpec);
    }
}
