﻿using System;
using System.Collections.Generic;
using System.Text;
using log4net;
using System.Diagnostics;
using System.IO;


namespace VixBuilderBusiness
{
    internal class ClearCaseRepository : AbstractRepository, IBuildRepository, IDeployRepository
    {
        private BuildManifest manifest;

        public ClearCaseRepository(BuildConfiguration config)
            : base(config, RepositoryEnum.ClearCase)
        {
            
        }

        #region IBuildRepository

        public DeploymentArtifact[] GetDeploymentArtifacts()
        {
            return this.Manifest.GetRepositoryDeploymentArtifacts();
        }

        /// <summary>
        /// Gets the build manifest.
        /// </summary>
        /// <value>The build manifest.</value>
        /// <remarks>This property is delay initialized because the build manifest should not be accessed until after the ImagingExchange project
        /// has been retrieved from the build repository.</remarks>
        public BuildManifest Manifest
        {
            get
            {
                if (this.manifest == null)
                {
                    this.manifest = GetBuildManifest(); // manifest may not exist until after ImagingExchange has been retrieved from the build repository
                }
                Debug.Assert(this.manifest != null, "No build manifest available");
                return this.manifest;
            }
        }

        public void DeleteBuildProjects()
        {
            throw new NotImplementedException("ClearCaseRepository.DeleteBuildProjects not implemented.");
        }

        public void GetBuildProjects()
        {
            throw new NotImplementedException("ClearCaseRepository.GetBuildProjects not implemented.");
        }

        public void LabelBuildProjects()
        {
            throw new NotImplementedException("ClearCaseRepository.LabelBuildProjects not implemented.");
        }

        public void BranchBuildProjects()
        {
            throw new NotImplementedException("ClearCaseRepository.BranchBuildProjects not implemented.");
        }

        public void DeleteLabelFromBuildProjects()
        {
            throw new NotImplementedException("ClearCaseRepository.DeleteLabelFromBuildProjects not implemented.");
        }

        public override BuildManifest GetBuildManifest()
        {
            string buildManifestFilespec = Path.Combine(Path.Combine(config.ClearCaseRootDirspec, @"VistA_Imaging\Configuration\VisaBuildConfiguration"), config.BuildManifestFilename);
            if (!File.Exists(buildManifestFilespec))
            {
                throw new BuildException("Missing build manifest " + buildManifestFilespec);
            }
            return new BuildManifest(buildManifestFilespec, config);
        }

        //public string GetBuildProjectDirspec(BuildProject buildProject)
        //{
        //    return Path.Combine(this.config.ClearCaseRootDirspec, buildProject.GetProjectRepositoryRelativeDirspec(RepositoryEnum.ClearCase));
        //}

        #endregion

        #region IDeployRepository methods

        /// <summary>
        /// Gets all the deployment projects listed in the build manifest from ClearCase.
        /// </summary>
        public void GetDeployProjects()
        {
            throw new NotImplementedException("ClearCaseRepository.GetDeployProjects not implemented.");
        }

        /// <summary>
        /// Check out a file from ClearCase.
        /// </summary>
        /// <param name="filespec">The file to check out.</param>
        /// <returns>true if sucessful</returns>
        public bool CheckoutFile(string fileSpec)
        {
            throw new NotImplementedException("ClearCaseRepository.CheckoutFile not implemented.");
        }

        /// <summary>
        /// Undo a checkout file operation from VSS.
        /// </summary>
        /// <param name="fileSpec">A filespec constructed using the root of the workspace as the starting point.</param>
        /// <returns>true if sucessful, false otherwise</returns>
        /// <remarks>filespec should be constructed without regard to any working folder mappings that may be present.</remarks>
        public bool UndoFileCheckout(string fileSpec)
        {
            throw new NotImplementedException("ClearCaseRepository.CheckoutFile not implemented.");
        }

        public bool CheckinFile(string filespec, string comment)
        {
            throw new NotImplementedException("ClearCaseRepository.CheckinFile not implemented.");
        }

        /// <summary>
        /// Copies the payload structure and static files from the repository to the payload construction directory.
        /// </summary>
        /// <param name="payloadRootDirspec">The payload construction root dirspec.</param>
        /// <remarks></remarks>
        public void CopyPayloadArtifacts()
        {
            // copy payload skeleton and files from deployment repository
            string payloadRootDirspec = Path.Combine(config.VixPayloadRootDirspec, Manifest.FullyQualifiedPatchNumber);
            string repositoryPayloadRootDirspec = this.GetVixPayloadRootDirspec();
            Debug.Assert(Directory.Exists(repositoryPayloadRootDirspec));
            CopyAll(new DirectoryInfo(repositoryPayloadRootDirspec), new DirectoryInfo(payloadRootDirspec));
        }

        /// <summary>
        ///  // Gets the absolute dirspec of VixInstallerSolution2013.root
        /// </summary>
        /// <remarks></remarks>
        public string GetVixInstallerSolutionRootDirspec()
        {
            DeployProject installerSolutionRootProject = Manifest.GetVixInstallerSolutionRootDeployProject();
            string repositorySolutionRootDirspec = Path.Combine(config.ClearCaseRootDirspec, installerSolutionRootProject.ClearCaseRelativeProjectPath);
            repositorySolutionRootDirspec = Path.Combine(repositorySolutionRootDirspec, installerSolutionRootProject.ProjectName);
            return repositorySolutionRootDirspec;
        }

        /// <summary>
        ///  // Gets the absolute dirspec of Vix Installer payload directory
        /// </summary>
        /// <remarks></remarks>
        public string GetVixPayloadRootDirspec()
        {
            DeployProject installerPayloadRootProject = Manifest.GetPayloadDeployProject();
            string repositoryPayloadRootDirspec = Path.Combine(config.ClearCaseRootDirspec, installerPayloadRootProject.ClearCaseRelativeProjectPath);
            repositoryPayloadRootDirspec = Path.Combine(repositoryPayloadRootDirspec, installerPayloadRootProject.ProjectName);
            return repositoryPayloadRootDirspec;
        }

        /// <summary>
        /// Gets the next msi version from the file specified by the build manifest.
        /// </summary>
        /// <returns>The next MSI version number as a three part string.</returns>
        /// <remarks>As a side effect, the file that holds the last version number is checked out, rewritten with the new version number, and then checked in.</remarks>
        public string GetNextMsiVersion(bool performCheckout)
        {
            throw new NotImplementedException("ClearCaseRepository.GetNextMsiVersion not implemented.");
        }

        public string GetLocalFolderSpecFromRepositoryWorkspace(string repositoryFileSpec)
        {
            throw new NotImplementedException("ClearCaseRepository.GetNextMsiVersion not implemented.");

        }

        #endregion
        
        #region private methods
        
        #endregion

    }
}
