using System;
using System.Collections.Generic;
using System.Text;

namespace VixBuilderBusiness
{
    public enum CheckoutModeEnum { Trunk, Branch, Label };

    public class CheckoutMode
    {
        private static List<CheckoutMode> checkoutModes = null;

        public static CheckoutMode[] GetCheckoutModes()
        {
            if (checkoutModes == null)
            {
                checkoutModes = new List<CheckoutMode>();
                checkoutModes.Add(new CheckoutMode(CheckoutModeEnum.Trunk));
                checkoutModes.Add(new CheckoutMode(CheckoutModeEnum.Branch));
                checkoutModes.Add(new CheckoutMode(CheckoutModeEnum.Label));
            }
            return checkoutModes.ToArray();
        }

        private string description;
        public string Description
        {
            get { return description; }
            set { description = value; }
        }

        private CheckoutModeEnum id;
        public CheckoutModeEnum Id
        {
            get { return id; }
            set { id = value; }
        }

        private CheckoutMode(CheckoutModeEnum action)
        {
            id = action;
            description = action.ToString();
        }

    }
}
