using System;
using System.Collections.Generic;
using System.Text;

namespace VixBuilderBusiness
{
    public enum BuildActionEnum { makeprod, makedev, getBuildProjects, build, getDeployProjects, assembleAndStageMsiPayload, buildMsi, deploytomcat, labelCvsWorkspace,
    makenightly, buildnightly, branchCvsWorkspace, deleteLabelFromCvsWorkspace, updateMsiIdentityAndVersion };

    public class BuildAction
    {
        public static BuildAction[] GetBuildActionSteps()
        {
            List<BuildAction> buildActions = new List<BuildAction>();
            buildActions.Add(new BuildAction(BuildActionEnum.getBuildProjects));
            buildActions.Add(new BuildAction(BuildActionEnum.build));
            buildActions.Add(new BuildAction(BuildActionEnum.getDeployProjects));
            buildActions.Add(new BuildAction(BuildActionEnum.assembleAndStageMsiPayload));
            buildActions.Add(new BuildAction(BuildActionEnum.buildMsi));
            buildActions.Add(new BuildAction(BuildActionEnum.deploytomcat));
            //buildActions.Add(new BuildAction(BuildActionEnum.labelCvsWorkspace));
            //buildActions.Add(new BuildAction(BuildActionEnum.branchCvsWorkspace));
            //buildActions.Add(new BuildAction(BuildActionEnum.deleteLabelFromCvsWorkspace));
            return buildActions.ToArray();
        }

        public static BuildAction[] GetCvsBuildActionSteps()
        {
            List<BuildAction> buildActions = new List<BuildAction>();
            buildActions.Add(new BuildAction(BuildActionEnum.getBuildProjects));
            buildActions.Add(new BuildAction(BuildActionEnum.build));
            buildActions.Add(new BuildAction(BuildActionEnum.getDeployProjects));
            buildActions.Add(new BuildAction(BuildActionEnum.assembleAndStageMsiPayload));
            buildActions.Add(new BuildAction(BuildActionEnum.buildMsi));
            buildActions.Add(new BuildAction(BuildActionEnum.deploytomcat));
            buildActions.Add(new BuildAction(BuildActionEnum.labelCvsWorkspace));
            buildActions.Add(new BuildAction(BuildActionEnum.branchCvsWorkspace));
            buildActions.Add(new BuildAction(BuildActionEnum.deleteLabelFromCvsWorkspace));
            return buildActions.ToArray();
        }

        public static BuildAction[] GetBuildActionGroups()
        {
            List<BuildAction> buildActions = new List<BuildAction>();
            buildActions = new List<BuildAction>();
            buildActions.Add(new BuildAction(BuildActionEnum.makeprod));
            buildActions.Add(new BuildAction(BuildActionEnum.makedev));
            buildActions.Add(new BuildAction(BuildActionEnum.makenightly));
            buildActions.Add(new BuildAction(BuildActionEnum.buildnightly));
            return buildActions.ToArray();
        }

        private string description;

        public string Description
        {
            get { return description; }
            set { description = value; }
        }
        private BuildActionEnum id;

        public BuildActionEnum Id
        {
            get { return id; }
            set { id = value; }
        }

        private BuildAction(BuildActionEnum action)
        {
            id = action;
            description = action.ToString();
        }
    }
}
