using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace VixBuilderBusiness
{
    public static class AssemblyInfoHelper
    {

        public static string GetAssemblyVersion(string filespec)
        {
            string version = null;

            string line;
            using (StreamReader sr = new StreamReader(filespec))
            {
                while ((line = sr.ReadLine()) != null)
                {
                    if (line.StartsWith("[assembly: AssemblyVersion(\""))
                    {
                        line = line.Replace("[assembly: AssemblyVersion(\"", "");
                        version = line.Replace("\")]", "");
                        break;
                    }
                }
                sr.Close();
            }
            return version;
        }

    }
}
