using System;
using System.Text;
using System.Collections.Generic;
using System.Windows.Forms;
using log4net;
using System.IO;
using VixBuilderBusiness;

namespace VixBuilder
{
    static class Program
    {
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main(string[] args)
        {
            if (File.Exists("vix-build-log.txt"))
            {
                File.Delete("vix-build-log.txt");
            }
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);
            log4net.Config.XmlConfigurator.Configure(new System.IO.FileInfo("VixBuilderLog.xml"));
            try
            {
                Application.Run(new VixBuilderForm());
                System.Environment.ExitCode = 0;
            }
            catch (Exception ex)
            {
                Logger().Error(Error(ex.Message));
                System.Environment.ExitCode = 1;
            }
        }

        #region private methods
        private static ILog Logger()
        {
            return LogManager.GetLogger("VixBuilder");
        }

        private static String Error(String errorMessage)
        {
            MessageBox.Show(errorMessage, "Unhandled exception caught by VixBuilder Program.cs", MessageBoxButtons.OK, MessageBoxIcon.Error);
            return errorMessage;
        }

        #endregion
    }
}