/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Sep 24, 2009
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:  vhaiswwerfej
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.vistarad.web;

import gov.va.med.imaging.ImageURN;
import gov.va.med.imaging.core.interfaces.ImageMetadataNotification;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.vistarad.ImagingVistaRadContext;

import java.io.OutputStream;

/**
 * @author vhaiswwerfej
 * 
 * When a BSE token expires, the VIX will respond with a 412 (precondition failed) error message
 *
 */
public class VistaRadExamImageTextFileServlet 
extends AbstractVistaRadExamImageTextFileServlet 
{
	private static final long serialVersionUID = -8147512929921812888L;

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.vistarad.web.AbstractVistaRadExamImageTextFileServlet#getExamImageTextFileByImageUrn(gov.va.med.imaging.ImageURN, gov.va.med.imaging.core.interfaces.ImageMetadataNotification, java.io.OutputStream)
	 */
	@Override
	protected int getExamImageTextFileByImageUrn(ImageURN imageUrn,
		ImageMetadataNotification metadataCallback, OutputStream outStream)
	throws MethodException, ConnectionException
	{
		return ImagingVistaRadContext.getVistaRadRouter().getExamTextFileByImageUrn(imageUrn, 
			metadataCallback, outStream);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.vistarad.web.AbstractVistaRadExamImageTextFileServlet#getOperationTypeDetails()
	 */
	@Override
	protected String getOperationTypeDetails()
	{
		return "";
	}
}
