/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Oct 1, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author       DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
 package gov.va.med.imaging.vistarad;
 
 import java.util.Date;
 import org.apache.log4j.*;
 import gov.va.med.imaging.*;
 import gov.va.med.imaging.core.interfaces.exceptions.*;
 import gov.va.med.imaging.core.interfaces.router.Command;
 import gov.va.med.imaging.core.interfaces.router.CommandFactory;
 import gov.va.med.imaging.core.CommandFactoryImpl;
 import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
 import gov.va.med.exceptions.ValidationException;
 import javax.annotation.Generated;
 import gov.va.med.imaging.core.interfaces.router.CommandContext;

 import gov.va.med.imaging.exchange.business.*;
 import gov.va.med.imaging.exchange.business.dicom.*;
 import gov.va.med.imaging.exchange.business.vistarad.*;
 import gov.va.med.imaging.artifactsource.*;
 
 /*
 * This is generated code and is recreated on every build.
 * Do not make changes directly in this code, as they will be lost (without warning).
 * Changes may be made to the template that generated this code (FacadeRouterImpl.ftl in
 * the CoreRouterAnnotationProcessor project), such changes will be reflected in
 * all facade router implementations.
 * 
 * This code was generated using FreeMarker, an open-source template processing engine.
 * See http://www.freemarker.org for documentation on the template syntax.
 */
 @Generated(value="gov.va.med.imaging.core.codegenerator.FacadeRouterCodeGenerator")
 public class VistaRadRouterTest
 //extends gov.va.med.imaging.core.interfaces.router.AbstractFacadeRouterImpl 
 {
	
 	private Logger logger = Logger.getLogger(this.getClass());
 	
 	private Logger getLogger()
 	{
 		return logger;
 	}
 	
 	private CommandFactory commandFactory = new CommandFactoryImpl((CommandContext)null);
 	private CommandFactory getCommandFactory()
 	{
 		return commandFactory;
 	}
 
 	/**
 	* The constructor is public so this tester can be created to test
 	*/
 	public VistaRadRouterTest()
 	{
 		super();
 	}
 
 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPatientEnterpriseExams(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String patientId
 		 			, java.lang.Boolean fullyLoaded
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPatientEnterpriseExamsCommand' and parameters 'gov.va.med.RoutingToken, java.lang.String, java.lang.Boolean'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.vistarad.PatientEnterpriseExams.class, 
	 				"GetPatientEnterpriseExamsCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class, java.lang.Boolean.class 
		  			},
 					new Object[]{
				 		routingToken,patientId,fullyLoaded
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetPatientEnterpriseExamsCommand' in method 'getPatientEnterpriseExams' with parameters 'gov.va.med.RoutingToken, java.lang.String, java.lang.Boolean'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExam(
 			gov.va.med.imaging.StudyURN studyUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetExamCommand' and parameters 'gov.va.med.imaging.StudyURN'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.vistarad.Exam.class, 
	 				"GetExamCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.StudyURN.class 
		  			},
 					new Object[]{
				 		studyUrn
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetExamCommand' in method 'getExam' with parameters 'gov.va.med.imaging.StudyURN'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExamReport(
 			gov.va.med.imaging.StudyURN studyUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetExamReportCommand' and parameters 'gov.va.med.imaging.StudyURN'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.String.class, 
	 				"GetExamReportCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.StudyURN.class 
		  			},
 					new Object[]{
				 		studyUrn
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetExamReportCommand' in method 'getExamReport' with parameters 'gov.va.med.imaging.StudyURN'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExamRequisitionReport(
 			gov.va.med.imaging.StudyURN studyUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetExamRequisitionReportCommand' and parameters 'gov.va.med.imaging.StudyURN'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.String.class, 
	 				"GetExamRequisitionReportCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.StudyURN.class 
		  			},
 					new Object[]{
				 		studyUrn
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetExamRequisitionReportCommand' in method 'getExamRequisitionReport' with parameters 'gov.va.med.imaging.StudyURN'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getActiveExamsWorklist(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String listDescriptor
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetActiveWorklistCommand' and parameters 'gov.va.med.RoutingToken, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.vistarad.ActiveExams.class, 
	 				"GetActiveWorklistCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,listDescriptor
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetActiveWorklistCommand' in method 'getActiveExamsWorklist' with parameters 'gov.va.med.RoutingToken, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExamTextFiles(
 			gov.va.med.imaging.StudyURN studyUrn
 		 			, java.io.OutputStream output
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetExamTextFilesCommand' and parameters 'gov.va.med.imaging.StudyURN, java.io.OutputStream'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Long.class, 
	 				"GetExamTextFilesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.StudyURN.class, java.io.OutputStream.class 
		  			},
 					new Object[]{
				 		studyUrn,output
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetExamTextFilesCommand' in method 'getExamTextFiles' with parameters 'gov.va.med.imaging.StudyURN, java.io.OutputStream'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExamTextFileByImageUrn(
 			gov.va.med.imaging.ImageURN imageUrn
 		 			, gov.va.med.imaging.core.interfaces.ImageMetadataNotification metadataCallback
 		 			, java.io.OutputStream outStream
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetExamTextFileByImageUrnCommand' and parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.core.interfaces.ImageMetadataNotification, java.io.OutputStream'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Integer.class, 
	 				"GetExamTextFileByImageUrnCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.core.interfaces.ImageMetadataNotification.class, java.io.OutputStream.class 
		  			},
 					new Object[]{
				 		imageUrn,metadataCallback,outStream
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetExamTextFileByImageUrnCommand' in method 'getExamTextFileByImageUrn' with parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.core.interfaces.ImageMetadataNotification, java.io.OutputStream'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExamTextFileFromCacheByImageUrn(
 			gov.va.med.imaging.ImageURN imageUrn
 		 			, gov.va.med.imaging.core.interfaces.ImageMetadataNotification metadataCallback
 		 			, java.io.OutputStream outStream
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetExamTextFileFromCacheByImageUrnCommand' and parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.core.interfaces.ImageMetadataNotification, java.io.OutputStream'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Integer.class, 
	 				"GetExamTextFileFromCacheByImageUrnCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.core.interfaces.ImageMetadataNotification.class, java.io.OutputStream.class 
		  			},
 					new Object[]{
				 		imageUrn,metadataCallback,outStream
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetExamTextFileFromCacheByImageUrnCommand' in method 'getExamTextFileFromCacheByImageUrn' with parameters 'gov.va.med.imaging.ImageURN, gov.va.med.imaging.core.interfaces.ImageMetadataNotification, java.io.OutputStream'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExamSiteBySiteNumber(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String patientId
 		 			, java.lang.Boolean forceRefresh
 		 			, java.lang.Boolean forceImagesFromJb
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetExamSiteBySiteNumberCommand' and parameters 'gov.va.med.RoutingToken, java.lang.String, java.lang.Boolean, java.lang.Boolean'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.vistarad.ExamSite.class, 
	 				"GetExamSiteBySiteNumberCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class, java.lang.Boolean.class, java.lang.Boolean.class 
		  			},
 					new Object[]{
				 		routingToken,patientId,forceRefresh,forceImagesFromJb
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetExamSiteBySiteNumberCommand' in method 'getExamSiteBySiteNumber' with parameters 'gov.va.med.RoutingToken, java.lang.String, java.lang.Boolean, java.lang.Boolean'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getSiteConnectivityStatus(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetVistaRadSiteConnectivityStatusCommand' and parameters 'gov.va.med.RoutingToken'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.enums.SiteConnectivityStatus.class, 
	 				"GetVistaRadSiteConnectivityStatusCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class 
		  			},
 					new Object[]{
				 		routingToken
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetVistaRadSiteConnectivityStatusCommand' in method 'getSiteConnectivityStatus' with parameters 'gov.va.med.RoutingToken'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postPassthroughMethod(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.exchange.business.PassthroughInputMethod inputMethod
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostPassthroughMethodCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.business.PassthroughInputMethod'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.String.class, 
	 				"PostPassthroughMethodCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.business.PassthroughInputMethod.class 
		  			},
 					new Object[]{
				 		routingToken,inputMethod
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostPassthroughMethodCommand' in method 'postPassthroughMethod' with parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.exchange.business.PassthroughInputMethod'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getExamsCacheStatus(
 			java.lang.String patientIcn
 		 			, gov.va.med.RoutingToken[] routingTokens
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetExamSiteCachedBySiteNumberCommand' and parameters 'java.lang.String, gov.va.med.RoutingToken[]'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.vistarad.ExamSiteCachedStatus.class, 
 				"GetExamSiteCachedBySiteNumberCommand",
 				"",
				new Class<?>[]{
				 	java.lang.String.class, gov.va.med.RoutingToken[].class 
	  			},
				new Object[]{
			 		patientIcn,routingTokens
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetExamSiteCachedBySiteNumberCommand' in method 'getExamsCacheStatus' with parameters 'java.lang.String, gov.va.med.RoutingToken[]'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postExamAccessEvent(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String inputParameter
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostExamAccessEventCommand' and parameters 'gov.va.med.RoutingToken, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"PostExamAccessEventCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,inputParameter
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostExamAccessEventCommand' in method 'postExamAccessEvent' with parameters 'gov.va.med.RoutingToken, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void prefetchExamImages(
 			gov.va.med.imaging.StudyURN studyUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PrefetchExamImagesCommand' and parameters 'gov.va.med.imaging.StudyURN'.");
				boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Void.class, 
	 				"PrefetchExamImagesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.StudyURN.class 
		  			},
 					new Object[]{
				 		studyUrn
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PrefetchExamImagesCommand'.");		  		
 		}

 }