/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Oct 1, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author       DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
 package gov.va.med.imaging.vistarad;
 
 import java.util.Date;
 import org.apache.log4j.*;
 import gov.va.med.imaging.*;
 import gov.va.med.imaging.core.interfaces.exceptions.*;
 import gov.va.med.imaging.core.interfaces.router.Command;
 import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
 import javax.annotation.Generated;
 import gov.va.med.imaging.exchange.business.*;
 import gov.va.med.imaging.exchange.business.dicom.*;
 import gov.va.med.imaging.exchange.business.vistarad.*;
 import gov.va.med.imaging.artifactsource.*;
 
 /*
 * This is generated code and is recreated on every build.
 * Do not make changes directly in this code, as they will be lost (without warning).
 * Changes may be made to the template that generated this code (FacadeRouterImpl.ftl in
 * the CoreRouterAnnotationProcessor project), such changes will be reflected in
 * all facade router implementations.
 * 
 * This code was generated using FreeMarker, an open-source template processing engine.
 * See http://www.freemarker.org for documentation on the template syntax.
 */
 @Generated(value="gov.va.med.imaging.core.codegenerator.FacadeRouterCodeGenerator")
 public class VistaRadRouterImpl
 extends gov.va.med.imaging.core.interfaces.router.AbstractFacadeRouterImpl 
 implements VistaRadRouter
 {
	private static VistaRadRouterImpl singleton;
 
 	/*
 	* The getSingleton() method is the only way to get a reference to the router facade.
 	*/
 	public static synchronized VistaRadRouter getSingleton()
	{
		if(singleton == null)  
			singleton = new VistaRadRouterImpl();
		
		return singleton; 
	} 
 
 	private Logger logger = Logger.getLogger(this.getClass());
 	
 	private Logger getLogger()
 	{
 		return logger;
 	}
 
 	/**
 	* The constructor is protected because the class may be derived from.
 	*/
 	protected VistaRadRouterImpl()
 	{
 		super();
 	}
 
 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.vistarad.PatientEnterpriseExams getPatientEnterpriseExams(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String patientId
 		 			, java.lang.Boolean fullyLoaded
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.vistarad.PatientEnterpriseExams> command = (Command<gov.va.med.imaging.exchange.business.vistarad.PatientEnterpriseExams>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.vistarad.PatientEnterpriseExams.class, 
	 				"GetPatientEnterpriseExamsCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class, java.lang.Boolean.class 
		  			},
 					new Object[]{
				 		routingToken,patientId,fullyLoaded
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetPatientEnterpriseExamsCommand");
		
      
        gov.va.med.imaging.exchange.business.vistarad.PatientEnterpriseExams commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.vistarad.Exam getExam(
 			gov.va.med.imaging.StudyURN studyUrn
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.vistarad.Exam> command = (Command<gov.va.med.imaging.exchange.business.vistarad.Exam>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.vistarad.Exam.class, 
	 				"GetExamCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.StudyURN.class 
		  			},
 					new Object[]{
				 		studyUrn
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetExamCommand");
		
      
        gov.va.med.imaging.exchange.business.vistarad.Exam commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.String getExamReport(
 			gov.va.med.imaging.StudyURN studyUrn
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.String> command = (Command<java.lang.String>)getCommandFactory().createCommand(
	 				 java.lang.String.class, 
	 				"GetExamReportCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.StudyURN.class 
		  			},
 					new Object[]{
				 		studyUrn
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetExamReportCommand");
		
      
        java.lang.String commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.String getExamRequisitionReport(
 			gov.va.med.imaging.StudyURN studyUrn
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.String> command = (Command<java.lang.String>)getCommandFactory().createCommand(
	 				 java.lang.String.class, 
	 				"GetExamRequisitionReportCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.StudyURN.class 
		  			},
 					new Object[]{
				 		studyUrn
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetExamRequisitionReportCommand");
		
      
        java.lang.String commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.vistarad.ActiveExams getActiveExamsWorklist(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String listDescriptor
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.vistarad.ActiveExams> command = (Command<gov.va.med.imaging.exchange.business.vistarad.ActiveExams>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.vistarad.ActiveExams.class, 
	 				"GetActiveWorklistCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,listDescriptor
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetActiveWorklistCommand");
		
      
        gov.va.med.imaging.exchange.business.vistarad.ActiveExams commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Long getExamTextFiles(
 			gov.va.med.imaging.StudyURN studyUrn
 		 			, java.io.OutputStream output
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Long> command = (Command<java.lang.Long>)getCommandFactory().createCommand(
	 				 java.lang.Long.class, 
	 				"GetExamTextFilesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.StudyURN.class, java.io.OutputStream.class 
		  			},
 					new Object[]{
				 		studyUrn,output
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetExamTextFilesCommand");
		
      
        java.lang.Long commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Integer getExamTextFileByImageUrn(
 			gov.va.med.imaging.ImageURN imageUrn
 		 			, gov.va.med.imaging.core.interfaces.ImageMetadataNotification metadataCallback
 		 			, java.io.OutputStream outStream
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Integer> command = (Command<java.lang.Integer>)getCommandFactory().createCommand(
	 				 java.lang.Integer.class, 
	 				"GetExamTextFileByImageUrnCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.core.interfaces.ImageMetadataNotification.class, java.io.OutputStream.class 
		  			},
 					new Object[]{
				 		imageUrn,metadataCallback,outStream
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetExamTextFileByImageUrnCommand");
		
      
        java.lang.Integer commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Integer getExamTextFileFromCacheByImageUrn(
 			gov.va.med.imaging.ImageURN imageUrn
 		 			, gov.va.med.imaging.core.interfaces.ImageMetadataNotification metadataCallback
 		 			, java.io.OutputStream outStream
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Integer> command = (Command<java.lang.Integer>)getCommandFactory().createCommand(
	 				 java.lang.Integer.class, 
	 				"GetExamTextFileFromCacheByImageUrnCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.ImageURN.class, gov.va.med.imaging.core.interfaces.ImageMetadataNotification.class, java.io.OutputStream.class 
		  			},
 					new Object[]{
				 		imageUrn,metadataCallback,outStream
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetExamTextFileFromCacheByImageUrnCommand");
		
      
        java.lang.Integer commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.vistarad.ExamSite getExamSiteBySiteNumber(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String patientId
 		 			, java.lang.Boolean forceRefresh
 		 			, java.lang.Boolean forceImagesFromJb
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.vistarad.ExamSite> command = (Command<gov.va.med.imaging.exchange.business.vistarad.ExamSite>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.vistarad.ExamSite.class, 
	 				"GetExamSiteBySiteNumberCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class, java.lang.Boolean.class, java.lang.Boolean.class 
		  			},
 					new Object[]{
				 		routingToken,patientId,forceRefresh,forceImagesFromJb
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetExamSiteBySiteNumberCommand");
		
      
        gov.va.med.imaging.exchange.business.vistarad.ExamSite commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.enums.SiteConnectivityStatus getSiteConnectivityStatus(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.enums.SiteConnectivityStatus> command = (Command<gov.va.med.imaging.exchange.enums.SiteConnectivityStatus>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.enums.SiteConnectivityStatus.class, 
	 				"GetVistaRadSiteConnectivityStatusCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class 
		  			},
 					new Object[]{
				 		routingToken
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetVistaRadSiteConnectivityStatusCommand");
		
      
        gov.va.med.imaging.exchange.enums.SiteConnectivityStatus commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.String postPassthroughMethod(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.exchange.business.PassthroughInputMethod inputMethod
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.String> command = (Command<java.lang.String>)getCommandFactory().createCommand(
	 				 java.lang.String.class, 
	 				"PostPassthroughMethodCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.exchange.business.PassthroughInputMethod.class 
		  			},
 					new Object[]{
				 		routingToken,inputMethod
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostPassthroughMethodCommand");
		
      
        java.lang.String commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.exchange.business.vistarad.ExamSiteCachedStatus> getExamsCacheStatus(
 			java.lang.String patientIcn
 		 			, gov.va.med.RoutingToken[] routingTokens
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.vistarad.ExamSiteCachedStatus.class, 
 				"GetExamSiteCachedBySiteNumberCommand",
 				"",
				new Class<?>[]{
				 	java.lang.String.class, gov.va.med.RoutingToken[].class 
	  			},
				new Object[]{
			 		patientIcn,routingTokens
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetExamSiteCachedBySiteNumberCommand");
		
      
			java.util.List<gov.va.med.imaging.exchange.business.vistarad.ExamSiteCachedStatus> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Boolean postExamAccessEvent(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String inputParameter
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Boolean> command = (Command<java.lang.Boolean>)getCommandFactory().createCommand(
	 				 java.lang.Boolean.class, 
	 				"PostExamAccessEventCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,inputParameter
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostExamAccessEventCommand");
		
      
        java.lang.Boolean commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void prefetchExamImages(
 			gov.va.med.imaging.StudyURN studyUrn
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Void> command = (Command<java.lang.Void>)getCommandFactory().createCommand(
	 				 java.lang.Void.class, 
	 				"PrefetchExamImagesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.StudyURN.class 
		  			},
 					new Object[]{
				 		studyUrn
		  			}
		  		);
		  		
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PrefetchExamImagesCommand");
		
		      
		        getRouter().doSynchronously(command);
				return;
 		}

 }