/**
 * 
 * Property of ISI Group, LLC
 * Date Created: Aug 25, 2014
 * Developer: Julian Werfel
 */
package gov.va.med.imaging.study.web.rest;

import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.study.web.commands.GetHydraStudiesByCrpsIdentifierCommand;
import gov.va.med.imaging.study.web.commands.GetPatientStudiesCommand;
import gov.va.med.imaging.study.web.commands.GetStudiesByCprsIdentifierCommand;
import gov.va.med.imaging.study.web.commands.GetUserTokenCommand;
import gov.va.med.imaging.study.web.rest.types.ViewerStudyFilterType;
import gov.va.med.imaging.web.rest.exceptions.AbstractRestService;

import java.util.Date;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

/**
 * @author Julian
 *
 */
@Path("study")
public class ViewerStudyService
extends AbstractRestService
{
	@GET
	@Path("cprs/{siteId}")
	@Produces(MediaType.APPLICATION_XML)
	public Response getStudiesFromCprsIdentifier(
		@PathParam("siteId") String siteId,
		@QueryParam("icn") String patientIcn,
		@QueryParam("cprsIdentifier") String cprsIdentifier)
	throws MethodException, ConnectionException
	{		
		return wrapResultWithResponseHeaders(new GetStudiesByCprsIdentifierCommand(siteId, patientIcn, cprsIdentifier).execute());
	}
	
	@GET
	@Path("studies/{siteId}")
	@Produces(MediaType.APPLICATION_XML)
	public Response getPatientStudies(
		@PathParam("siteId") String siteId,
		@QueryParam("icn") String patientIcn)
	throws MethodException, ConnectionException
	{		
		return wrapResultWithResponseHeaders(new GetPatientStudiesCommand(siteId, patientIcn, null).execute());
	}
	
	@POST
	@Path("studies/{siteId}")
	@Produces(MediaType.APPLICATION_XML)
	@Consumes(MediaType.APPLICATION_XML)
	public Response getPatientStudies(
		@PathParam("siteId") String siteId,
		@QueryParam("icn") String patientIcn,
		ViewerStudyFilterType filter)
	throws MethodException, ConnectionException
	{
		return wrapResultWithResponseHeaders(new GetPatientStudiesCommand(siteId, patientIcn, filter).execute());
	}
	
	@GET
	@Path("cprs/hydra/{siteId}")
	@Produces(MediaType.APPLICATION_XML)
	public Response getStudiesFromCprsIdentifierInHydraForm(
		@PathParam("siteId") String siteId,
		@QueryParam("icn") String patientIcn,
		@QueryParam("cprsIdentifier") String cprsIdentifier)
	throws MethodException, ConnectionException
	{
		return wrapResultWithResponseHeaders(new GetHydraStudiesByCrpsIdentifierCommand(siteId, patientIcn, cprsIdentifier).execute());
	}
	
	@GET
	@Path("user/token")
	@Produces(MediaType.APPLICATION_XML)
	public Response createToken()
	throws MethodException, ConnectionException
	{
		// must be in here using a secure method
		return wrapResultWithResponseHeaders(new GetUserTokenCommand().execute());
	}
	
	@GET
	@Path("filter")
	@Produces(MediaType.APPLICATION_XML)
	public Response getFilter()
	throws MethodException, ConnectionException
	{
		// must be in here using a secure method
		ViewerStudyFilterType filter = new ViewerStudyFilterType();
		filter.setFilterClass("FilterClass");
		filter.setFilterEvent("FilterEvent");
		filter.setFilterOrigin("FilterOrigin");
		filter.setFilterPackage("FilterPackage");
		filter.setFilterSpecialty("FilterSpecialty");
		filter.setFilterType("FilterType");
		filter.setFromDate(new Date());
		filter.setToDate(new Date());
		return wrapResultWithResponseHeaders(filter);
	}

}
