/**
 * 
 * Property of ISI Group, LLC
 * Date Created: Aug 25, 2014
 * Developer: Julian Werfel
 */
package gov.va.med.imaging.study.web.configuration;

import gov.va.med.imaging.facade.configuration.FacadeConfigurationFactory;
import gov.va.med.imaging.facade.configuration.exceptions.CannotLoadConfigurationException;
import gov.va.med.imaging.webservices.clinical.AbstractClinicalWebAppConfiguration;

/**
 * @author Julian
 *
 */
public class ViewerStudyFacadeConfiguration
extends AbstractClinicalWebAppConfiguration
{
	
	public ViewerStudyFacadeConfiguration()
	{
		super(true);
	}
	
	
	public synchronized static ViewerStudyFacadeConfiguration getConfiguration()
	{
		try
		{
			return FacadeConfigurationFactory.getConfigurationFactory().getConfiguration(ViewerStudyFacadeConfiguration.class);
		}
		catch(CannotLoadConfigurationException clcX)
		{
			// no need to log, already logged
			return null;
		}
	}

}
