/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Oct 1, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author      DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone DNS.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
 package gov.va.med.imaging.user;
 
 import java.util.Date;
 import org.apache.log4j.*;
 import gov.va.med.imaging.*;
 import gov.va.med.imaging.core.interfaces.exceptions.*;
 import gov.va.med.imaging.core.interfaces.router.Command;
 import gov.va.med.imaging.core.interfaces.router.CommandFactory;
 import gov.va.med.imaging.core.CommandFactoryImpl;
 import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
 import gov.va.med.exceptions.ValidationException;
 import javax.annotation.Generated;
 import gov.va.med.imaging.core.interfaces.router.CommandContext;

 import gov.va.med.imaging.exchange.business.*;
 import gov.va.med.imaging.exchange.business.dicom.*;
 import gov.va.med.imaging.exchange.business.vistarad.*;
 import gov.va.med.imaging.artifactsource.*;
 
 /*
 * This is generated code and is recreated on every build.
 * Do not make changes directly in this code, as they will be lost (without warning).
 * Changes may be made to the template that generated this code (FacadeRouterImpl.ftl in
 * the CoreRouterAnnotationProcessor project), such changes will be reflected in
 * all facade router implementations.
 * 
 * This code was generated using FreeMarker, an open-source template processing engine.
 * See http://www.freemarker.org for documentation on the template syntax.
 */
 @Generated(value="gov.va.med.imaging.core.codegenerator.FacadeRouterCodeGenerator")
 public class UserRouterTest
 //extends gov.va.med.imaging.core.interfaces.router.AbstractFacadeRouterImpl 
 {
	
 	private Logger logger = Logger.getLogger(this.getClass());
 	
 	private Logger getLogger()
 	{
 		return logger;
 	}
 	
 	private CommandFactory commandFactory = new CommandFactoryImpl((CommandContext)null);
 	private CommandFactory getCommandFactory()
 	{
 		return commandFactory;
 	}
 
 	/**
 	* The constructor is public so this tester can be created to test
 	*/
 	public UserRouterTest()
 	{
 		super();
 	}
 
 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getWelcomeMessage(
 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetWelcomeMessageCommand' and parameters ''.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.WelcomeMessage.class, 
	 				"GetWelcomeMessageCommand",
	 				"",
 					new Class<?>[]{
				 		  
		  			},
 					new Object[]{
				 		
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetWelcomeMessageCommand' in method 'getWelcomeMessage' with parameters ''.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getUserKeys(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetUserKeysCommand' and parameters 'gov.va.med.RoutingToken'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 java.lang.String.class, 
 				"GetUserKeysCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class 
	  			},
				new Object[]{
			 		routingToken
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetUserKeysCommand' in method 'getUserKeys' with parameters 'gov.va.med.RoutingToken'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getDivisionList(
 			java.lang.String accessCode
 		 			, gov.va.med.RoutingToken routingToken
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetDivisionListCommand' and parameters 'java.lang.String, gov.va.med.RoutingToken'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.Division.class, 
 				"GetDivisionListCommand",
 				"",
				new Class<?>[]{
				 	java.lang.String.class, gov.va.med.RoutingToken.class 
	  			},
				new Object[]{
			 		accessCode,routingToken
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetDivisionListCommand' in method 'getDivisionList' with parameters 'java.lang.String, gov.va.med.RoutingToken'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void verifyElectronicSignature(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String electronicSignature
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetVerifyElectronicSignatureCommand' and parameters 'gov.va.med.RoutingToken, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.ElectronicSignatureResult.class, 
	 				"GetVerifyElectronicSignatureCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,electronicSignature
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetVerifyElectronicSignatureCommand' in method 'verifyElectronicSignature' with parameters 'gov.va.med.RoutingToken, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getApplicationTimeoutParameters(
 			java.lang.String siteId
 		 			, java.lang.String applicationName
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetApplicationTimeoutParametersCommand' and parameters 'java.lang.String, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.ApplicationTimeoutParameters.class, 
	 				"GetApplicationTimeoutParametersCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		siteId,applicationName
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetApplicationTimeoutParametersCommand' in method 'getApplicationTimeoutParameters' with parameters 'java.lang.String, java.lang.String'.");
 		}

 }