/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Mar 16, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.study.rest;

import gov.va.med.PatientIdentifier;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.rest.types.RestStringType;
import gov.va.med.imaging.study.commands.StudyGetPatientStudiesCommand;
import gov.va.med.imaging.study.commands.StudyGetStudiesCommand;
import gov.va.med.imaging.study.commands.StudyGetStudyCommand;
import gov.va.med.imaging.study.commands.StudyGetStudyReportCommand;
import gov.va.med.imaging.study.rest.types.LoadedStudyType;
import gov.va.med.imaging.study.rest.types.StudiesResultType;
import gov.va.med.imaging.study.rest.types.StudyFilterType;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

/**
 * @author       DNS
 *
 */
@Path("")
public class StudyService
{
	
	@POST
	@Path("studies/va/icn/{treatingFacilitySiteId}/{patientIcn}")
	@Produces(MediaType.APPLICATION_XML)
	@Consumes(MediaType.APPLICATION_XML)
	public StudiesResultType getVaPatientStudiesFromIcn(
			@PathParam("treatingFacilitySiteId") String treatingFacilitySiteId,
			@PathParam("patientIcn") String patientIcn,
			StudyFilterType studyFilterType)
	throws MethodException, ConnectionException
	{
		return new StudyGetPatientStudiesCommand(treatingFacilitySiteId,
				PatientIdentifier.icnPatientIdentifier(patientIcn),
				studyFilterType).execute();
	}
	
	@GET
	@Path("studies/va/icn/{treatingFacilitySiteId}/{patientIcn}")
	@Produces(MediaType.APPLICATION_XML)
	public StudiesResultType getVaPatientStudiesFromIcn(
			@PathParam("treatingFacilitySiteId") String treatingFacilitySiteId,
			@PathParam("patientIcn") String patientIcn)
	throws MethodException, ConnectionException
	{
		return getVaPatientStudiesFromIcn(treatingFacilitySiteId, 
				patientIcn, null);
	}
	
	@POST
	@Path("studies/site/icn/{siteId}/{patientIcn}")
	@Produces(MediaType.APPLICATION_XML)
	@Consumes(MediaType.APPLICATION_XML)
	public StudiesResultType getPatientStudiesFromIcn(
			@PathParam("siteId") String siteId,
			@PathParam("patientIcn") String patientIcn,
			StudyFilterType studyFilterType)
	throws MethodException, ConnectionException
	{
		return new StudyGetStudiesCommand(siteId,
				PatientIdentifier.icnPatientIdentifier(patientIcn),
				studyFilterType).execute();
	}
	
	@GET
	@Path("studies/site/icn/{siteId}/{patientIcn}")
	@Produces(MediaType.APPLICATION_XML)
	public StudiesResultType getPatientStudiesFromIcn(
			@PathParam("siteId") String siteId,
			@PathParam("patientIcn") String patientIcn)
	throws MethodException, ConnectionException
	{
		return new StudyGetStudiesCommand(siteId,
				PatientIdentifier.icnPatientIdentifier(patientIcn),
				null).execute();
	}
	
	@POST
	@Path("studies/local/dfn/{patientDfn}")
	@Produces(MediaType.APPLICATION_XML)
	@Consumes(MediaType.APPLICATION_XML)
	public StudiesResultType getLocalPatientStudiesFromDfn(
			@PathParam("patientDfn") String patientDfn,
			StudyFilterType studyFilterType)
	throws MethodException, ConnectionException
	{
		return new StudyGetStudiesCommand(null,
				PatientIdentifier.dfnPatientIdentifier(patientDfn),
				studyFilterType).execute();
	}
	
	@GET
	@Path("studies/local/dfn/{patientDfn}")
	@Produces(MediaType.APPLICATION_XML)
	public StudiesResultType getLocalPatientStudiesFromDfn(
			@PathParam("patientDfn") String patientDfn)
	throws MethodException, ConnectionException
	{
		return new StudyGetStudiesCommand(null,
				PatientIdentifier.dfnPatientIdentifier(patientDfn),
				null).execute();
	}
	
	@GET
	@Path("study/{studyId}")
	@Produces(MediaType.APPLICATION_XML)
	public LoadedStudyType getStudy(
			@PathParam("studyId") String studyId)
	throws MethodException, ConnectionException
	{
		return new StudyGetStudyCommand(studyId).execute();
	}
	
	@GET
	@Path("study/report/{studyId}")
	@Produces(MediaType.APPLICATION_XML)
	public RestStringType getStudyReport(
			@PathParam("studyId") String studyId)
	throws MethodException, ConnectionException
	{
		return new StudyGetStudyReportCommand(studyId).execute();
	}

	/*
	@GET
	@Path("filter")
	@Produces(MediaType.APPLICATION_XML)
	public StudyFilterType getFilter()
	{
		
		
		StudyFilterType filter = new StudyFilterType();
		Calendar fromDate = Calendar.getInstance();
		fromDate.set(Calendar.YEAR, 2010);
		fromDate.set(Calendar.MONTH, 0);
		fromDate.set(Calendar.DAY_OF_MONTH, 1);
		
		filter.setFromDate(fromDate.getTime());
		filter.setToDate(Calendar.getInstance().getTime());
		filter.setResultType(StudyFilterResultType.all);
		return filter;
	}
	
	@POST
	@Path("filter")
	@Consumes(MediaType.APPLICATION_XML)
	@Produces(MediaType.TEXT_PLAIN)
	public String setFilter(StudyFilterType filter)
	{
		return filter.getFromDate().toString();
	}*/
}
