/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Jan 2, 2013
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:       DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.study.commands;

import java.util.HashMap;
import java.util.Map;

import gov.va.med.SERIALIZATION_FORMAT;
import gov.va.med.URNFactory;
import gov.va.med.imaging.BhieStudyURN;
import gov.va.med.imaging.StudyURN;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.exchange.business.Study;
import gov.va.med.imaging.exchange.translation.exceptions.TranslationException;
import gov.va.med.imaging.rest.types.RestStringType;
import gov.va.med.imaging.study.StudyFacadeRouter;
import gov.va.med.imaging.web.commands.WebserviceInputParameterTransactionContextField;

/**
 * @author       DNS
 *
 */
public class StudyGetStudyReportCommand
extends AbstractStudyCommand<String, RestStringType>
{
	private final String studyId;

	/**
	 * @param methodName
	 */
	public StudyGetStudyReportCommand(String studyId)
	{
		super("getStudy");
		this.studyId = studyId;
	}

	/**
	 * @return the studyId
	 */
	public String getStudyId()
	{
		return studyId;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#executeRouterCommand()
	 */
	@Override
	protected String executeRouterCommand() 
	throws MethodException, ConnectionException
	{
		checkCommandEnabled();
		StudyURN studyUrn = null;
		try
		{
			// create either a StudyURN or a BhieStudyURn depending on the community ID
			// found in the study ID string
			studyUrn = URNFactory.create(studyId, SERIALIZATION_FORMAT.CDTP, StudyURN.class);
		}
		catch (Throwable x)
		{
			getLogger().error(x);
			throw new MethodException(x);
		}
		Study study = null;
		
		StudyFacadeRouter rtr = getRouter(); 
		if(studyUrn instanceof StudyURN)
		{
			// update the transaction context with patientId
			getTransactionContext().setPatientID(((StudyURN)studyUrn).getPatientId());
			study = rtr.getStudy((StudyURN)studyUrn);
		}
		else if(studyUrn instanceof BhieStudyURN)
		{
			// update the transaction context with patientId
			getTransactionContext().setPatientID(((BhieStudyURN)studyUrn).getPatientId());
			study = rtr.getPatientStudy((BhieStudyURN)studyUrn);
		}
		
		if(study != null)
		{
			getTransactionContext().setFacadeBytesSent(study.getRadiologyReport() == null ? 0L : study.getRadiologyReport().length());
			return study.getRadiologyReport();
		}		
		getLogger().warn("Got null study back from router for study Id '" + getStudyId() + "', returning null report.");
		return null;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#getMethodParameterValuesString()
	 */
	@Override
	protected String getMethodParameterValuesString()
	{
		return "for study '" + getStudyId() + "'";
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#translateRouterResult(java.lang.Object)
	 */
	@Override
	protected RestStringType translateRouterResult(String routerResult)
	throws TranslationException, MethodException
	{
		return new RestStringType(routerResult);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#getResultClass()
	 */
	@Override
	protected Class<RestStringType> getResultClass()
	{
		return RestStringType.class;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#getTransactionContextFields()
	 */
	@Override
	protected Map<WebserviceInputParameterTransactionContextField, String> getTransactionContextFields()
	{
		Map<WebserviceInputParameterTransactionContextField, String> transactionContextFields = 
				new HashMap<WebserviceInputParameterTransactionContextField, String>();
			
			transactionContextFields.put(WebserviceInputParameterTransactionContextField.quality, transactionContextNaValue);
			transactionContextFields.put(WebserviceInputParameterTransactionContextField.urn, getStudyId());
			transactionContextFields.put(WebserviceInputParameterTransactionContextField.queryFilter, transactionContextNaValue);

			return transactionContextFields;
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.web.commands.AbstractWebserviceCommand#getEntriesReturned(java.lang.Object)
	 */
	@Override
	public Integer getEntriesReturned(RestStringType translatedResult)
	{
		return null;
	}

	@Override
	protected boolean isRequiresEnterprise()
	{
		return false;
	}

	@Override
	protected boolean isRequiresLocal()
	{
		return false;
	}

}
