/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Jun 10, 2013
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone DNS
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.study;

import gov.va.med.imaging.exchange.ProcedureFilter;
import gov.va.med.imaging.exchange.enums.ProcedureFilterMatchMode;

/**
 * @author       DNS
 *
 */
public class StudyFacadeFilter
extends ProcedureFilter
{
	private static final long serialVersionUID = -8281472689714436561L;
	
	private final boolean includeRadiology;
	private final boolean includeArtifacts;
	
	public static StudyFacadeFilter createRadiologyFilter()
	{
		return new StudyFacadeFilter(ProcedureFilterMatchMode.existInProcedureList);
	}
	
	public static StudyFacadeFilter createArtifactsFilter()
	{
		return new StudyFacadeFilter(ProcedureFilterMatchMode.excludedInProcedureList);
	}
	
	public static StudyFacadeFilter createAllFilter()
	{
		return new StudyFacadeFilter(ProcedureFilterMatchMode.all);
	}
	
	/*
	public static StudyFacadeFilter create(boolean includeRadiology, boolean includeArtifacts)
	{
		if(includeRadiology && !includeArtifacts)
			return createRadiologyFilter();
		if(includeArtifacts && !includeRadiology)
			return createArtifactsFilter();
		// if both true or both false, returning everything			
		return createAllFilter();		
	}*/
	
	private StudyFacadeFilter(ProcedureFilterMatchMode procedureFilterMatchMode)
	{
		super(procedureFilterMatchMode);
		switch(procedureFilterMatchMode)
		{
			case all:
				this.includeArtifacts = true;
				this.includeRadiology = true;				
				break;
			case excludedInProcedureList:
				this.includeArtifacts = true;
				this.includeRadiology = false;
				break;
			case existInProcedureList:
				this.includeArtifacts = false;
				this.includeRadiology = true;
				break;
			default:
				this.includeArtifacts = true;
				this.includeRadiology = true;
				break;
		}
	}

	public boolean isIncludeRadiology()
	{
		return includeRadiology;
	}

	public boolean isIncludeArtifacts()
	{
		return includeArtifacts;
	}
}
