/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Sep 26, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        WERFEJ
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.siteservice.ws.providers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;

import gov.va.med.imaging.exchange.business.Site;
import gov.va.med.imaging.exchange.business.SiteConnection;
import gov.va.med.imaging.exchange.business.SiteImpl;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

import com.sun.jersey.api.client.GenericType;

/**
 * @author       WERFEJ
 *
 */
@Provider
@Produces(MediaType.APPLICATION_XML)
@Consumes(MediaType.APPLICATION_XML)
public class SiteReaderWriter
extends AbstractMessageBodyReaderWriter<Site>
{

	public SiteReaderWriter(@Context Providers providers) 
	{
		super(providers);
	}

	public SiteReaderWriter(ServletConfig servletConfig, ServletContext servletContext, Providers providers) 
	{
		super(servletConfig, servletContext, providers);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.ws.entityproviders.AbstractMessageBodyReaderWriter#getElementName()
	 */
	@Override
	public String getElementName() {return "site";}

	/**
	 * @see gov.va.med.imaging.ws.providers.AbstractMessageBodyReaderWriter#getElementClass()
	 */
	@Override
	public Class<?> getElementClass() {return Site.class;}

	/**
	 * @see javax.ws.rs.ext.MessageBodyWriter#isWriteable(java.lang.Class, java.lang.reflect.Type, java.lang.annotation.Annotation[], javax.ws.rs.core.MediaType)
	 */
	@Override
	public boolean isWriteable(
		Class<?> resultClazz, 
		Type resultGenericType, 
		Annotation[] annotations,
		MediaType mediaType) 
	{
		if( Site.class.isAssignableFrom(resultClazz) )
			return true;
		
		return false;
	}

	/**
	 * @see javax.ws.rs.ext.MessageBodyWriter#getSize(java.lang.Object, java.lang.Class, java.lang.reflect.Type, java.lang.annotation.Annotation[], javax.ws.rs.core.MediaType)
	 */
	@Override
	public long getSize(
		Site site, 
		Class<?> resultClazz, 
		Type resultGenericType,
		Annotation[] annotations, 
		MediaType mediaType) 
	{
		return -1;
	}

	/**
	 * @see javax.ws.rs.ext.MessageBodyWriter#writeTo(java.lang.Object, java.lang.Class, java.lang.reflect.Type, java.lang.annotation.Annotation[], javax.ws.rs.core.MediaType, javax.ws.rs.core.MultivaluedMap, java.io.OutputStream)
	 */
	@Override
	public void writeTo(
		Site site, 
		Class<?> resultClazz, 
		Type resultGenericType,
		Annotation[] annotations, 
		MediaType mediaType,
		MultivaluedMap<String, Object> httpHeaders, 
		OutputStream out)
	throws IOException, WebApplicationException 
	{
		Writer writer = createWriter(httpHeaders, out);
		
		writer.write("<" + getElementName() + ">");
		writer.write("<siteAbbr>");
		writer.write( site.getSiteAbbr() );
		writer.write("</siteAbbr>");
		writer.write("<siteName>");
		writer.write( site.getSiteName() );
		writer.write("</siteName>");
		writer.write("<siteNumber>");
		writer.write( site.getSiteNumber() );
		writer.write("</siteNumber>");
		writer.write("<sitePatientLookupable>");
		writer.write( site.isSitePatientLookupable() + "" );
		writer.write("</sitePatientLookupable>");
		writer.write("<siteUserAuthenticatable>");
		writer.write( site.isSiteUserAuthenticatable() + "" );
		writer.write("</siteUserAuthenticatable>");
		writer.write("<visnNumber>");
		writer.write( site.getRegionId() );
		writer.write("</visnNumber>");
		writer.flush();
		
		//SiteConnectionCollectionReaderWriter elementBodyWriter = new SiteConnectionCollectionReaderWriter(getProviders());
		//GenericType<Collection<SiteConnection>> gt = new GenericType<T>(genericType)
		GenericType<Collection<SiteConnection>> genericType = new GenericType<Collection<SiteConnection>>() 
			{
			
			};
		Type type = genericType.getType();
			
		
		//MessageBodyWriter<Collection<SiteConnection>> elementBodyWriter = 
				//getProviders().getMessageBodyWriter(type.getClass(), type, annotations, mediaType);
		@SuppressWarnings("rawtypes")
		MessageBodyWriter<Collection> elementBodyWriter =
				getProviders().getMessageBodyWriter(Collection.class, type, annotations, mediaType);
		
		
					
		if(elementBodyWriter != null)
		{
			//elementBodyWriter.writeTo(site.getSiteConnections().values(), null, SiteConnection.class, annotations, mediaType, httpHeaders, out);
			elementBodyWriter.writeTo(site.getSiteConnections().values(), null, type, annotations, mediaType, httpHeaders, out);
		}
		
		writer.write("</" + getElementName() + ">");
		writer.flush();
	}

	/**
	 * @see javax.ws.rs.ext.MessageBodyReader#isReadable(java.lang.Class, java.lang.reflect.Type, java.lang.annotation.Annotation[], javax.ws.rs.core.MediaType)
	 */
	@Override
	public boolean isReadable(
		Class<?> resultClazz, 
		Type resultGenericType, 
		Annotation[] annotations,
		MediaType mediaType) 
	{
		return isWriteable(resultClazz, resultGenericType, annotations, mediaType);
	}

	/* (non-Javadoc)
	 * @see javax.ws.rs.ext.MessageBodyReader#readFrom(java.lang.Class, java.lang.reflect.Type, java.lang.annotation.Annotation[], javax.ws.rs.core.MediaType, javax.ws.rs.core.MultivaluedMap, java.io.InputStream)
	 */
	@Override
	public Site readFrom(
		Class<Site> resultClazz, 
		Type resultGenericType,
		Annotation[] annotations, 
		MediaType mediaType,
		MultivaluedMap<String, String> httpHeaders, 
		InputStream inStream)
	throws IOException, WebApplicationException 
	{
		/*
		DocumentBuilder builder = DocumentBuilderFactory.newInstance();
		Document document = builder.parse(new InputSource(inStream));
		document.
		*/
		try
		{
			
			XMLReader xmlReader = XMLReaderFactory.createXMLReader();
			SiteXmlHandler siteHandler = new SiteXmlHandler();
			xmlReader.setContentHandler(siteHandler);
			
			xmlReader.parse(new InputSource(inStream));
			//new SiteImpl(siteNumber, siteName, siteAbbr, vistaServer, vistaPort, acceleratorServer, acceleratorPort, regionId, sitePatientLookupable, siteUserAuthenticatable)

			
			
			
		}
		catch(SAXException sX)
		{
			throw new IOException(sX);
		}
		
		
		return null;
	}
	
	class SiteXmlHandler
	extends DefaultHandler
	{
		private String currentTag = null;
		public String siteAbbr = null;
		public String siteName = null;
		public String siteNumber = null;
		public boolean sitePatientLookupable = true;
		public boolean siteUserAuthenticatable = true;
		public String visnNumber = null;
		
		@Override
		public void startElement(String uri, String localName, String qName,
				Attributes atts) throws SAXException
		{
			currentTag = qName;
		}
							
		@Override
		public void endElement(String uri, String localName, String qName)
				throws SAXException
		{
			currentTag = null;
		}
		
		@Override
		public void characters(char[] ch, int start, int length)
				throws SAXException
		{
			if("siteAbbr".equals(currentTag))
			{
				siteAbbr = new String(ch, start, length);				
			}
			else if("siteName".equals(currentTag))
			{
				siteName = new String(ch, start, length);				
			}
			
			else if("siteNumber".equals(currentTag))
			{
				siteNumber = new String(ch, start, length);				
			}
			else if("visnNumber".equals(currentTag))
			{
				visnNumber = new String(ch, start, length);				
			}
			else if("sitePatientLookupable".equals(currentTag))
			{
				sitePatientLookupable = Boolean.parseBoolean(new String(ch, start, length));				
			}
			else if("siteUserAuthenticatable".equals(currentTag))
			{
				siteUserAuthenticatable = Boolean.parseBoolean(new String(ch, start, length));				
			}			
			
		}
	}
}
