/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Sep 26, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        WERFEJ
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.siteservice.ws.providers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;

import gov.va.med.imaging.exchange.business.SiteConnection;

/**
 * @author       WERFEJ
 *
 */
@Provider
@Produces(MediaType.APPLICATION_XML)
@Consumes(MediaType.APPLICATION_XML)
public class SiteConnectionReaderWriter
extends AbstractMessageBodyReaderWriter<SiteConnection>
{

	/**
	 * @param providers
	 */
	public SiteConnectionReaderWriter(Providers providers)
	{
		super(providers);
	}
	
	public SiteConnectionReaderWriter(ServletConfig servletConfig, ServletContext servletContext, Providers providers) 
	{
		super(servletConfig, servletContext, providers);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.ws.entityproviders.AbstractMessageBodyReaderWriter#getElementName()
	 */
	@Override
	public String getElementName() {return "connection";}

	/**
	 * @see gov.va.med.imaging.ws.providers.AbstractMessageBodyReaderWriter#getElementClass()
	 */
	@Override
	public Class<?> getElementClass() {return SiteConnection.class;}

	/**
	 * @see javax.ws.rs.ext.MessageBodyWriter#isWriteable(java.lang.Class, java.lang.reflect.Type, java.lang.annotation.Annotation[], javax.ws.rs.core.MediaType)
	 */
	@Override
	public boolean isWriteable(
		Class<?> resultClazz, 
		Type resultGenericType, 
		Annotation[] annotations,
		MediaType mediaType) 
	{
		if( SiteConnection.class.isAssignableFrom(resultClazz) )
			return true;
		
		return false;
	}

	/**
	 * @see javax.ws.rs.ext.MessageBodyWriter#getSize(java.lang.Object, java.lang.Class, java.lang.reflect.Type, java.lang.annotation.Annotation[], javax.ws.rs.core.MediaType)
	 */
	@Override
	public long getSize(
		SiteConnection siteConnection, 
		Class<?> resultClazz, 
		Type resultGenericType,
		Annotation[] annotations, 
		MediaType mediaType) 
	{
		return -1;
	}

	/**
	 * @see javax.ws.rs.ext.MessageBodyWriter#writeTo(java.lang.Object, java.lang.Class, java.lang.reflect.Type, java.lang.annotation.Annotation[], javax.ws.rs.core.MediaType, javax.ws.rs.core.MultivaluedMap, java.io.OutputStream)
	 */
	@Override
	public void writeTo(
		SiteConnection siteConnection, 
		Class<?> resultClazz, 
		Type resultGenericType,
		Annotation[] annotations, 
		MediaType mediaType,
		MultivaluedMap<String, Object> httpHeaders, 
		OutputStream out)
	throws IOException, WebApplicationException 
	{
		Writer writer = createWriter(httpHeaders, out);
		
		writer.write("<" + getElementName() + ">");
		writer.write("<port>");
		writer.write( siteConnection.getPort() + "" ); // necessary to treat the int as a string and not a character
		writer.write("</port>");
		writer.write("<protocol>");
		writer.write( siteConnection.getProtocol() );
		writer.write("</protocol>");
		writer.write("<server>");
		writer.write( siteConnection.getServer() );
		writer.write("</server>");
		
		writer.write("</" + getElementName() + ">");
		writer.flush();
	}

	/**
	 * @see javax.ws.rs.ext.MessageBodyReader#isReadable(java.lang.Class, java.lang.reflect.Type, java.lang.annotation.Annotation[], javax.ws.rs.core.MediaType)
	 */
	@Override
	public boolean isReadable(
		Class<?> resultClazz, 
		Type resultGenericType, 
		Annotation[] annotations,
		MediaType mediaType) 
	{
		return false;
	}

	/* (non-Javadoc)
	 * @see javax.ws.rs.ext.MessageBodyReader#readFrom(java.lang.Class, java.lang.reflect.Type, java.lang.annotation.Annotation[], javax.ws.rs.core.MediaType, javax.ws.rs.core.MultivaluedMap, java.io.InputStream)
	 */
	@Override
	public SiteConnection readFrom(
		Class<SiteConnection> resultClazz, 
		Type resultGenericType,
		Annotation[] annotations, 
		MediaType mediaType,
		MultivaluedMap<String, String> httpHeaders, 
		InputStream inStream)
	throws IOException, WebApplicationException 
	{
		return null;
	}
	

}
