/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Sep 26, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        WERFEJ
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.siteservice.ws.providers;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;

import gov.va.med.imaging.exchange.business.SiteConnection;

/**
 * @author       WERFEJ
 *
 */
@Provider
@Produces(MediaType.APPLICATION_XML)
@Consumes(MediaType.APPLICATION_XML)
public class SiteConnectionCollectionReaderWriter
extends AbstractCollectionReaderWriter<SiteConnection>
{

	/**
	 * @param providers
	 */
	public SiteConnectionCollectionReaderWriter(Providers providers)
	{
		super(providers);
	}

	public SiteConnectionCollectionReaderWriter(
		@Context ServletConfig servletConfig, 
		@Context ServletContext servletContext, 
		@Context Providers providers) 
	{
		super(servletConfig, servletContext, providers);
	}

	/**
	 * @see gov.va.med.imaging.ws.providers.AbstractCollectionReaderWriter#getCollectionMemberClass()
	 */
	@Override
	public Class<SiteConnection> getCollectionMemberClass() 
	{
		return SiteConnection.class;
	}
	
	/* (non-Javadoc)
	 * @see gov.va.med.imaging.ws.entityproviders.AbstractCollectionReaderWriter#getCollectionElementName()
	 */
	@Override
	public String getElementName() 
	{
		return "connections";
	}
}
