/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Sep 13, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        BECKEC
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.siteservice.ws.providers;

import gov.va.med.imaging.ws.providers.AbstractReaderWriter;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;

import org.apache.log4j.Logger;

/**
 * @author       BECKEC
 *
 */
public abstract class AbstractMessageBodyReaderWriter<T> 
extends AbstractReaderWriter<T>
implements MessageBodyReader<T>, MessageBodyWriter<T> 
{
	/**
	 * 
	 */
	public static final String DEFAULT_CHARSET = "UTF-8";
	private final Logger logger = Logger.getLogger(this.getClass());
	protected Logger getLogger(){return this.logger;}
	
	private final Providers providers;
	private final ServletConfig servletConfig;
	private final ServletContext servletContext;
	
	public AbstractMessageBodyReaderWriter(	
		ServletConfig servletConfig,
		ServletContext servletContext,
		Providers providers) 
	{
		this.servletConfig = servletConfig;
		this.servletContext = servletContext;
		this.providers = providers;
	}
	
	public AbstractMessageBodyReaderWriter(	
		Providers providers) 
	{
		this.servletConfig = null;
		this.servletContext = null;
		this.providers = providers;
	}
	
	protected ServletConfig getServletConfig() {return servletConfig;}

	protected ServletContext getServletContext() {return servletContext;}

	protected Providers getProviders(){return this.providers;}

	/**
	 * Returns the element name, as it is to be written to the XML.
	 * 
	 * @return
	 */
	public abstract String getElementName();
	
	/**
	 * The Class of the element to serialize.
	 * @return
	 */
	public abstract Class<?> getElementClass();
	
	/**
	 * Create a Write with the right character set.
	 * 
	 * @param httpHeaders
	 * @param out
	 * @return
	 * @throws UnsupportedEncodingException
	 */
	public synchronized Writer createWriter(MultivaluedMap<String, Object> httpHeaders, OutputStream out) 
	throws UnsupportedEncodingException
	{
		String charSet = getCharacterSet(httpHeaders);
		return new OutputStreamWriter(out, charSet == null ? DEFAULT_CHARSET : charSet);
	}
	
	/**
	 * @param httpHeaders
	 * @return
	 */
	public String getCharacterSet(MultivaluedMap<String, Object> httpHeaders) 
	{
		String charSet = DEFAULT_CHARSET;
		
		// Content-Type is in the form:
		// content[;charset]
		// parse the first Content-Type here to get the charset
//		if( httpHeaders.containsKey("Content-Type") )
//		{
//			List<Object> contentTypes = httpHeaders.get("Content-Type");
//			if(contentTypes != null && contentTypes.size() > 0)
//			{
//				MediaType mediaType = (MediaType) contentTypes.get(0);
//				String[] contentType = ((String)contentTypes.get(0)).split(";");
//				if(contentType.length > 1)
//					charSet = contentType[1];
//			}
//		}
		return charSet;
	}
}
