/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Sep 26, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        WERFEJ
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.siteservice.ws.providers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;

/**
 * @author       WERFEJ
 *
 */
@Produces(MediaType.APPLICATION_XML)
public abstract class AbstractMapReaderWriter<T, V>
extends AbstractMessageBodyReaderWriter<Map<T, V>>
implements MessageBodyWriter<Map<T, V>>, MessageBodyReader<Map<T, V>> 
{

	public AbstractMapReaderWriter(Providers providers) {
		super(providers);
	}

	public AbstractMapReaderWriter(ServletConfig servletConfig, ServletContext servletContext, Providers providers) 
	{
		super(servletConfig, servletContext, providers);
	}

	/**
	 * The type of the contained collection elements.
	 * @return
	 */
	//public abstract Class<T> getMapKeyClass();
	
	public abstract Class<V> getMapValueClass();
	
	/**
	 * @see gov.va.med.imaging.ws.providers.AbstractMessageBodyReaderWriter#getElementClass()
	 */
	@Override
	public Class<?> getElementClass() {return Map.class;}
	
	/**
	 * @see javax.ws.rs.ext.MessageBodyWriter#getSize(java.lang.Object, java.lang.Class, java.lang.reflect.Type, java.lang.annotation.Annotation[], javax.ws.rs.core.MediaType)
	 */
	@Override
	public long getSize(
		Map<T, V> arg0, 
		Class<?> arg1, 
		Type arg2,
		Annotation[] arg3, 
		MediaType arg4) 
	{
		return arg0.keySet().size();
	}
	
	@Override
	public boolean isWriteable(
		Class<?> clazz, 
		Type type, 
		Annotation[] annotations,
		MediaType mediaType) 
	{
		// A Collection derived class is either a List or a Set, Map is NOT derived from Collection
		boolean isMap = Map.class.isAssignableFrom(clazz);
		boolean isElementTypeSupported = false;
		if(type != null && type instanceof ParameterizedType)
		{
			ParameterizedType genericType = (ParameterizedType)type;
			Type[] typeArguments = genericType.getActualTypeArguments();
			if(typeArguments != null && typeArguments.length == 1)
			{
				MessageBodyWriterAndSubjectClass<V> elementBodyWriter = findElementMessageBodyWriter(type, annotations, mediaType);
				
				isElementTypeSupported = (elementBodyWriter != null) && (elementBodyWriter.getType() == getMapValueClass());
			}
		}
		
		return isMap && isElementTypeSupported;
	}
	
	@Override
	public void writeTo(
		Map<T, V> map, 
		Class<?> clazz, 
		Type type,
		Annotation[] annotations, 
		MediaType mediaType,
		MultivaluedMap<String, Object> httpHeaders, 
		OutputStream out)
	throws IOException, WebApplicationException 
	{
		MessageBodyWriterAndSubjectClass<V> elementBodyWriter = findElementMessageBodyWriter(type, annotations, mediaType);
		
		if(elementBodyWriter == null)
		{
			getLogger().error("No MessageBodyWriter found for element type '" + type.toString() + "' producing '" + mediaType + "'.");
			throw new WebApplicationException();
		}
		
		MessageBodyWriter<V> elementWriter = elementBodyWriter.getWriter();
		Type elementType = elementBodyWriter.getType();
		
		Writer writer = createWriter(httpHeaders, out);

		writer.write("<" + getElementName() + ">");
		writer.flush();
		
		for(V obj : map.values())
			elementWriter.writeTo(obj, null, elementType, annotations, mediaType, httpHeaders, out);
		writer.write("</" + getElementName() + ">");
		writer.flush();
	}

	/**
	 * @param clazz
	 * @param mediaType
	 * @param types
	 * @return
	 */
	private MessageBodyWriterAndSubjectClass<V> findElementMessageBodyWriter(
		Type mapType,
		Annotation[] annotations,
		MediaType mediaType) 
	throws WebApplicationException
	{
		// if the collection type is not a ParameterizedType then we should not be in
		// this class...
		if( ! (mapType instanceof ParameterizedType) )
		{
			getLogger().warn(mapType.toString() + " MUST be a ParameterizedType and is not.");
			return null;
		}
		ParameterizedType pType = (ParameterizedType)mapType;

		// Returns an array of Type objects representing the actual type arguments to this 
		// type. Note that in some cases, the returned array be empty. This can occur if 
		// this type represents a non-parameterized type nested within a parameterized type.
		Type[] types = pType.getActualTypeArguments();
		
		if( types == null || types.length != 1 )
		{
			getLogger().error(mapType.toString() + " is a ParameterizedType with more than one type specified, cannot continue 'cause this don't make no sense for a Collection.");
			return null;
		}
		
		Type elementType = Object.class;
		if( types.length == 1 )
			elementType = types[0];
		
		if(elementType == Object.class)
			getLogger().warn(mapType.toString() + " is a ParameterizedType but no types are provided, assuming Object and continuing ...");
		
		Class<V> elementClazz = getMapValueClass();
		
		// this will contain the MessageBodyWriter that write elements within the Collection
		MessageBodyWriter<V> elementBodyWriter = 
			getProviders().getMessageBodyWriter(elementClazz, elementClazz, annotations, mediaType);

		return elementType != null && elementBodyWriter != null ? 
			new MessageBodyWriterAndSubjectClass<V>(elementType, elementBodyWriter) :
			null;
	}

	// ========================================================================================================================
	
	/* (non-Javadoc)
	 * @see javax.ws.rs.ext.MessageBodyReader#isReadable(java.lang.Class, java.lang.reflect.Type, java.lang.annotation.Annotation[], javax.ws.rs.core.MediaType)
	 */
	@Override
	public boolean isReadable(Class<?> clazz, Type type, Annotation[] annotations, MediaType mediaType) 
	{
		return false;
	}

	/* (non-Javadoc)
	 * @see javax.ws.rs.ext.MessageBodyReader#readFrom(java.lang.Class, java.lang.reflect.Type, java.lang.annotation.Annotation[], javax.ws.rs.core.MediaType, javax.ws.rs.core.MultivaluedMap, java.io.InputStream)
	 */
	@Override
	public Map<T, V> readFrom(
		Class<Map<T, V>> clazz, 
		Type type,
		Annotation[] annotations, 
		MediaType mediaType,
		MultivaluedMap<String, String> httpHeaders, 
		InputStream in)
	throws IOException, WebApplicationException 
	{
		return null;
	}
	
	/**
	 * Just a value object to pass a couple of things back as a result.
	 */
	class MessageBodyWriterAndSubjectClass<E>
	{
		private final Type type;
		private final MessageBodyWriter<E> writer;

		public MessageBodyWriterAndSubjectClass(Type type, MessageBodyWriter<E> writer) 
		{
			this.type = type;
			this.writer = writer;
		}
		
		/**
		 * @return the writerClass
		 */
		public Type getType() {
			return type;
		}
		/**
		 * @return the writer
		 */
		public MessageBodyWriter<E> getWriter() {
			return writer;
		}
		
		
	}
}
