/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Sep 13, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        BECKEC
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.siteservice.ws.providers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;

/**
 * @author       BECKEC
 *
 */
@Produces(MediaType.APPLICATION_XML)
public abstract class AbstractCollectionReaderWriter<T> 
extends AbstractMessageBodyReaderWriter<Collection<T>>
implements MessageBodyWriter<Collection<T>>, MessageBodyReader<Collection<T>> 
{
	public AbstractCollectionReaderWriter(Providers providers) {
		super(providers);
	}

	public AbstractCollectionReaderWriter(ServletConfig servletConfig, ServletContext servletContext, Providers providers) 
	{
		super(servletConfig, servletContext, providers);
	}

	/**
	 * The type of the contained collection elements.
	 * @return
	 */
	public abstract Class<T> getCollectionMemberClass();
	
	/**
	 * @see gov.va.med.imaging.ws.providers.AbstractMessageBodyReaderWriter#getElementClass()
	 */
	@Override
	public Class<?> getElementClass() {return Collection.class;}

	/**
	 * @see javax.ws.rs.ext.MessageBodyWriter#isWriteable(java.lang.Class, java.lang.reflect.Type, java.lang.annotation.Annotation[], javax.ws.rs.core.MediaType)
	 */
	@Override
	public boolean isWriteable(
		Class<?> clazz, 
		Type type, 
		Annotation[] annotations,
		MediaType mediaType) 
	{
		// A Collection derived class is either a List or a Set, Map is NOT derived from Collection
		boolean isCollection = Collection.class.isAssignableFrom(clazz);
		boolean isElementTypeSupported = false;
		if(type != null && type instanceof ParameterizedType)
		{
			ParameterizedType genericType = (ParameterizedType)type;
			Type[] typeArguments = genericType.getActualTypeArguments();
			if(typeArguments != null && typeArguments.length == 1)
			{
				MessageBodyWriterAndSubjectClass<T> elementBodyWriter = findElementMessageBodyWriter(type, annotations, mediaType);
				
				isElementTypeSupported = (elementBodyWriter != null) && (elementBodyWriter.getType() == getCollectionMemberClass());
			}
		}
		
		return isCollection && isElementTypeSupported;
	}

	/**
	 * @see javax.ws.rs.ext.MessageBodyWriter#getSize(java.lang.Object, java.lang.Class, java.lang.reflect.Type, java.lang.annotation.Annotation[], javax.ws.rs.core.MediaType)
	 */
	@Override
	public long getSize(
		Collection<T> arg0, 
		Class<?> arg1, 
		Type arg2,
		Annotation[] arg3, 
		MediaType arg4) 
	{
		return -1;
	}

	/**
	 * collection - the (Collection) instance that is to be written.
	 * clazz - the class of object that is to be written, NOT the class of the elements, the collection class.
	 * type - the type of object to be written, obtained either by reflection of a resource method return type or 
	 *   by inspection of the returned instance. GenericEntity provides a way to specify this information at runtime.
	 * annotations - an array of the annotations on the resource method that returns the object.
	 * mediaType - the media type of the HTTP entity.
	 * httpHeaders - a mutable map of the HTTP response headers.
	 * entityStream - the OutputStream for the HTTP entity. The implementation should not close the output stream.
	 * 
	 * @see javax.ws.rs.ext.MessageBodyWriter#writeTo(java.lang.Object, java.lang.Class, java.lang.reflect.Type, java.lang.annotation.Annotation[], javax.ws.rs.core.MediaType, javax.ws.rs.core.MultivaluedMap, java.io.OutputStream)
	 */
	@Override
	public void writeTo(
		Collection<T> collection, 
		Class<?> clazz, 
		Type type,
		Annotation[] annotations, 
		MediaType mediaType,
		MultivaluedMap<String, Object> httpHeaders, 
		OutputStream out)
	throws IOException, WebApplicationException 
	{
		MessageBodyWriterAndSubjectClass<T> elementBodyWriter = findElementMessageBodyWriter(type, annotations, mediaType);
		
		if(elementBodyWriter == null)
		{
			getLogger().error("No MessageBodyWriter found for element type '" + type.toString() + "' producing '" + mediaType + "'.");
			throw new WebApplicationException();
		}
		
		MessageBodyWriter<T> elementWriter = elementBodyWriter.getWriter();
		Type elementType = elementBodyWriter.getType();
		
		Writer writer = createWriter(httpHeaders, out);

		writer.write("<" + getElementName() + ">");
		writer.flush();
		
		for(T obj : collection)
			elementWriter.writeTo(obj, null, elementType, annotations, mediaType, httpHeaders, out);
		writer.write("</" + getElementName() + ">");
		writer.flush();
	}

	/**
	 * @param clazz
	 * @param mediaType
	 * @param types
	 * @return
	 */
	private MessageBodyWriterAndSubjectClass<T> findElementMessageBodyWriter(
		Type collectionType,
		Annotation[] annotations,
		MediaType mediaType) 
	throws WebApplicationException
	{
		// if the collection type is not a ParameterizedType then we should not be in
		// this class...
		if( ! (collectionType instanceof ParameterizedType) )
		{
			getLogger().warn(collectionType.toString() + " MUST be a ParameterizedType and is not.");
			return null;
		}
		ParameterizedType pType = (ParameterizedType)collectionType;

		// Returns an array of Type objects representing the actual type arguments to this 
		// type. Note that in some cases, the returned array be empty. This can occur if 
		// this type represents a non-parameterized type nested within a parameterized type.
		Type[] types = pType.getActualTypeArguments();
		
		if( types == null || types.length != 1 )
		{
			getLogger().error(collectionType.toString() + " is a ParameterizedType with more than one type specified, cannot continue 'cause this don't make no sense for a Collection.");
			return null;
		}
		
		Type elementType = Object.class;
		if( types.length == 1 )
			elementType = types[0];
		
		if(elementType == Object.class)
			getLogger().warn(collectionType.toString() + " is a ParameterizedType but no types are provided, assuming Object and continuing ...");
			
		Class<T> elementClazz = getCollectionMemberClass();
		
		// this will contain the MessageBodyWriter that write elements within the Collection
		MessageBodyWriter<T> elementBodyWriter = 
			getProviders().getMessageBodyWriter(elementClazz, elementClazz, annotations, mediaType);

		return elementType != null && elementBodyWriter != null ? 
			new MessageBodyWriterAndSubjectClass<T>(elementType, elementBodyWriter) :
			null;
	}

	// ========================================================================================================================
	
	/* (non-Javadoc)
	 * @see javax.ws.rs.ext.MessageBodyReader#isReadable(java.lang.Class, java.lang.reflect.Type, java.lang.annotation.Annotation[], javax.ws.rs.core.MediaType)
	 */
	@Override
	public boolean isReadable(Class<?> clazz, Type type, Annotation[] annotations, MediaType mediaType) 
	{
		return false;
	}

	/* (non-Javadoc)
	 * @see javax.ws.rs.ext.MessageBodyReader#readFrom(java.lang.Class, java.lang.reflect.Type, java.lang.annotation.Annotation[], javax.ws.rs.core.MediaType, javax.ws.rs.core.MultivaluedMap, java.io.InputStream)
	 */
	@Override
	public Collection<T> readFrom(
		Class<Collection<T>> clazz, 
		Type type,
		Annotation[] annotations, 
		MediaType mediaType,
		MultivaluedMap<String, String> httpHeaders, 
		InputStream in)
	throws IOException, WebApplicationException 
	{
		return null;
	}
	
	// ========================================================================================================================
	
	/**
	 * Just a value object to pass a couple of things back as a result.
	 */
	class MessageBodyWriterAndSubjectClass<E>
	{
		private final Type type;
		private final MessageBodyWriter<E> writer;

		public MessageBodyWriterAndSubjectClass(Type type, MessageBodyWriter<E> writer) 
		{
			this.type = type;
			this.writer = writer;
		}
		
		/**
		 * @return the writerClass
		 */
		public Type getType() {
			return type;
		}
		/**
		 * @return the writer
		 */
		public MessageBodyWriter<E> getWriter() {
			return writer;
		}
		
		
	}
}
