<%@page import="gov.va.med.imaging.roi.web.ROIConfigurationView"%>
<%@ page language="java" import="java.util.*" pageEncoding="ISO-8859-1"%>
<%
String path = request.getContextPath();
String basePath = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+path+"/";

ROIConfigurationView view = ROIConfigurationView.get();
pageContext.setAttribute("view", view);

String result = request.getParameter("result");
String error = request.getParameter("error");

%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
  <head>
    <title>Configure ROI</title>
    
	<meta http-equiv="pragma" content="no-cache">
	<meta http-equiv="cache-control" content="no-cache">
	<meta http-equiv="expires" content="0">    
	<meta http-equiv="keywords" content="keyword1,keyword2,keyword3">
	<link rel="stylesheet" type="text/css" href="../style/vix.css">
	
	<script type="text/javascript">
		function setAccessFocus() 
		{
			document.getElementById("accessCode").focus();
		}
		
		function validateInput()
		{
			var accessCodeValue = document.getElementById("accessCode").value;
			if(accessCodeValue == null || accessCodeValue == "")
			{
				alert('You must specify an access code');
				return false;
			}
			var verifyCodeValue = document.getElementById("verifyCode").value;
			if(verifyCodeValue == null || verifyCodeValue == "")
			{
				alert('You must specify a verify code');
				return false;
			}
			
			var verifyCode2Value = document.getElementById("verifyCode2").value;
			if(verifyCode2Value == null || verifyCode2Value == "")
			{
				alert('You must confirm your verify code');
				return false;
			}
			
			if(verifyCodeValue != verifyCode2Value)
			{
				alert('Your verify codes do not match');
				return false;
			}
			
			return true;
		}
		
	</script>
  </head>
  
  <body onLoad="setAccessFocus();">
  	<div id="header">
  	 	Configure Release of Information (ROI)
  	 </div>
  	 <div id="sidebar">
  	 	<div id="sidebar-item">
  	 		<a href="..\index.jsp">ROI Status</a>
  	 	</div>
  	 </div>
  	 <div id="main-content">
	    <%
    	if(result != null)
    	{
    		%>
    		<div id="success"><%= result %></div>
    		<%
   		}
    	if(error != null)
    	{
    		%>
    		<div id="error"><%= error %></div>
    		<%
   		}		    
	     %>		
    
	    <%
   		if(!view.isFunctionalState())
   		{
    	 %> 
    	<div id="error">
    		ROI Disclosures will NOT be processed. Both Periodic Processing AND Process Disclosures Immediately are disabled. At least one of these options must be enabled to create ROI disclosures
    	</div> 
   	 	<% } %>
   	 	
   	 	<%
   	 	if(view.isRoiCredentialsInvalid())
   	 	{
   	 	 %>
   	 	<div id="error">
    		The currently provided ROI periodic processing credentials are not valid.  Please update the credentials below.
    	</div> 
   	 	 <%} %>
	    
	    <form method="POST" action="UpdateROIConfiguration" onsubmit="return validateInput()">
	    	<div id="section-header">
	    	ROI Periodic Processing Credentials
	    	</div>
	    	The VIX will use the following credentials to periodically process ROI requests
	    
		    <table border="1">
		    	<tr>
		    		<th>Access Code:</th>
		    		<td><input type="password" id="accessCode" name="accessCode" value="<%= view.getAccessCode() %>"/></td>
		    	</tr>
		    	<tr>
		    		<th>Verify Code:</th>
		    		<td><input type="password" id="verifyCode" name="verifyCode" value="<%= view.getVerifyCode() %>"/></td>
		    	</tr>
		    	<tr>
		    		<th>Re-Enter Verify Code:</th>
		    		<td><input type="password" id="verifyCode2" name="verifyCode2" value="<%= view.getVerifyCode() %>"/></td>
		    	</tr>
		    	
		    </table>
		    <hr />
		    <br />
		    <div id="section-header">
		    ROI Options
		    </div>
		    <table border="1">		   
		    	<tr>
		    		<th>Periodic Processing Enabled</th>
		    		<td>
		    			<select name="periodicProcessingEnabled">
		    				<option value="true" <% if(view.isPeriodicProcessingEnabled()) out.print(" selected "); %> >True</option>
		    				<option value="false" <% if(!view.isPeriodicProcessingEnabled()) out.print(" selected "); %> >False</option>
		    			</select>
		    			<br>
		    			When true, ROI disclosures will be processed periodically in the background. If periodic processing is disabled, ROI disclosures will only be processed when they are requested. 
	  	If they are interrupted for any reason they will not be completed without ROI periodic processing
		    		</td>
		    	</tr>	
		    	
		    	<tr>
		    		<th>Completed Disclosures Purge Processing Enabled</th>
		    		<td>
		    			<select name="completedItemPurgeProcessingEnabled">
		    				<option value="true" <% if(view.isCompletedItemPurgeProcessingEnabled()) out.print(" selected "); %> >True</option>
		    				<option value="false" <% if(!view.isCompletedItemPurgeProcessingEnabled()) out.print(" selected "); %> >False</option>
		    			</select>
		    			<br>
		    			When true, old ROI disclosures are purged from the system after <%= view.getExpireCompletedItemsAfterDays() %> days (configurable below)
		    		</td>
		    	</tr>
		    	
		    	<tr>
		    		<th>Completed Disclosures Purged Days</th>
		    		<td>
		    			<input type="text" name="expiredCompletedItemsAfterDays" value="<%= view.getExpireCompletedItemsAfterDays() %>" />
		    			<br>
		    			This is the number of days the metadata for a completed disclosure will remain if purging is enabled
		    		</td>
		    	</tr>
		    	
		    	<tr>
		    		<th>Process Disclosure Requests Immediately</th>
		    		<td>
		    			<select name="processDisclosuresImmediately">
		    				<option value="true" <% if(view.isProcessWorkItemImmediately()) out.print(" selected "); %> >True</option>
		    				<option value="false" <% if(!view.isProcessWorkItemImmediately()) out.print(" selected "); %> >False</option>
		    			</select>
		    			<br>
		    			When true, disclosure requests are processed immediately as they are received. By default this is enabled but it could cause performance issues if too many ROI disclosure requests are received at one time
		    		</td>
		    	</tr>	
		    	
		    	<tr>
		    		<th>Processing Disclosure Wait Time</th>
		    		<td>
		    			<input type="text" name="processingWorkItemWaitTime" value="<%= view.getProcessingWorkItemWaitTime() %>" />
		    			<br>
		    			The number of minutes a disclosure request can remain in a processing state before restarting.  Be sure not to set this too low in the event a disclosure really is taking that long
		    		</td>
		    	</tr>
	    	 </table>
	    	 <p>If Periodic Processing Enabled and Process Disclosure Requests Immediately are both disabled, ROI disclosures will NOT be generated. </p>
	   		<input type="submit" value="Save Configuration"/>
	    </form>
	</div>
	<jsp:include flush="false" page="../footer.html"></jsp:include>
  </body>
</html>
