/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Apr 10, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.roi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author       DNS
 *
 */
public class ROIStudyList
implements Serializable
{
	private static final long serialVersionUID = -1370504062570241395L;
	
	private List<ROIStudy> studies;
	private String guid;
	
	public ROIStudyList()
	{
		super();
		studies = new ArrayList<ROIStudy>();
	}
	
	public ROIStudyList(String guid)
	{
		this();
		this.guid = guid;
	}

	public List<ROIStudy> getStudies()
	{
		return studies;
	}

	public void setStudies(List<ROIStudy> studies)
	{
		this.studies = studies;
	}

	public String getGuid()
	{
		return guid;
	}

	public void setGuid(String guid)
	{
		this.guid = guid;
	}
	
	public void addStudy(ROIStudy study)
	{
		this.studies.add(study);
	}
}
