/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Oct 1, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author       DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
 package gov.va.med.imaging.roi.commands.facade;
 
 import java.util.Date;
 import org.apache.log4j.*;
 import gov.va.med.imaging.*;
 import gov.va.med.imaging.core.interfaces.exceptions.*;
 import gov.va.med.imaging.core.interfaces.router.Command;
 import gov.va.med.imaging.core.interfaces.router.CommandFactory;
 import gov.va.med.imaging.core.CommandFactoryImpl;
 import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
 import gov.va.med.exceptions.ValidationException;
 import javax.annotation.Generated;
 import gov.va.med.imaging.core.interfaces.router.CommandContext;

 import gov.va.med.imaging.exchange.business.*;
 import gov.va.med.imaging.exchange.business.dicom.*;
 import gov.va.med.imaging.exchange.business.vistarad.*;
 import gov.va.med.imaging.artifactsource.*;
 
 /*
 * This is generated code and is recreated on every build.
 * Do not make changes directly in this code, as they will be lost (without warning).
 * Changes may be made to the template that generated this code (FacadeRouterImpl.ftl in
 * the CoreRouterAnnotationProcessor project), such changes will be reflected in
 * all facade router implementations.
 * 
 * This code was generated using FreeMarker, an open-source template processing engine.
 * See http://www.freemarker.org for documentation on the template syntax.
 */
 @Generated(value="gov.va.med.imaging.core.codegenerator.FacadeRouterCodeGenerator")
 public class ROICommandsRouterTest
 //extends gov.va.med.imaging.core.interfaces.router.AbstractFacadeRouterImpl 
 {
	
 	private Logger logger = Logger.getLogger(this.getClass());
 	
 	private Logger getLogger()
 	{
 		return logger;
 	}
 	
 	private CommandFactory commandFactory = new CommandFactoryImpl((CommandContext)null);
 	private CommandFactory getCommandFactory()
 	{
 		return commandFactory;
 	}
 
 	/**
 	* The constructor is public so this tester can be created to test
 	*/
 	public ROICommandsRouterTest()
 	{
 		super();
 	}
 
 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void burnImageAnnotationDetails(
 			java.io.InputStream inputStream
 		 			, gov.va.med.imaging.exchange.enums.ImageFormat imageFormat
 		 			, gov.va.med.imaging.exchange.business.annotations.ImageAnnotationDetails imageAnnotationDetails
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostImageAnnotationsDataSourceCommand' and parameters 'java.io.InputStream, gov.va.med.imaging.exchange.enums.ImageFormat, gov.va.med.imaging.exchange.business.annotations.ImageAnnotationDetails'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.storage.DataSourceInputStream.class, 
	 				"PostImageAnnotationsDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 java.io.InputStream.class, gov.va.med.imaging.exchange.enums.ImageFormat.class, gov.va.med.imaging.exchange.business.annotations.ImageAnnotationDetails.class 
		  			},
 					new Object[]{
				 		inputStream,imageFormat,imageAnnotationDetails
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostImageAnnotationsDataSourceCommand' in method 'burnImageAnnotationDetails' with parameters 'java.io.InputStream, gov.va.med.imaging.exchange.enums.ImageFormat, gov.va.med.imaging.exchange.business.annotations.ImageAnnotationDetails'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getMergeImageOutputStream(
 			java.lang.String groupIdentifier
 		 			, java.lang.String imageIdentifier
 		 			, gov.va.med.imaging.exchange.enums.ImageFormat imageFormat
 		 			, java.lang.String objectDescription
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetMergeImageOutputStreamDataSourceCommand' and parameters 'java.lang.String, java.lang.String, gov.va.med.imaging.exchange.enums.ImageFormat, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.io.OutputStream.class, 
	 				"GetMergeImageOutputStreamDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class, java.lang.String.class, gov.va.med.imaging.exchange.enums.ImageFormat.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		groupIdentifier,imageIdentifier,imageFormat,objectDescription
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetMergeImageOutputStreamDataSourceCommand' in method 'getMergeImageOutputStream' with parameters 'java.lang.String, java.lang.String, gov.va.med.imaging.exchange.enums.ImageFormat, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getMergeObjectsResponse(
 			java.lang.String groupIdentifier
 		 			, gov.va.med.imaging.exchange.business.Patient patient
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetMergeObjectsResponseDataSourceCommand' and parameters 'java.lang.String, gov.va.med.imaging.exchange.business.Patient'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.storage.DataSourceImageInputStream.class, 
	 				"GetMergeObjectsResponseDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class, gov.va.med.imaging.exchange.business.Patient.class 
		  			},
 					new Object[]{
				 		groupIdentifier,patient
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetMergeObjectsResponseDataSourceCommand' in method 'getMergeObjectsResponse' with parameters 'java.lang.String, gov.va.med.imaging.exchange.business.Patient'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void processROIGetStudyImages(
 			gov.va.med.imaging.roi.ROIWorkItem workItem
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'ProcessROIGetStudyImagesCommand' and parameters 'gov.va.med.imaging.roi.ROIWorkItem'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.roi.ROIWorkItem.class, 
	 				"ProcessROIGetStudyImagesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.roi.ROIWorkItem.class 
		  			},
 					new Object[]{
				 		workItem
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'ProcessROIGetStudyImagesCommand' in method 'processROIGetStudyImages' with parameters 'gov.va.med.imaging.roi.ROIWorkItem'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void processROICacheStudyImages(
 			gov.va.med.imaging.roi.ROIWorkItem workItem
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'ProcessROICacheStudyImagesCommand' and parameters 'gov.va.med.imaging.roi.ROIWorkItem'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.roi.ROIWorkItem.class, 
	 				"ProcessROICacheStudyImagesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.roi.ROIWorkItem.class 
		  			},
 					new Object[]{
				 		workItem
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'ProcessROICacheStudyImagesCommand' in method 'processROICacheStudyImages' with parameters 'gov.va.med.imaging.roi.ROIWorkItem'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void processROIAnnotateStudyImages(
 			gov.va.med.imaging.roi.ROIWorkItem workItem
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'ProcessROIAnnotateStudyImageCommand' and parameters 'gov.va.med.imaging.roi.ROIWorkItem'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.roi.ROIWorkItem.class, 
	 				"ProcessROIAnnotateStudyImageCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.roi.ROIWorkItem.class 
		  			},
 					new Object[]{
				 		workItem
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'ProcessROIAnnotateStudyImageCommand' in method 'processROIAnnotateStudyImages' with parameters 'gov.va.med.imaging.roi.ROIWorkItem'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void processROIMergeImages(
 			gov.va.med.imaging.roi.ROIWorkItem workItem
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'ProcessROIMergeImagesCommand' and parameters 'gov.va.med.imaging.roi.ROIWorkItem'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.roi.ROIWorkItem.class, 
	 				"ProcessROIMergeImagesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.roi.ROIWorkItem.class 
		  			},
 					new Object[]{
				 		workItem
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'ProcessROIMergeImagesCommand' in method 'processROIMergeImages' with parameters 'gov.va.med.imaging.roi.ROIWorkItem'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void processROIPeriodicRequests(
 		)
 		throws ValidationException
 		 { 			
 		 	getLogger().info("Searching for command 'ProcessROIPeriodicRequestsCommand' and parameters ''.");
 		 
	 		boolean result = getCommandFactory().isCommandSupported(
	 			 java.lang.Void.class, 
	 			"ProcessROIPeriodicRequestsCommand",
	 			"",
				new Class<?>[]{
				 	 
		  		},
				new Object[]{
			 		
		  		}
		  	);
		  	if(!result)
	  			throw new ValidationException("Cannot create command 'ProcessROIPeriodicRequestsCommand' in method 'processROIPeriodicRequests' with parameters ''.");
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getROIWorkItem(
 			java.lang.String guid
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetROIWorkItemByGuidCommand' and parameters 'java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.roi.ROIWorkItem.class, 
	 				"GetROIWorkItemByGuidCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class 
		  			},
 					new Object[]{
				 		guid
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetROIWorkItemByGuidCommand' in method 'getROIWorkItem' with parameters 'java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postReleaseOfInformationRequest(
 			gov.va.med.imaging.exchange.business.WorkItem workItem
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostReleaseOfInformationRequestDataSourceCommand' and parameters 'gov.va.med.imaging.exchange.business.WorkItem'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.WorkItem.class, 
	 				"PostReleaseOfInformationRequestDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.WorkItem.class 
		  			},
 					new Object[]{
				 		workItem
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostReleaseOfInformationRequestDataSourceCommand' in method 'postReleaseOfInformationRequest' with parameters 'gov.va.med.imaging.exchange.business.WorkItem'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void processOldUnfinishedROIRequests(
 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'ProcessOldUnfinishedROIRequestsCommand' and parameters ''.");
				boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Void.class, 
	 				"ProcessOldUnfinishedROIRequestsCommand",
	 				"",
 					new Class<?>[]{
				 		  
		  			},
 					new Object[]{
				 		
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'ProcessOldUnfinishedROIRequestsCommand'.");		  		
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void processROIWorkItem(
 			java.lang.String guid
 		)
 		throws ValidationException
 		 { 			
 		 	getLogger().info("Searching for command 'ProcessROIWorkItemCommand' and parameters 'java.lang.String'.");
 		 
	 		boolean result = getCommandFactory().isCommandSupported(
	 			 java.lang.Void.class, 
	 			"ProcessROIWorkItemCommand",
	 			"",
				new Class<?>[]{
				 	java.lang.String.class 
		  		},
				new Object[]{
			 		guid
		  		}
		  	);
		  	if(!result)
	  			throw new ValidationException("Cannot create command 'ProcessROIWorkItemCommand' in method 'processROIWorkItem' with parameters 'java.lang.String'.");
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postExportQueueRequest(
 			gov.va.med.imaging.roi.queue.AbstractExportQueueURN exportQueueUrn
 			, gov.va.med.imaging.AbstractImagingURN imagingUrn
 			, int exportPriority
 		)
 		throws ValidationException
 		 { 			
 		 	getLogger().info("Searching for command 'PostExportQueueRequestCommand' and parameters 'gov.va.med.imaging.roi.queue.AbstractExportQueueURN, gov.va.med.imaging.AbstractImagingURN, int'.");
 		 
	 		boolean result = getCommandFactory().isCommandSupported(
	 			 java.lang.Void.class, 
	 			"PostExportQueueRequestCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.imaging.roi.queue.AbstractExportQueueURN.class, gov.va.med.imaging.AbstractImagingURN.class, int.class 
		  		},
				new Object[]{
			 		exportQueueUrn,imagingUrn,exportPriority
		  		}
		  	);
		  	if(!result)
	  			throw new ValidationException("Cannot create command 'PostExportQueueRequestCommand' in method 'postExportQueueRequest' with parameters 'gov.va.med.imaging.roi.queue.AbstractExportQueueURN, gov.va.med.imaging.AbstractImagingURN, int'.");
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getROIWorkItemsByUser(
 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetROIWorkItemsByUserCommand' and parameters ''.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.WorkItem.class, 
 				"GetROIWorkItemsByUserCommand",
 				"",
				new Class<?>[]{
				 	 
	  			},
				new Object[]{
			 		
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetROIWorkItemsByUserCommand' in method 'getROIWorkItemsByUser' with parameters ''.");
 		}

 }