/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Oct 1, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author       DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
 package gov.va.med.imaging.roi.commands.facade;
 
 import java.util.Date;
 import org.apache.log4j.*;
 import gov.va.med.imaging.*;
 import gov.va.med.imaging.core.interfaces.exceptions.*;
 import gov.va.med.imaging.core.interfaces.router.Command;
 import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
 import javax.annotation.Generated;
 import gov.va.med.imaging.exchange.business.*;
 import gov.va.med.imaging.exchange.business.dicom.*;
 import gov.va.med.imaging.exchange.business.vistarad.*;
 import gov.va.med.imaging.artifactsource.*;
 
 /*
 * This is generated code and is recreated on every build.
 * Do not make changes directly in this code, as they will be lost (without warning).
 * Changes may be made to the template that generated this code (FacadeRouterImpl.ftl in
 * the CoreRouterAnnotationProcessor project), such changes will be reflected in
 * all facade router implementations.
 * 
 * This code was generated using FreeMarker, an open-source template processing engine.
 * See http://www.freemarker.org for documentation on the template syntax.
 */
 @Generated(value="gov.va.med.imaging.core.codegenerator.FacadeRouterCodeGenerator")
 public class ROICommandsRouterImpl
 extends gov.va.med.imaging.core.interfaces.router.AbstractFacadeRouterImpl 
 implements ROICommandsRouter
 {
	private static ROICommandsRouterImpl singleton;
 
 	/*
 	* The getSingleton() method is the only way to get a reference to the router facade.
 	*/
 	public static synchronized ROICommandsRouter getSingleton()
	{
		if(singleton == null)  
			singleton = new ROICommandsRouterImpl();
		
		return singleton; 
	} 
 
 	private Logger logger = Logger.getLogger(this.getClass());
 	
 	private Logger getLogger()
 	{
 		return logger;
 	}
 
 	/**
 	* The constructor is protected because the class may be derived from.
 	*/
 	protected ROICommandsRouterImpl()
 	{
 		super();
 	}
 
 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.storage.DataSourceInputStream burnImageAnnotationDetails(
 			java.io.InputStream inputStream
 		 			, gov.va.med.imaging.exchange.enums.ImageFormat imageFormat
 		 			, gov.va.med.imaging.exchange.business.annotations.ImageAnnotationDetails imageAnnotationDetails
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.storage.DataSourceInputStream> command = (Command<gov.va.med.imaging.exchange.storage.DataSourceInputStream>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.storage.DataSourceInputStream.class, 
	 				"PostImageAnnotationsDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 java.io.InputStream.class, gov.va.med.imaging.exchange.enums.ImageFormat.class, gov.va.med.imaging.exchange.business.annotations.ImageAnnotationDetails.class 
		  			},
 					new Object[]{
				 		inputStream,imageFormat,imageAnnotationDetails
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostImageAnnotationsDataSourceCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.storage.DataSourceInputStream commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.io.OutputStream getMergeImageOutputStream(
 			java.lang.String groupIdentifier
 		 			, java.lang.String imageIdentifier
 		 			, gov.va.med.imaging.exchange.enums.ImageFormat imageFormat
 		 			, java.lang.String objectDescription
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.io.OutputStream> command = (Command<java.io.OutputStream>)getCommandFactory().createCommand(
	 				 java.io.OutputStream.class, 
	 				"GetMergeImageOutputStreamDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class, java.lang.String.class, gov.va.med.imaging.exchange.enums.ImageFormat.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		groupIdentifier,imageIdentifier,imageFormat,objectDescription
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetMergeImageOutputStreamDataSourceCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        java.io.OutputStream commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.storage.DataSourceImageInputStream getMergeObjectsResponse(
 			java.lang.String groupIdentifier
 		 			, gov.va.med.imaging.exchange.business.Patient patient
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.storage.DataSourceImageInputStream> command = (Command<gov.va.med.imaging.exchange.storage.DataSourceImageInputStream>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.storage.DataSourceImageInputStream.class, 
	 				"GetMergeObjectsResponseDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class, gov.va.med.imaging.exchange.business.Patient.class 
		  			},
 					new Object[]{
				 		groupIdentifier,patient
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetMergeObjectsResponseDataSourceCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.storage.DataSourceImageInputStream commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.roi.ROIWorkItem processROIGetStudyImages(
 			gov.va.med.imaging.roi.ROIWorkItem workItem
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.roi.ROIWorkItem> command = (Command<gov.va.med.imaging.roi.ROIWorkItem>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.roi.ROIWorkItem.class, 
	 				"ProcessROIGetStudyImagesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.roi.ROIWorkItem.class 
		  			},
 					new Object[]{
				 		workItem
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("ProcessROIGetStudyImagesCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.roi.ROIWorkItem commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.roi.ROIWorkItem processROICacheStudyImages(
 			gov.va.med.imaging.roi.ROIWorkItem workItem
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.roi.ROIWorkItem> command = (Command<gov.va.med.imaging.roi.ROIWorkItem>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.roi.ROIWorkItem.class, 
	 				"ProcessROICacheStudyImagesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.roi.ROIWorkItem.class 
		  			},
 					new Object[]{
				 		workItem
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("ProcessROICacheStudyImagesCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.roi.ROIWorkItem commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.roi.ROIWorkItem processROIAnnotateStudyImages(
 			gov.va.med.imaging.roi.ROIWorkItem workItem
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.roi.ROIWorkItem> command = (Command<gov.va.med.imaging.roi.ROIWorkItem>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.roi.ROIWorkItem.class, 
	 				"ProcessROIAnnotateStudyImageCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.roi.ROIWorkItem.class 
		  			},
 					new Object[]{
				 		workItem
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("ProcessROIAnnotateStudyImageCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.roi.ROIWorkItem commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.roi.ROIWorkItem processROIMergeImages(
 			gov.va.med.imaging.roi.ROIWorkItem workItem
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.roi.ROIWorkItem> command = (Command<gov.va.med.imaging.roi.ROIWorkItem>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.roi.ROIWorkItem.class, 
	 				"ProcessROIMergeImagesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.roi.ROIWorkItem.class 
		  			},
 					new Object[]{
				 		workItem
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("ProcessROIMergeImagesCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.roi.ROIWorkItem commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void processROIPeriodicRequests(
 		) {
 			Command<?> command = null;
 			
	 		command = getCommandFactory().createCommand(
	 			 java.lang.Void.class, 
	 			"ProcessROIPeriodicRequestsCommand",
	 			"",
				new Class<?>[]{
				 	 
		  		},
				new Object[]{
			 		
		  		}
		  	);
		  		
			
			
			command.setPriority(2);
			command.setAccessibilityDate( new Date(System.currentTimeMillis() + 0) );
			
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
	      			command.setChildCommand(true);
		    command.setParentCommandIdString(transactionContext.getCommandId());
			
			getRouter().doAsynchronously(command);
			return;
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.roi.ROIWorkItem getROIWorkItem(
 			java.lang.String guid
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.roi.ROIWorkItem> command = (Command<gov.va.med.imaging.roi.ROIWorkItem>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.roi.ROIWorkItem.class, 
	 				"GetROIWorkItemByGuidCommand",
	 				"",
 					new Class<?>[]{
				 		 java.lang.String.class 
		  			},
 					new Object[]{
				 		guid
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetROIWorkItemByGuidCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.roi.ROIWorkItem commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.WorkItem postReleaseOfInformationRequest(
 			gov.va.med.imaging.exchange.business.WorkItem workItem
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.WorkItem> command = (Command<gov.va.med.imaging.exchange.business.WorkItem>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.WorkItem.class, 
	 				"PostReleaseOfInformationRequestDataSourceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.exchange.business.WorkItem.class 
		  			},
 					new Object[]{
				 		workItem
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostReleaseOfInformationRequestDataSourceCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
        gov.va.med.imaging.exchange.business.WorkItem commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void processOldUnfinishedROIRequests(
 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Void> command = (Command<java.lang.Void>)getCommandFactory().createCommand(
	 				 java.lang.Void.class, 
	 				"ProcessOldUnfinishedROIRequestsCommand",
	 				"",
 					new Class<?>[]{
				 		  
		  			},
 					new Object[]{
				 		
		  			}
		  		);
		  		
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("ProcessOldUnfinishedROIRequestsCommand");
		
		      			command.setChildCommand(true);
      					command.setParentCommandIdString(transactionContext.getCommandId());		      			
		      
		        getRouter().doSynchronously(command);
				return;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void processROIWorkItem(
 			java.lang.String guid
 		) {
 			Command<?> command = null;
 			
	 		command = getCommandFactory().createCommand(
	 			 java.lang.Void.class, 
	 			"ProcessROIWorkItemCommand",
	 			"",
				new Class<?>[]{
				 	java.lang.String.class 
		  		},
				new Object[]{
			 		guid
		  		}
		  	);
		  		
			
			
			command.setPriority(2);
			command.setAccessibilityDate( new Date(System.currentTimeMillis() + 0) );
			
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
	      			command.setChildCommand(true);
		    command.setParentCommandIdString(transactionContext.getCommandId());
			
			getRouter().doAsynchronously(command);
			return;
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterAsynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void postExportQueueRequest(
 			gov.va.med.imaging.roi.queue.AbstractExportQueueURN exportQueueUrn
 			, gov.va.med.imaging.AbstractImagingURN imagingUrn
 			, int exportPriority
 		) {
 			Command<?> command = null;
 			
	 		command = getCommandFactory().createCommand(
	 			 java.lang.Void.class, 
	 			"PostExportQueueRequestCommand",
	 			"",
				new Class<?>[]{
				 	gov.va.med.imaging.roi.queue.AbstractExportQueueURN.class, gov.va.med.imaging.AbstractImagingURN.class, int.class 
		  		},
				new Object[]{
			 		exportQueueUrn,imagingUrn,exportPriority
		  		}
		  	);
		  		
			
			
			command.setPriority(2);
			command.setAccessibilityDate( new Date(System.currentTimeMillis() + 0) );
			
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
	      			command.setChildCommand(true);
		    command.setParentCommandIdString(transactionContext.getCommandId());
			
			getRouter().doAsynchronously(command);
			return;
			
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.exchange.business.WorkItem> getROIWorkItemsByUser(
 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.exchange.business.WorkItem.class, 
 				"GetROIWorkItemsByUserCommand",
 				"",
				new Class<?>[]{
				 	 
	  			},
				new Object[]{
			 		
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetROIWorkItemsByUserCommand");
		
      			//transactionContext.setParentCommandId(transactionContext.getCommandId());
      			command.setChildCommand(true);
      			command.setParentCommandIdString(transactionContext.getCommandId());
      
			java.util.List<gov.va.med.imaging.exchange.business.WorkItem> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 }