/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Jun 12,2015
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author       DNS
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
package gov.va.med.imaging.vistaimagingdatasource.pathology;


import org.apache.log4j.Logger;

import java.io.IOException;

import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;
import gov.va.med.imaging.transactioncontext.TransactionContext;
import gov.va.med.imaging.vistadatasource.session.*;
import gov.va.med.imaging.url.vista.*;
import gov.va.med.imaging.url.vista.exceptions.*;
import gov.va.med.imaging.vistadatasource.common.*;
import gov.va.med.imaging.datasource.exceptions.*;
import gov.va.med.imaging.artifactsource.ResolvedArtifactSource;
import gov.va.med.imaging.exchange.business.ResolvedSite;
import gov.va.med.imaging.vistaimagingdatasource.common.VistaImagingCommonUtilities;
import gov.va.med.imaging.core.interfaces.exceptions.SecurityCredentialsExpiredException;
import gov.va.med.imaging.core.interfaces.exceptions.SecurityException;



@SuppressWarnings("unused") 
public class VistaImagingPathologyDataSourceServiceImpl
extends VistaImagingPathologyDataSourceService
{

	private final static Logger logger = Logger.getLogger(VistaImagingPathologyDataSourceServiceImpl.class);
	
	public VistaImagingPathologyDataSourceServiceImpl(ResolvedArtifactSource resolvedArtifactSource, 
			String protocol)
	{
		super(resolvedArtifactSource, protocol);
		if(! (resolvedArtifactSource instanceof ResolvedSite) )
			throw new UnsupportedOperationException("The artifact source must be an instance of ResolvedSite and it is a '" + resolvedArtifactSource.getClass().getSimpleName() + "'.");
	}

	public static VistaImagingPathologyDataSourceServiceImpl create(ResolvedArtifactSource resolvedArtifactSource, String protocol)
	throws ConnectionException, UnsupportedProtocolException
	{
		return new VistaImagingPathologyDataSourceServiceImpl(resolvedArtifactSource, protocol);
	}
	
	@Override
	public boolean isVersionCompatible() 
	throws SecurityException
	{
		String version = VistaImagingCommonUtilities.getVistaDataSourceImagingVersion(
				getVistaImagingConfiguration(), this.getClass(), 
				getVistaImagingRequiredVersion());
		
		logger.info("isVersionCompatible searching for version [" + version + "], TransactionContext (" + TransactionContextFactory.get().getDisplayIdentity() + ").");
		VistaSession localVistaSession = null;
		try
		{
			localVistaSession = getVistaSession();	
			return VistaImagingCommonUtilities.isVersionCompatible(version, localVistaSession);	
		}
		catch(SecurityCredentialsExpiredException sceX)
		{
			// caught here to be sure it gets thrown as SecurityCredentialsExpiredException, not ConnectionException
			throw sceX;
		}
		catch(MethodException mX)
		{
			logger.error("There was an error finding the installed Imaging version from VistA", mX);
			TransactionContextFactory.get().addDebugInformation("isVersionCompatible() failed, " + (mX == null ? "<null error>" : mX.getMessage()));
		}
		catch(ConnectionException cX)
		{
			logger.error("There was an error finding the installed Imaging version from VistA", cX);
			TransactionContextFactory.get().addDebugInformation("isVersionCompatible() failed, " + (cX == null ? "<null error>" : cX.getMessage()));
		}		
		catch(IOException ioX)
		{
			logger.error("There was an error finding the installed Imaging version from VistA", ioX);
			TransactionContextFactory.get().addDebugInformation("isVersionCompatible() failed, " + (ioX == null ? "<null error>" : ioX.getMessage()));
		}
		finally
		{
			try{localVistaSession.close();}
			catch(Throwable t){}
		}		
		return false;
	}
	
 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in VistaImagingDataSourceMethod.tfl
 	*/
 	@Override
 	public java.lang.Integer getLockExpiresMinutes(
 			gov.va.med.RoutingToken globalRoutingToken
 		 ) 
	throws MethodException, ConnectionException
	{
		
		VistaCommonUtilities.setDataSourceMethodAndVersion("getLockExpiresMinutes", getDataSourceVersion());
		logger.info("getLockExpiresMinutes () TransactionContext (" + TransactionContextFactory.get().getDisplayIdentity() + ").");
		VistaSession localVistaSession = null;
		try 
		{
			localVistaSession = getVistaSession();			
			VistaQuery query = gov.va.med.imaging.vistaimagingdatasource.pathology.query.VistaImagingPathologyQueryFactory.createGetLockMinutesQuery(
					
				);
			String rtn = localVistaSession.call(query);
					return gov.va.med.imaging.vistaimagingdatasource.pathology.translator.VistaImagingPathologyTranslator.translateLockMinutes(rtn);						
		}
		catch(IOException ioX)
		{
			logger.error("Exception getting VistA session", ioX);
        	throw new ConnectionException(ioX);
		}
		catch (InvalidVistaCredentialsException e)
		{
			throw new InvalidCredentialsException(e.getMessage());
		}
		catch (VistaMethodException e)
		{
			throw new MethodException(e.getMessage());
		}
		finally
        {
        	try{localVistaSession.close();}catch(Throwable t){}
        }
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in VistaImagingDataSourceMethod.tfl
 	*/
 	@Override
 	public java.util.List<gov.va.med.imaging.pathology.PathologyCaseSpecimen> getCaseSpecimens(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 ) 
	throws MethodException, ConnectionException
	{
		
		VistaCommonUtilities.setDataSourceMethodAndVersion("getCaseSpecimens", getDataSourceVersion());
		logger.info("getCaseSpecimens (" + pathologyCaseUrn.toString() + ") TransactionContext (" + TransactionContextFactory.get().getDisplayIdentity() + ").");
		VistaSession localVistaSession = null;
		try 
		{
			localVistaSession = getVistaSession();			
			VistaQuery query = gov.va.med.imaging.vistaimagingdatasource.pathology.query.VistaImagingPathologyQueryFactory.createGetSlidesVistaQuery(
						pathologyCaseUrn
				);
			String rtn = localVistaSession.call(query);
					return gov.va.med.imaging.vistaimagingdatasource.pathology.translator.VistaImagingPathologyTranslator.translateSpecimens(rtn);						
		}
		catch(IOException ioX)
		{
			logger.error("Exception getting VistA session", ioX);
        	throw new ConnectionException(ioX);
		}
		catch (InvalidVistaCredentialsException e)
		{
			throw new InvalidCredentialsException(e.getMessage());
		}
		catch (VistaMethodException e)
		{
			throw new MethodException(e.getMessage());
		}
		finally
        {
        	try{localVistaSession.close();}catch(Throwable t){}
        }
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in VistaImagingDataSourceMethod.tfl
 	*/
 	@Override
 	public java.util.List<gov.va.med.imaging.pathology.AbstractPathologySite> getSites(
 			gov.va.med.RoutingToken globalRoutingToken
 		 			, boolean reading
 		 ) 
	throws MethodException, ConnectionException
	{
		
		VistaCommonUtilities.setDataSourceMethodAndVersion("getSites", getDataSourceVersion());
		logger.info("getSites (" + reading + ") TransactionContext (" + TransactionContextFactory.get().getDisplayIdentity() + ").");
		VistaSession localVistaSession = null;
		try 
		{
			localVistaSession = getVistaSession();			
			VistaQuery query = gov.va.med.imaging.vistaimagingdatasource.pathology.query.VistaImagingPathologyQueryFactory.createGetSitesVistaQuery(
					reading
				);
			String rtn = localVistaSession.call(query);
					return gov.va.med.imaging.vistaimagingdatasource.pathology.translator.VistaImagingPathologyTranslator.translatePathologySites(rtn, reading);
		}
		catch(IOException ioX)
		{
			logger.error("Exception getting VistA session", ioX);
        	throw new ConnectionException(ioX);
		}
		catch (InvalidVistaCredentialsException e)
		{
			throw new InvalidCredentialsException(e.getMessage());
		}
		catch (VistaMethodException e)
		{
			throw new MethodException(e.getMessage());
		}
		finally
        {
        	try{localVistaSession.close();}catch(Throwable t){}
        }
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in VistaImagingDataSourceMethod.tfl
 	*/
 	@Override
 	public gov.va.med.imaging.pathology.PathologySaveCaseReportResult saveCaseReportFields(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, java.util.List<gov.va.med.imaging.pathology.PathologyCaseReportField> fields
 		 ) 
	throws MethodException, ConnectionException
	{
		
		VistaCommonUtilities.setDataSourceMethodAndVersion("saveCaseReportFields", getDataSourceVersion());
		logger.info("saveCaseReportFields (" + pathologyCaseUrn.toString() + ") TransactionContext (" + TransactionContextFactory.get().getDisplayIdentity() + ").");
		VistaSession localVistaSession = null;
		try 
		{
			localVistaSession = getVistaSession();			
			VistaQuery query = gov.va.med.imaging.vistaimagingdatasource.pathology.query.VistaImagingPathologyQueryFactory.createSaveCaseReportQuery(
						pathologyCaseUrn
						, fields
				);
			String rtn = localVistaSession.call(query);
					return gov.va.med.imaging.vistaimagingdatasource.pathology.translator.VistaImagingPathologyTranslator.translateSavingCaseReportFields(rtn);						
		}
		catch(IOException ioX)
		{
			logger.error("Exception getting VistA session", ioX);
        	throw new ConnectionException(ioX);
		}
		catch (InvalidVistaCredentialsException e)
		{
			throw new InvalidCredentialsException(e.getMessage());
		}
		catch (VistaMethodException e)
		{
			throw new MethodException(e.getMessage());
		}
		finally
        {
        	try{localVistaSession.close();}catch(Throwable t){}
        }
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in VistaImagingDataSourceMethod.tfl
 	*/
 	@Override
 	public void saveCaseSupplementalReport(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, java.lang.String reportContents
 		 			, java.util.Date date
 		 			, boolean verified
 		 ) 
	throws MethodException, ConnectionException
	{
		
		VistaCommonUtilities.setDataSourceMethodAndVersion("saveCaseSupplementalReport", getDataSourceVersion());
		logger.info("saveCaseSupplementalReport (" + pathologyCaseUrn.toString() + ") TransactionContext (" + TransactionContextFactory.get().getDisplayIdentity() + ").");
		VistaSession localVistaSession = null;
		try 
		{
			localVistaSession = getVistaSession();			
			VistaQuery query = gov.va.med.imaging.vistaimagingdatasource.pathology.query.VistaImagingPathologyQueryFactory.createSaveCaseSupplementalReportQuery(
						pathologyCaseUrn
						, reportContents
						, date
						, verified
				);
			String rtn = localVistaSession.call(query);
					gov.va.med.imaging.vistaimagingdatasource.pathology.translator.VistaImagingPathologyTranslator.translateSavingCaseSupplementalReport(rtn);
				return;
		}
		catch(IOException ioX)
		{
			logger.error("Exception getting VistA session", ioX);
        	throw new ConnectionException(ioX);
		}
		catch (InvalidVistaCredentialsException e)
		{
			throw new InvalidCredentialsException(e.getMessage());
		}
		catch (VistaMethodException e)
		{
			throw new MethodException(e.getMessage());
		}
		finally
        {
        	try{localVistaSession.close();}catch(Throwable t){}
        }
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in VistaImagingDataSourceMethod.tfl
 	*/
 	@Override
 	public java.util.List<gov.va.med.imaging.pathology.PathologySite> getSites(
 			gov.va.med.RoutingToken globalRoutingToken
 		 ) 
	throws MethodException, ConnectionException
	{
		
		VistaCommonUtilities.setDataSourceMethodAndVersion("getSites", getDataSourceVersion());
		logger.info("getSites () TransactionContext (" + TransactionContextFactory.get().getDisplayIdentity() + ").");
		VistaSession localVistaSession = null;
		try 
		{
			localVistaSession = getVistaSession();			
			VistaQuery query = gov.va.med.imaging.vistaimagingdatasource.pathology.query.VistaImagingPathologyQueryFactory.createGetSitesQuery(
					
				);
			String rtn = localVistaSession.call(query);
					return gov.va.med.imaging.vistaimagingdatasource.pathology.translator.VistaImagingPathologyTranslator.translateSites(rtn);						
		}
		catch(IOException ioX)
		{
			logger.error("Exception getting VistA session", ioX);
        	throw new ConnectionException(ioX);
		}
		catch (InvalidVistaCredentialsException e)
		{
			throw new InvalidCredentialsException(e.getMessage());
		}
		catch (VistaMethodException e)
		{
			throw new MethodException(e.getMessage());
		}
		finally
        {
        	try{localVistaSession.close();}catch(Throwable t){}
        }
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in VistaImagingDataSourceMethod.tfl
 	*/
 	@Override
 	public void setLockExpiresMinutes(
 			gov.va.med.RoutingToken globalRoutingToken
 		 			, int minutes
 		 ) 
	throws MethodException, ConnectionException
	{
		
		VistaCommonUtilities.setDataSourceMethodAndVersion("setLockExpiresMinutes", getDataSourceVersion());
		logger.info("setLockExpiresMinutes (" + minutes + ") TransactionContext (" + TransactionContextFactory.get().getDisplayIdentity() + ").");
		VistaSession localVistaSession = null;
		try 
		{
			localVistaSession = getVistaSession();			
			VistaQuery query = gov.va.med.imaging.vistaimagingdatasource.pathology.query.VistaImagingPathologyQueryFactory.createSetLockMinutesQuery(
					minutes
				);
			String rtn = localVistaSession.call(query);
					gov.va.med.imaging.vistaimagingdatasource.pathology.translator.VistaImagingPathologyTranslator.translateSavingLockMinutes(rtn);
				return;
		}
		catch(IOException ioX)
		{
			logger.error("Exception getting VistA session", ioX);
        	throw new ConnectionException(ioX);
		}
		catch (InvalidVistaCredentialsException e)
		{
			throw new InvalidCredentialsException(e.getMessage());
		}
		catch (VistaMethodException e)
		{
			throw new MethodException(e.getMessage());
		}
		finally
        {
        	try{localVistaSession.close();}catch(Throwable t){}
        }
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in VistaImagingDataSourceMethod.tfl
 	*/
 	@Override
 	public java.lang.String getPreferences(
 			gov.va.med.RoutingToken globalRoutingToken
 		 			, java.lang.String userId
 		 			, java.lang.String label
 		 ) 
	throws MethodException, ConnectionException
	{
		
		VistaCommonUtilities.setDataSourceMethodAndVersion("getPreferences", getDataSourceVersion());
		logger.info("getPreferences (" + userId + ", " + label + ") TransactionContext (" + TransactionContextFactory.get().getDisplayIdentity() + ").");
		VistaSession localVistaSession = null;
		try 
		{
			localVistaSession = getVistaSession();			
			VistaQuery query = gov.va.med.imaging.vistaimagingdatasource.pathology.query.VistaImagingPathologyQueryFactory.createGetUserPreferencesQuery(
					userId,label
				);
			String rtn = localVistaSession.call(query);
					return gov.va.med.imaging.vistaimagingdatasource.pathology.translator.VistaImagingPathologyTranslator.translateUserPreferences(rtn);						
		}
		catch(IOException ioX)
		{
			logger.error("Exception getting VistA session", ioX);
        	throw new ConnectionException(ioX);
		}
		catch (InvalidVistaCredentialsException e)
		{
			throw new InvalidCredentialsException(e.getMessage());
		}
		catch (VistaMethodException e)
		{
			throw new MethodException(e.getMessage());
		}
		finally
        {
        	try{localVistaSession.close();}catch(Throwable t){}
        }
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in VistaImagingDataSourceMethod.tfl
 	*/
 	@Override
 	public void savePreferences(
 			gov.va.med.RoutingToken globalRoutingToken
 		 			, java.lang.String userId
 		 			, java.lang.String label
 		 			, java.lang.String xml
 		 ) 
	throws MethodException, ConnectionException
	{
		
		VistaCommonUtilities.setDataSourceMethodAndVersion("savePreferences", getDataSourceVersion());
		logger.info("savePreferences (" + userId + ", " + label + ") TransactionContext (" + TransactionContextFactory.get().getDisplayIdentity() + ").");
		VistaSession localVistaSession = null;
		try 
		{
			localVistaSession = getVistaSession();			
			VistaQuery query = gov.va.med.imaging.vistaimagingdatasource.pathology.query.VistaImagingPathologyQueryFactory.createSaveUserPreferencesQuery(
					userId,label,xml
				);
			String rtn = localVistaSession.call(query);
					gov.va.med.imaging.vistaimagingdatasource.pathology.translator.VistaImagingPathologyTranslator.translateSavingUserPreferences(rtn);
				return;
		}
		catch(IOException ioX)
		{
			logger.error("Exception getting VistA session", ioX);
        	throw new ConnectionException(ioX);
		}
		catch (InvalidVistaCredentialsException e)
		{
			throw new InvalidCredentialsException(e.getMessage());
		}
		catch (VistaMethodException e)
		{
			throw new MethodException(e.getMessage());
		}
		finally
        {
        	try{localVistaSession.close();}catch(Throwable t){}
        }
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in VistaImagingDataSourceMethod.tfl
 	*/
 	@Override
 	public java.util.List<gov.va.med.imaging.pathology.PathologySnomedCode> getCaseSnomedCodes(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 ) 
	throws MethodException, ConnectionException
	{
		
		VistaCommonUtilities.setDataSourceMethodAndVersion("getCaseSnomedCodes", getDataSourceVersion());
		logger.info("getCaseSnomedCodes (" + pathologyCaseUrn.toString() + ") TransactionContext (" + TransactionContextFactory.get().getDisplayIdentity() + ").");
		VistaSession localVistaSession = null;
		try 
		{
			localVistaSession = getVistaSession();			
			VistaQuery query = gov.va.med.imaging.vistaimagingdatasource.pathology.query.VistaImagingPathologyQueryFactory.createGetSnomedCodesQuery(
						pathologyCaseUrn
				);
			String rtn = localVistaSession.call(query);
					return gov.va.med.imaging.vistaimagingdatasource.pathology.translator.VistaImagingPathologyTranslator.translateSnomedResults(rtn);						
		}
		catch(IOException ioX)
		{
			logger.error("Exception getting VistA session", ioX);
        	throw new ConnectionException(ioX);
		}
		catch (InvalidVistaCredentialsException e)
		{
			throw new InvalidCredentialsException(e.getMessage());
		}
		catch (VistaMethodException e)
		{
			throw new MethodException(e.getMessage());
		}
		finally
        {
        	try{localVistaSession.close();}catch(Throwable t){}
        }
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in VistaImagingDataSourceMethod.tfl
 	*/
 	@Override
 	public java.lang.String saveCaseSnomedCode(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, java.lang.String tissueId
 		 			, gov.va.med.imaging.pathology.PathologyFieldURN pathologyFieldUrn
 		 ) 
	throws MethodException, ConnectionException
	{
		
		VistaCommonUtilities.setDataSourceMethodAndVersion("saveCaseSnomedCode", getDataSourceVersion());
		logger.info("saveCaseSnomedCode (" + pathologyCaseUrn.toString() + ", " + "tissueId='" + tissueId + "'" + ", " + "field='" + pathologyFieldUrn.toString() + "'" + ") TransactionContext (" + TransactionContextFactory.get().getDisplayIdentity() + ").");
		VistaSession localVistaSession = null;
		try 
		{
			localVistaSession = getVistaSession();			
			VistaQuery query = gov.va.med.imaging.vistaimagingdatasource.pathology.query.VistaImagingPathologyQueryFactory.createSaveSnomedCodes(
						pathologyCaseUrn
						, tissueId
						, pathologyFieldUrn
				);
			String rtn = localVistaSession.call(query);
					return gov.va.med.imaging.vistaimagingdatasource.pathology.translator.VistaImagingPathologyTranslator.translateSavingSnomedCode(rtn);						
		}
		catch(IOException ioX)
		{
			logger.error("Exception getting VistA session", ioX);
        	throw new ConnectionException(ioX);
		}
		catch (InvalidVistaCredentialsException e)
		{
			throw new InvalidCredentialsException(e.getMessage());
		}
		catch (VistaMethodException e)
		{
			throw new MethodException(e.getMessage());
		}
		finally
        {
        	try{localVistaSession.close();}catch(Throwable t){}
        }
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in VistaImagingDataSourceMethod.tfl
 	*/
 	@Override
 	public java.lang.String saveCaseEtiologySnomedCodeForMorphology(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, java.lang.String tissueId
 		 			, java.lang.String morphologyId
 		 			, gov.va.med.imaging.pathology.PathologyFieldURN etiologyFieldUrn
 		 ) 
	throws MethodException, ConnectionException
	{
		
		VistaCommonUtilities.setDataSourceMethodAndVersion("saveCaseEtiologySnomedCodeForMorphology", getDataSourceVersion());
		logger.info("saveCaseEtiologySnomedCodeForMorphology (" + pathologyCaseUrn.toString() + ", " + "tissueId='" + tissueId + "'" + ", " + "morphologyId='" + morphologyId + "'" + ", " + "etiologyField='" + etiologyFieldUrn.toString() + "'" + ") TransactionContext (" + TransactionContextFactory.get().getDisplayIdentity() + ").");
		VistaSession localVistaSession = null;
		try 
		{
			localVistaSession = getVistaSession();			
			VistaQuery query = gov.va.med.imaging.vistaimagingdatasource.pathology.query.VistaImagingPathologyQueryFactory.createSaveSnomedCodes(
						pathologyCaseUrn
						, tissueId
						, morphologyId
						, etiologyFieldUrn
				);
			String rtn = localVistaSession.call(query);
					return gov.va.med.imaging.vistaimagingdatasource.pathology.translator.VistaImagingPathologyTranslator.translateSavingSnomedCode(rtn);						
		}
		catch(IOException ioX)
		{
			logger.error("Exception getting VistA session", ioX);
        	throw new ConnectionException(ioX);
		}
		catch (InvalidVistaCredentialsException e)
		{
			throw new InvalidCredentialsException(e.getMessage());
		}
		catch (VistaMethodException e)
		{
			throw new MethodException(e.getMessage());
		}
		finally
        {
        	try{localVistaSession.close();}catch(Throwable t){}
        }
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in VistaImagingDataSourceMethod.tfl
 	*/
 	@Override
 	public java.util.List<gov.va.med.imaging.pathology.PathologyCptCodeResult> saveCaseCptCodes(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, gov.va.med.imaging.pathology.PathologyFieldURN locationFieldUrn
 		 			, java.util.List<java.lang.String> cptCodes
 		 ) 
	throws MethodException, ConnectionException
	{
		
		VistaCommonUtilities.setDataSourceMethodAndVersion("saveCaseCptCodes", getDataSourceVersion());
		logger.info("saveCaseCptCodes (" + pathologyCaseUrn.toString() + ", " + "location='" + locationFieldUrn.toString() + "'" + ") TransactionContext (" + TransactionContextFactory.get().getDisplayIdentity() + ").");
		VistaSession localVistaSession = null;
		try 
		{
			localVistaSession = getVistaSession();			
			VistaQuery query = gov.va.med.imaging.vistaimagingdatasource.pathology.query.VistaImagingPathologyQueryFactory.createSaveCptCodesQuery(
						pathologyCaseUrn
						, locationFieldUrn
						, cptCodes
				);
			String rtn = localVistaSession.call(query);
					return gov.va.med.imaging.vistaimagingdatasource.pathology.translator.VistaImagingPathologyTranslator.translateSavingCptCode(rtn);						
		}
		catch(IOException ioX)
		{
			logger.error("Exception getting VistA session", ioX);
        	throw new ConnectionException(ioX);
		}
		catch (InvalidVistaCredentialsException e)
		{
			throw new InvalidCredentialsException(e.getMessage());
		}
		catch (VistaMethodException e)
		{
			throw new MethodException(e.getMessage());
		}
		finally
        {
        	try{localVistaSession.close();}catch(Throwable t){}
        }
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in VistaImagingDataSourceMethod.tfl
 	*/
 	@Override
 	public java.util.List<gov.va.med.imaging.pathology.PathologyCptCode> getCaseCptCodes(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 ) 
	throws MethodException, ConnectionException
	{
		
		VistaCommonUtilities.setDataSourceMethodAndVersion("getCaseCptCodes", getDataSourceVersion());
		logger.info("getCaseCptCodes (" + pathologyCaseUrn.toString() + ") TransactionContext (" + TransactionContextFactory.get().getDisplayIdentity() + ").");
		VistaSession localVistaSession = null;
		try 
		{
			localVistaSession = getVistaSession();			
			VistaQuery query = gov.va.med.imaging.vistaimagingdatasource.pathology.query.VistaImagingPathologyQueryFactory.createGetCptCodesQuery(
						pathologyCaseUrn
				);
			String rtn = localVistaSession.call(query);
					return gov.va.med.imaging.vistaimagingdatasource.pathology.translator.VistaImagingPathologyTranslator.translateCptCodesResults(rtn);						
		}
		catch(IOException ioX)
		{
			logger.error("Exception getting VistA session", ioX);
        	throw new ConnectionException(ioX);
		}
		catch (InvalidVistaCredentialsException e)
		{
			throw new InvalidCredentialsException(e.getMessage());
		}
		catch (VistaMethodException e)
		{
			throw new MethodException(e.getMessage());
		}
		finally
        {
        	try{localVistaSession.close();}catch(Throwable t){}
        }
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in VistaImagingDataSourceMethod.tfl
 	*/
 	@Override
 	public java.util.List<java.lang.String> getPathologyUserKeys(
 			gov.va.med.RoutingToken globalRoutingToken
 		 ) 
	throws MethodException, ConnectionException
	{
		
		VistaCommonUtilities.setDataSourceMethodAndVersion("getPathologyUserKeys", getDataSourceVersion());
		logger.info("getPathologyUserKeys () TransactionContext (" + TransactionContextFactory.get().getDisplayIdentity() + ").");
		VistaSession localVistaSession = null;
		try 
		{
			localVistaSession = getVistaSession();			
			VistaQuery query = gov.va.med.imaging.vistaimagingdatasource.pathology.query.VistaImagingPathologyQueryFactory.createGetUserQuery(
					
				);
			String rtn = localVistaSession.call(query);
					return gov.va.med.imaging.vistaimagingdatasource.pathology.translator.VistaImagingPathologyTranslator.translateUserKeys(rtn);						
		}
		catch(IOException ioX)
		{
			logger.error("Exception getting VistA session", ioX);
        	throw new ConnectionException(ioX);
		}
		catch (InvalidVistaCredentialsException e)
		{
			throw new InvalidCredentialsException(e.getMessage());
		}
		catch (VistaMethodException e)
		{
			throw new MethodException(e.getMessage());
		}
		finally
        {
        	try{localVistaSession.close();}catch(Throwable t){}
        }
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in VistaImagingDataSourceMethod.tfl
 	*/
 	@Override
 	public java.lang.Boolean checkPendingConsultationStatus(
 			gov.va.med.RoutingToken globalRoutingToken
 		 			, java.lang.String stationNumber
 		 ) 
	throws MethodException, ConnectionException
	{
		
		VistaCommonUtilities.setDataSourceMethodAndVersion("checkPendingConsultationStatus", getDataSourceVersion());
		logger.info("checkPendingConsultationStatus (" + stationNumber + ") TransactionContext (" + TransactionContextFactory.get().getDisplayIdentity() + ").");
		VistaSession localVistaSession = null;
		try 
		{
			localVistaSession = getVistaSession();			
			VistaQuery query = gov.va.med.imaging.vistaimagingdatasource.pathology.query.VistaImagingPathologyQueryFactory.createCheckPendingConsultations(
					stationNumber
				);
			String rtn = localVistaSession.call(query);
					return gov.va.med.imaging.vistaimagingdatasource.pathology.translator.VistaImagingPathologyTranslator.translateCheckPendingConsultations(rtn);						
		}
		catch(IOException ioX)
		{
			logger.error("Exception getting VistA session", ioX);
        	throw new ConnectionException(ioX);
		}
		catch (InvalidVistaCredentialsException e)
		{
			throw new InvalidCredentialsException(e.getMessage());
		}
		catch (VistaMethodException e)
		{
			throw new MethodException(e.getMessage());
		}
		finally
        {
        	try{localVistaSession.close();}catch(Throwable t){}
        }
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in VistaImagingDataSourceMethod.tfl
 	*/
 	@Override
 	public java.lang.String saveCaseTissue(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, gov.va.med.imaging.pathology.PathologyFieldURN tissueFieldUrn
 		 ) 
	throws MethodException, ConnectionException
	{
		
		VistaCommonUtilities.setDataSourceMethodAndVersion("saveCaseTissue", getDataSourceVersion());
		logger.info("saveCaseTissue (" + pathologyCaseUrn.toString() + ") TransactionContext (" + TransactionContextFactory.get().getDisplayIdentity() + ").");
		VistaSession localVistaSession = null;
		try 
		{
			localVistaSession = getVistaSession();			
			VistaQuery query = gov.va.med.imaging.vistaimagingdatasource.pathology.query.VistaImagingPathologyQueryFactory.createSaveCaseTissues(
						pathologyCaseUrn
						, tissueFieldUrn
				);
			String rtn = localVistaSession.call(query);
					return gov.va.med.imaging.vistaimagingdatasource.pathology.translator.VistaImagingPathologyTranslator.translateSavingSnomedCode(rtn);						
		}
		catch(IOException ioX)
		{
			logger.error("Exception getting VistA session", ioX);
        	throw new ConnectionException(ioX);
		}
		catch (InvalidVistaCredentialsException e)
		{
			throw new InvalidCredentialsException(e.getMessage());
		}
		catch (VistaMethodException e)
		{
			throw new MethodException(e.getMessage());
		}
		finally
        {
        	try{localVistaSession.close();}catch(Throwable t){}
        }
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in VistaImagingDataSourceMethod.tfl
 	*/
 	@Override
 	public void deleteSnomedCode(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, java.lang.String tissueId
 		 			, java.lang.String snomedId
 		 			, gov.va.med.imaging.pathology.enums.PathologyField snomedField
 		 			, java.lang.String etiologyId
 		 ) 
	throws MethodException, ConnectionException
	{
		
		VistaCommonUtilities.setDataSourceMethodAndVersion("deleteSnomedCode", getDataSourceVersion());
		logger.info("deleteSnomedCode (" + pathologyCaseUrn.toString() + ", " + "tissueId='" + tissueId + "'" + ", " + "snomedId='" + snomedId + "'" + ", " + "etiologyId='" + etiologyId + "'" + ") TransactionContext (" + TransactionContextFactory.get().getDisplayIdentity() + ").");
		VistaSession localVistaSession = null;
		try 
		{
			localVistaSession = getVistaSession();			
			VistaQuery query = gov.va.med.imaging.vistaimagingdatasource.pathology.query.VistaImagingPathologyQueryFactory.createDeleteSnomedCode(
					pathologyCaseUrn,tissueId,snomedId,snomedField,etiologyId
				);
			String rtn = localVistaSession.call(query);
					gov.va.med.imaging.vistaimagingdatasource.pathology.translator.VistaImagingPathologyTranslator.translateDeletingSnomedCode(rtn);
				return;
		}
		catch(IOException ioX)
		{
			logger.error("Exception getting VistA session", ioX);
        	throw new ConnectionException(ioX);
		}
		catch (InvalidVistaCredentialsException e)
		{
			throw new InvalidCredentialsException(e.getMessage());
		}
		catch (VistaMethodException e)
		{
			throw new MethodException(e.getMessage());
		}
		finally
        {
        	try{localVistaSession.close();}catch(Throwable t){}
        }
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in VistaImagingDataSourceMethod.tfl
 	*/
 	@Override
 	public void saveCaseNote(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, java.lang.String note
 		 ) 
	throws MethodException, ConnectionException
	{
		
		VistaCommonUtilities.setDataSourceMethodAndVersion("saveCaseNote", getDataSourceVersion());
		logger.info("saveCaseNote (" + pathologyCaseUrn.toString() + ") TransactionContext (" + TransactionContextFactory.get().getDisplayIdentity() + ").");
		VistaSession localVistaSession = null;
		try 
		{
			localVistaSession = getVistaSession();			
			VistaQuery query = gov.va.med.imaging.vistaimagingdatasource.pathology.query.VistaImagingPathologyQueryFactory.createSaveCaseNoteQuery(
						pathologyCaseUrn
						, note
				);
			String rtn = localVistaSession.call(query);
					gov.va.med.imaging.vistaimagingdatasource.pathology.translator.VistaImagingPathologyTranslator.translateSavingCaseNote(rtn);
				return;
		}
		catch(IOException ioX)
		{
			logger.error("Exception getting VistA session", ioX);
        	throw new ConnectionException(ioX);
		}
		catch (InvalidVistaCredentialsException e)
		{
			throw new InvalidCredentialsException(e.getMessage());
		}
		catch (VistaMethodException e)
		{
			throw new MethodException(e.getMessage());
		}
		finally
        {
        	try{localVistaSession.close();}catch(Throwable t){}
        }
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in VistaImagingDataSourceMethod.tfl
 	*/
 	@Override
 	public java.lang.String getCaseNote(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 ) 
	throws MethodException, ConnectionException
	{
		
		VistaCommonUtilities.setDataSourceMethodAndVersion("getCaseNote", getDataSourceVersion());
		logger.info("getCaseNote (" + pathologyCaseUrn.toString() + ") TransactionContext (" + TransactionContextFactory.get().getDisplayIdentity() + ").");
		VistaSession localVistaSession = null;
		try 
		{
			localVistaSession = getVistaSession();			
			VistaQuery query = gov.va.med.imaging.vistaimagingdatasource.pathology.query.VistaImagingPathologyQueryFactory.createGetCaseNoteQuery(
						pathologyCaseUrn
				);
			String rtn = localVistaSession.call(query);
					return gov.va.med.imaging.vistaimagingdatasource.pathology.translator.VistaImagingPathologyTranslator.translateCaseNote(rtn);						
		}
		catch(IOException ioX)
		{
			logger.error("Exception getting VistA session", ioX);
        	throw new ConnectionException(ioX);
		}
		catch (InvalidVistaCredentialsException e)
		{
			throw new InvalidCredentialsException(e.getMessage());
		}
		catch (VistaMethodException e)
		{
			throw new MethodException(e.getMessage());
		}
		finally
        {
        	try{localVistaSession.close();}catch(Throwable t){}
        }
	}

}