/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Oct 1, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author       DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
 package gov.va.med.imaging.federation.pathology;
 
 import java.util.Date;
 import org.apache.log4j.*;
 import gov.va.med.imaging.*;
 import gov.va.med.imaging.core.interfaces.exceptions.*;
 import gov.va.med.imaging.core.interfaces.router.Command;
 import gov.va.med.imaging.core.interfaces.router.CommandFactory;
 import gov.va.med.imaging.core.CommandFactoryImpl;
 import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
 import gov.va.med.exceptions.ValidationException;
 import javax.annotation.Generated;
 import gov.va.med.imaging.core.interfaces.router.CommandContext;

 import gov.va.med.imaging.exchange.business.*;
 import gov.va.med.imaging.exchange.business.dicom.*;
 import gov.va.med.imaging.exchange.business.vistarad.*;
 import gov.va.med.imaging.artifactsource.*;
 
 /*
 * This is generated code and is recreated on every build.
 * Do not make changes directly in this code, as they will be lost (without warning).
 * Changes may be made to the template that generated this code (FacadeRouterImpl.ftl in
 * the CoreRouterAnnotationProcessor project), such changes will be reflected in
 * all facade router implementations.
 * 
 * This code was generated using FreeMarker, an open-source template processing engine.
 * See http://www.freemarker.org for documentation on the template syntax.
 */
 @Generated(value="gov.va.med.imaging.core.codegenerator.FacadeRouterCodeGenerator")
 public class FederationPathologyRouterTest
 //extends  gov.va.med.imaging.BaseWebFacadeRouterImpl 
 {
	
 	private Logger logger = Logger.getLogger(this.getClass());
 	
 	private Logger getLogger()
 	{
 		return logger;
 	}
 	
 	private CommandFactory commandFactory = new CommandFactoryImpl((CommandContext)null);
 	private CommandFactory getCommandFactory()
 	{
 		return commandFactory;
 	}
 
 	/**
 	* The constructor is public so this tester can be created to test
 	*/
 	public FederationPathologyRouterTest()
 	{
 		super();
 	}
 
 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPathologyReadingSites(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPathologyReadingSitesCommand' and parameters 'gov.va.med.RoutingToken'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.pathology.AbstractPathologySite.class, 
 				"GetPathologyReadingSitesCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class 
	  			},
				new Object[]{
			 		routingToken
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetPathologyReadingSitesCommand' in method 'getPathologyReadingSites' with parameters 'gov.va.med.RoutingToken'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPathologyAcquisitionSites(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPathologyAcquisitionSitesCommand' and parameters 'gov.va.med.RoutingToken'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.pathology.AbstractPathologySite.class, 
 				"GetPathologyAcquisitionSitesCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class 
	  			},
				new Object[]{
			 		routingToken
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetPathologyAcquisitionSitesCommand' in method 'getPathologyAcquisitionSites' with parameters 'gov.va.med.RoutingToken'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPathologyCases(
 			gov.va.med.RoutingToken routingToken
 		 			, boolean released
 		 			, int days
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPathologyCasesCommand' and parameters 'gov.va.med.RoutingToken, boolean, int'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.pathology.PathologyCase.class, 
 				"GetPathologyCasesCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, boolean.class, int.class 
	  			},
				new Object[]{
			 		routingToken,released,days
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetPathologyCasesCommand' in method 'getPathologyCases' with parameters 'gov.va.med.RoutingToken, boolean, int'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPathologyCases(
 			gov.va.med.RoutingToken routingToken
 		 			, boolean released
 		 			, int days
 		 			, java.lang.String requestingSiteId
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPathologyCasesCommand' and parameters 'gov.va.med.RoutingToken, boolean, int, java.lang.String'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.pathology.PathologyCase.class, 
 				"GetPathologyCasesCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, boolean.class, int.class, java.lang.String.class 
	  			},
				new Object[]{
			 		routingToken,released,days,requestingSiteId
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetPathologyCasesCommand' in method 'getPathologyCases' with parameters 'gov.va.med.RoutingToken, boolean, int, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPatient(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPatientInformationCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.exchange.business.Patient.class, 
	 				"GetPatientInformationCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetPatientInformationCommand' in method 'getPatient' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPatientCases(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, java.lang.String requestingSiteId
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPathologyPatientCasesCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, java.lang.String'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.pathology.PathologyCase.class, 
 				"GetPathologyPatientCasesCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, java.lang.String.class 
	  			},
				new Object[]{
			 		routingToken,patientIdentifier,requestingSiteId
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetPathologyPatientCasesCommand' in method 'getPatientCases' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPatientCases(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPathologyPatientCasesCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.pathology.PathologyCase.class, 
 				"GetPathologyPatientCasesCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class 
	  			},
				new Object[]{
			 		routingToken,patientIdentifier
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetPathologyPatientCasesCommand' in method 'getPatientCases' with parameters 'gov.va.med.RoutingToken, gov.va.med.PatientIdentifier'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void lockPathologyCase(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, boolean lock
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostPathologyCaseLockCommand' and parameters 'gov.va.med.imaging.pathology.PathologyCaseURN, boolean'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.pathology.PathologyCaseUpdateAttributeResult.class, 
	 				"PostPathologyCaseLockCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.pathology.PathologyCaseURN.class, boolean.class 
		  			},
 					new Object[]{
				 		pathologyCaseUrn,lock
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostPathologyCaseLockCommand' in method 'lockPathologyCase' with parameters 'gov.va.med.imaging.pathology.PathologyCaseURN, boolean'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void addPathologyCaseAssistance(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, gov.va.med.imaging.pathology.enums.PathologyCaseAssistance assistanceType
 		 			, java.lang.String stationNumber
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostPathologyCaseAssistanceCommand' and parameters 'gov.va.med.imaging.pathology.PathologyCaseURN, gov.va.med.imaging.pathology.enums.PathologyCaseAssistance, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.pathology.PathologyCaseUpdateAttributeResult.class, 
	 				"PostPathologyCaseAssistanceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.pathology.PathologyCaseURN.class, gov.va.med.imaging.pathology.enums.PathologyCaseAssistance.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		pathologyCaseUrn,assistanceType,stationNumber
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostPathologyCaseAssistanceCommand' in method 'addPathologyCaseAssistance' with parameters 'gov.va.med.imaging.pathology.PathologyCaseURN, gov.va.med.imaging.pathology.enums.PathologyCaseAssistance, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPathologyCaseSpecimens(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPathologyCaseSpecimensCommand' and parameters 'gov.va.med.imaging.pathology.PathologyCaseURN'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.pathology.PathologyCaseSpecimen.class, 
 				"GetPathologyCaseSpecimensCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.imaging.pathology.PathologyCaseURN.class 
	  			},
				new Object[]{
			 		pathologyCaseUrn
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetPathologyCaseSpecimensCommand' in method 'getPathologyCaseSpecimens' with parameters 'gov.va.med.imaging.pathology.PathologyCaseURN'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPathologyTemplates(
 			gov.va.med.RoutingToken routingToken
 		 			, java.util.List<java.lang.String> apSections
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPathologySiteTemplateCommand' and parameters 'gov.va.med.RoutingToken, java.util.List'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 java.lang.String.class, 
 				"GetPathologySiteTemplateCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, java.util.List.class 
	  			},
				new Object[]{
			 		routingToken,apSections
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetPathologySiteTemplateCommand' in method 'getPathologyTemplates' with parameters 'gov.va.med.RoutingToken, java.util.List'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void updateReadingSite(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.pathology.PathologyReadingSite readingSite
 		 			, boolean delete
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostPathologyReadingSiteCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.pathology.PathologyReadingSite, boolean'.");
				boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Void.class, 
	 				"PostPathologyReadingSiteCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.pathology.PathologyReadingSite.class, boolean.class 
		  			},
 					new Object[]{
				 		routingToken,readingSite,delete
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostPathologyReadingSiteCommand'.");		  		
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void updateAcquisitionSite(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.pathology.PathologyAcquisitionSite acquisitionSite
 		 			, boolean delete
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostPathologyAcquisitionSiteCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.pathology.PathologyAcquisitionSite, boolean'.");
				boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Void.class, 
	 				"PostPathologyAcquisitionSiteCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.pathology.PathologyAcquisitionSite.class, boolean.class 
		  			},
 					new Object[]{
				 		routingToken,acquisitionSite,delete
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostPathologyAcquisitionSiteCommand'.");		  		
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void saveSiteTemplate(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String apSection
 		 			, java.lang.String xmlTemplate
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostPathologySiteTemplateCommand' and parameters 'gov.va.med.RoutingToken, java.lang.String, java.lang.String'.");
				boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Void.class, 
	 				"PostPathologySiteTemplateCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,apSection,xmlTemplate
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostPathologySiteTemplateCommand'.");		  		
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPathologyCaseSupplementalReports(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPathologyCaseSupplementalReportsCommand' and parameters 'gov.va.med.imaging.pathology.PathologyCaseURN'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.pathology.PathologyCaseSupplementalReport.class, 
 				"GetPathologyCaseSupplementalReportsCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.imaging.pathology.PathologyCaseURN.class 
	  			},
				new Object[]{
			 		pathologyCaseUrn
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetPathologyCaseSupplementalReportsCommand' in method 'getPathologyCaseSupplementalReports' with parameters 'gov.va.med.imaging.pathology.PathologyCaseURN'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPathologyCaseReport(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPathologyCaseReportCommand' and parameters 'gov.va.med.imaging.pathology.PathologyCaseURN'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.String.class, 
	 				"GetPathologyCaseReportCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.pathology.PathologyCaseURN.class 
		  			},
 					new Object[]{
				 		pathologyCaseUrn
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetPathologyCaseReportCommand' in method 'getPathologyCaseReport' with parameters 'gov.va.med.imaging.pathology.PathologyCaseURN'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPathologyCaseTemplateData(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, java.util.List<java.lang.String> fields
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPathologyCaseTemplateDataCommand' and parameters 'gov.va.med.imaging.pathology.PathologyCaseURN, java.util.List'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.pathology.PathologyCaseTemplate.class, 
	 				"GetPathologyCaseTemplateDataCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.pathology.PathologyCaseURN.class, java.util.List.class 
		  			},
 					new Object[]{
				 		pathologyCaseUrn,fields
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetPathologyCaseTemplateDataCommand' in method 'getPathologyCaseTemplateData' with parameters 'gov.va.med.imaging.pathology.PathologyCaseURN, java.util.List'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void reservePathologyCase(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, boolean lock
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostPathologyCaseReserveCommand' and parameters 'gov.va.med.imaging.pathology.PathologyCaseURN, boolean'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.pathology.enums.PathologyCaseReserveResult.class, 
	 				"PostPathologyCaseReserveCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.pathology.PathologyCaseURN.class, boolean.class 
		  			},
 					new Object[]{
				 		pathologyCaseUrn,lock
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostPathologyCaseReserveCommand' in method 'reservePathologyCase' with parameters 'gov.va.med.imaging.pathology.PathologyCaseURN, boolean'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void checkElectronicSignatureNeeded(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String apSection
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPathologyElectronicSignatureNeedCommand' and parameters 'gov.va.med.RoutingToken, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.pathology.enums.PathologyElectronicSignatureNeed.class, 
	 				"GetPathologyElectronicSignatureNeedCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,apSection
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetPathologyElectronicSignatureNeedCommand' in method 'checkElectronicSignatureNeeded' with parameters 'gov.va.med.RoutingToken, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPathologyFieldValues(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.pathology.enums.PathologyField pathologyField
 		 			, java.lang.String searchParameter
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPathologyFieldValuesCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.pathology.enums.PathologyField, java.lang.String'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.pathology.PathologyFieldValue.class, 
 				"GetPathologyFieldValuesCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.imaging.pathology.enums.PathologyField.class, java.lang.String.class 
	  			},
				new Object[]{
			 		routingToken,pathologyField,searchParameter
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetPathologyFieldValuesCommand' in method 'getPathologyFieldValues' with parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.pathology.enums.PathologyField, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void updatePathologyCaseConsultationStatus(
 			gov.va.med.imaging.pathology.PathologyCaseConsultationURN pathologyCaseConsultationUrn
 		 			, gov.va.med.imaging.pathology.enums.PathologyCaseConsultationUpdateStatus pathologyCaseConsultationUpdateStatus
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostPathologyCaseConsultationStatusCommand' and parameters 'gov.va.med.imaging.pathology.PathologyCaseConsultationURN, gov.va.med.imaging.pathology.enums.PathologyCaseConsultationUpdateStatus'.");
				boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Void.class, 
	 				"PostPathologyCaseConsultationStatusCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.pathology.PathologyCaseConsultationURN.class, gov.va.med.imaging.pathology.enums.PathologyCaseConsultationUpdateStatus.class 
		  			},
 					new Object[]{
				 		pathologyCaseConsultationUrn,pathologyCaseConsultationUpdateStatus
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostPathologyCaseConsultationStatusCommand'.");		  		
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void savePathologyCaseReportFields(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, java.util.List<gov.va.med.imaging.pathology.PathologyCaseReportField> fields
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostPathologyCaseReportFieldsCommand' and parameters 'gov.va.med.imaging.pathology.PathologyCaseURN, java.util.List'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.pathology.PathologySaveCaseReportResult.class, 
	 				"PostPathologyCaseReportFieldsCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.pathology.PathologyCaseURN.class, java.util.List.class 
		  			},
 					new Object[]{
				 		pathologyCaseUrn,fields
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostPathologyCaseReportFieldsCommand' in method 'savePathologyCaseReportFields' with parameters 'gov.va.med.imaging.pathology.PathologyCaseURN, java.util.List'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void savePathologyCaseSupplementalReport(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, java.lang.String reportContents
 		 			, java.util.Date date
 		 			, boolean verified
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostPathologyCaseSupplementalReportCommand' and parameters 'gov.va.med.imaging.pathology.PathologyCaseURN, java.lang.String, java.util.Date, boolean'.");
				boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Void.class, 
	 				"PostPathologyCaseSupplementalReportCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.pathology.PathologyCaseURN.class, java.lang.String.class, java.util.Date.class, boolean.class 
		  			},
 					new Object[]{
				 		pathologyCaseUrn,reportContents,date,verified
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostPathologyCaseSupplementalReportCommand'.");		  		
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPathologySites(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPathologySitesCommand' and parameters 'gov.va.med.RoutingToken'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.pathology.PathologySite.class, 
 				"GetPathologySitesCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class 
	  			},
				new Object[]{
			 		routingToken
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetPathologySitesCommand' in method 'getPathologySites' with parameters 'gov.va.med.RoutingToken'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getLockMinutes(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPathologyLockMinutesCommand' and parameters 'gov.va.med.RoutingToken'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Integer.class, 
	 				"GetPathologyLockMinutesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class 
		  			},
 					new Object[]{
				 		routingToken
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetPathologyLockMinutesCommand' in method 'getLockMinutes' with parameters 'gov.va.med.RoutingToken'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void saveLockMinutes(
 			gov.va.med.RoutingToken routingToken
 		 			, int minutes
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostPathologyLockMinutesCommand' and parameters 'gov.va.med.RoutingToken, int'.");
				boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Void.class, 
	 				"PostPathologyLockMinutesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, int.class 
		  			},
 					new Object[]{
				 		routingToken,minutes
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostPathologyLockMinutesCommand'.");		  		
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void saveUserPreferences(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String userId
 		 			, java.lang.String label
 		 			, java.lang.String xml
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostPathologyPreferencesCommand' and parameters 'gov.va.med.RoutingToken, java.lang.String, java.lang.String, java.lang.String'.");
				boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Void.class, 
	 				"PostPathologyPreferencesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class, java.lang.String.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,userId,label,xml
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostPathologyPreferencesCommand'.");		  		
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void savePreferences(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String label
 		 			, java.lang.String xml
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostPathologyPreferencesCommand' and parameters 'gov.va.med.RoutingToken, java.lang.String, java.lang.String'.");
				boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Void.class, 
	 				"PostPathologyPreferencesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,label,xml
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostPathologyPreferencesCommand'.");		  		
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getUserPreferences(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String userId
 		 			, java.lang.String label
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPathologyPreferencesCommand' and parameters 'gov.va.med.RoutingToken, java.lang.String, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.String.class, 
	 				"GetPathologyPreferencesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,userId,label
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetPathologyPreferencesCommand' in method 'getUserPreferences' with parameters 'gov.va.med.RoutingToken, java.lang.String, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPreferences(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String label
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPathologyPreferencesCommand' and parameters 'gov.va.med.RoutingToken, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.String.class, 
	 				"GetPathologyPreferencesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,label
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetPathologyPreferencesCommand' in method 'getPreferences' with parameters 'gov.va.med.RoutingToken, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPathologyCaseSnomedCodes(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPathologyCaseSnomedCodesCommand' and parameters 'gov.va.med.imaging.pathology.PathologyCaseURN'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.pathology.PathologySnomedCode.class, 
 				"GetPathologyCaseSnomedCodesCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.imaging.pathology.PathologyCaseURN.class 
	  			},
				new Object[]{
			 		pathologyCaseUrn
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetPathologyCaseSnomedCodesCommand' in method 'getPathologyCaseSnomedCodes' with parameters 'gov.va.med.imaging.pathology.PathologyCaseURN'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void savePathologyCaseMorphologySnomedCode(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, java.lang.String tissueId
 		 			, java.lang.String morphologyId
 		 			, gov.va.med.imaging.pathology.PathologyFieldURN etiologyFieldUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostPathologyCaseMorphologySnomedCodeCommand' and parameters 'gov.va.med.imaging.pathology.PathologyCaseURN, java.lang.String, java.lang.String, gov.va.med.imaging.pathology.PathologyFieldURN'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.String.class, 
	 				"PostPathologyCaseMorphologySnomedCodeCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.pathology.PathologyCaseURN.class, java.lang.String.class, java.lang.String.class, gov.va.med.imaging.pathology.PathologyFieldURN.class 
		  			},
 					new Object[]{
				 		pathologyCaseUrn,tissueId,morphologyId,etiologyFieldUrn
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostPathologyCaseMorphologySnomedCodeCommand' in method 'savePathologyCaseMorphologySnomedCode' with parameters 'gov.va.med.imaging.pathology.PathologyCaseURN, java.lang.String, java.lang.String, gov.va.med.imaging.pathology.PathologyFieldURN'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void savePathologyCaseSnomedCode(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, java.lang.String tissueId
 		 			, gov.va.med.imaging.pathology.PathologyFieldURN pathologyFieldUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostPathologyCaseSnomedCodeCommand' and parameters 'gov.va.med.imaging.pathology.PathologyCaseURN, java.lang.String, gov.va.med.imaging.pathology.PathologyFieldURN'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.String.class, 
	 				"PostPathologyCaseSnomedCodeCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.pathology.PathologyCaseURN.class, java.lang.String.class, gov.va.med.imaging.pathology.PathologyFieldURN.class 
		  			},
 					new Object[]{
				 		pathologyCaseUrn,tissueId,pathologyFieldUrn
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostPathologyCaseSnomedCodeCommand' in method 'savePathologyCaseSnomedCode' with parameters 'gov.va.med.imaging.pathology.PathologyCaseURN, java.lang.String, gov.va.med.imaging.pathology.PathologyFieldURN'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void savePathologyCaseCptCodes(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, gov.va.med.imaging.pathology.PathologyFieldURN locationFieldUrn
 		 			, java.util.List<java.lang.String> cptCodes
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostPathologyCaseCptCodesCommand' and parameters 'gov.va.med.imaging.pathology.PathologyCaseURN, gov.va.med.imaging.pathology.PathologyFieldURN, java.util.List'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.pathology.PathologyCptCodeResult.class, 
 				"PostPathologyCaseCptCodesCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.imaging.pathology.PathologyCaseURN.class, gov.va.med.imaging.pathology.PathologyFieldURN.class, java.util.List.class 
	  			},
				new Object[]{
			 		pathologyCaseUrn,locationFieldUrn,cptCodes
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'PostPathologyCaseCptCodesCommand' in method 'savePathologyCaseCptCodes' with parameters 'gov.va.med.imaging.pathology.PathologyCaseURN, gov.va.med.imaging.pathology.PathologyFieldURN, java.util.List'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPathologyCaseCptCodes(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPathologyCaseCptCodesCommand' and parameters 'gov.va.med.imaging.pathology.PathologyCaseURN'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.pathology.PathologyCptCode.class, 
 				"GetPathologyCaseCptCodesCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.imaging.pathology.PathologyCaseURN.class 
	  			},
				new Object[]{
			 		pathologyCaseUrn
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetPathologyCaseCptCodesCommand' in method 'getPathologyCaseCptCodes' with parameters 'gov.va.med.imaging.pathology.PathologyCaseURN'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getPathologyKeys(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPathologyUserKeysCommand' and parameters 'gov.va.med.RoutingToken'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 java.lang.String.class, 
 				"GetPathologyUserKeysCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class 
	  			},
				new Object[]{
			 		routingToken
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetPathologyUserKeysCommand' in method 'getPathologyKeys' with parameters 'gov.va.med.RoutingToken'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getSpecificCases(
 			java.util.List<gov.va.med.imaging.pathology.PathologyCaseURN> cases
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPathologySpecificCasesCommand' and parameters 'java.util.List'.");
 			boolean result = getCommandFactory().isCollectionCommandSupported(
 				 java.util.List.class, 
 				 gov.va.med.imaging.pathology.PathologyCase.class, 
 				"GetPathologySpecificCasesCommand",
 				"",
				new Class<?>[]{
				 	java.util.List.class 
	  			},
				new Object[]{
			 		cases
	  			}
	  		);
      
			if(!result)
	  			throw new ValidationException("Cannot create command 'GetPathologySpecificCasesCommand' in method 'getSpecificCases' with parameters 'java.util.List'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void checkPendingConsultationStatus(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String stationNumber
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPathologyPendingConsultationsCommand' and parameters 'gov.va.med.RoutingToken, java.lang.String'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Boolean.class, 
	 				"GetPathologyPendingConsultationsCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,stationNumber
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetPathologyPendingConsultationsCommand' in method 'checkPendingConsultationStatus' with parameters 'gov.va.med.RoutingToken, java.lang.String'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void savePathologyCaseTissues(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, gov.va.med.imaging.pathology.PathologyFieldURN pathologyTissueUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostPathologyCaseTissueCommand' and parameters 'gov.va.med.imaging.pathology.PathologyCaseURN, gov.va.med.imaging.pathology.PathologyFieldURN'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.String.class, 
	 				"PostPathologyCaseTissueCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.pathology.PathologyCaseURN.class, gov.va.med.imaging.pathology.PathologyFieldURN.class 
		  			},
 					new Object[]{
				 		pathologyCaseUrn,pathologyTissueUrn
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostPathologyCaseTissueCommand' in method 'savePathologyCaseTissues' with parameters 'gov.va.med.imaging.pathology.PathologyCaseURN, gov.va.med.imaging.pathology.PathologyFieldURN'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void copyPathologyCase(
 			gov.va.med.RoutingToken globalRoutingToken
 		 			, gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostPathologyCopyCaseCommand' and parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.pathology.PathologyCaseURN'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 gov.va.med.imaging.pathology.PathologyCaseURN.class, 
	 				"PostPathologyCopyCaseCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.pathology.PathologyCaseURN.class 
		  			},
 					new Object[]{
				 		globalRoutingToken,pathologyCaseUrn
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostPathologyCopyCaseCommand' in method 'copyPathologyCase' with parameters 'gov.va.med.RoutingToken, gov.va.med.imaging.pathology.PathologyCaseURN'.");
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void deleteSnomedEtiologyCode(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, java.lang.String tissueId
 		 			, java.lang.String snomedId
 		 			, java.lang.String etiologyId
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'DeletePathologyCaseEtiologySnomedCodeCommand' and parameters 'gov.va.med.imaging.pathology.PathologyCaseURN, java.lang.String, java.lang.String, java.lang.String'.");
				boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Void.class, 
	 				"DeletePathologyCaseEtiologySnomedCodeCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.pathology.PathologyCaseURN.class, java.lang.String.class, java.lang.String.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		pathologyCaseUrn,tissueId,snomedId,etiologyId
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'DeletePathologyCaseEtiologySnomedCodeCommand'.");		  		
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void deleteSnomedCode(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, java.lang.String tissueId
 		 			, java.lang.String snomedId
 		 			, gov.va.med.imaging.pathology.enums.PathologyField snomedField
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'DeletePathologyCaseSnomedCodeCommand' and parameters 'gov.va.med.imaging.pathology.PathologyCaseURN, java.lang.String, java.lang.String, gov.va.med.imaging.pathology.enums.PathologyField'.");
				boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Void.class, 
	 				"DeletePathologyCaseSnomedCodeCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.pathology.PathologyCaseURN.class, java.lang.String.class, java.lang.String.class, gov.va.med.imaging.pathology.enums.PathologyField.class 
		  			},
 					new Object[]{
				 		pathologyCaseUrn,tissueId,snomedId,snomedField
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'DeletePathologyCaseSnomedCodeCommand'.");		  		
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void deleteTissue(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, java.lang.String tissueId
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'DeletePathologyCaseTissueCommand' and parameters 'gov.va.med.imaging.pathology.PathologyCaseURN, java.lang.String'.");
				boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Void.class, 
	 				"DeletePathologyCaseTissueCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.pathology.PathologyCaseURN.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		pathologyCaseUrn,tissueId
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'DeletePathologyCaseTissueCommand'.");		  		
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void saveCaseNote(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, java.lang.String note
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'PostPathologyCaseNoteCommand' and parameters 'gov.va.med.imaging.pathology.PathologyCaseURN, java.lang.String'.");
				boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.Void.class, 
	 				"PostPathologyCaseNoteCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.pathology.PathologyCaseURN.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		pathologyCaseUrn,note
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'PostPathologyCaseNoteCommand'.");		  		
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void getCaseNote(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 ) 
 		throws ValidationException
 		{
 			getLogger().info("Searching for command 'GetPathologyCaseNoteCommand' and parameters 'gov.va.med.imaging.pathology.PathologyCaseURN'.");
	 			boolean result = getCommandFactory().isCommandSupported(
	 				 java.lang.String.class, 
	 				"GetPathologyCaseNoteCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.pathology.PathologyCaseURN.class 
		  			},
 					new Object[]{
				 		pathologyCaseUrn
		  			}
		  		);
		  		if(!result)
		  			throw new ValidationException("Cannot create command 'GetPathologyCaseNoteCommand' in method 'getCaseNote' with parameters 'gov.va.med.imaging.pathology.PathologyCaseURN'.");
 		}

 }