/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Oct 1, 2008
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author       DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
 package gov.va.med.imaging.federation.pathology;
 
 import java.util.Date;
 import org.apache.log4j.*;
 import gov.va.med.imaging.*;
 import gov.va.med.imaging.core.interfaces.exceptions.*;
 import gov.va.med.imaging.core.interfaces.router.Command;
 import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
 import javax.annotation.Generated;
 import gov.va.med.imaging.exchange.business.*;
 import gov.va.med.imaging.exchange.business.dicom.*;
 import gov.va.med.imaging.exchange.business.vistarad.*;
 import gov.va.med.imaging.artifactsource.*;
 
 /*
 * This is generated code and is recreated on every build.
 * Do not make changes directly in this code, as they will be lost (without warning).
 * Changes may be made to the template that generated this code (FacadeRouterImpl.ftl in
 * the CoreRouterAnnotationProcessor project), such changes will be reflected in
 * all facade router implementations.
 * 
 * This code was generated using FreeMarker, an open-source template processing engine.
 * See http://www.freemarker.org for documentation on the template syntax.
 */
 @Generated(value="gov.va.med.imaging.core.codegenerator.FacadeRouterCodeGenerator")
 public class FederationPathologyRouterImpl
 extends  gov.va.med.imaging.BaseWebFacadeRouterImpl 
 implements FederationPathologyRouter
 {
	private static FederationPathologyRouterImpl singleton;
 
 	/*
 	* The getSingleton() method is the only way to get a reference to the router facade.
 	*/
 	public static synchronized FederationPathologyRouter getSingleton()
	{
		if(singleton == null)  
			singleton = new FederationPathologyRouterImpl();
		
		return singleton; 
	} 
 
 	private Logger logger = Logger.getLogger(this.getClass());
 	
 	private Logger getLogger()
 	{
 		return logger;
 	}
 
 	/**
 	* The constructor is protected because the class may be derived from.
 	*/
 	protected FederationPathologyRouterImpl()
 	{
 		super();
 	}
 
 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.pathology.AbstractPathologySite> getPathologyReadingSites(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.pathology.AbstractPathologySite.class, 
 				"GetPathologyReadingSitesCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class 
	  			},
				new Object[]{
			 		routingToken
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetPathologyReadingSitesCommand");
		
      
			java.util.List<gov.va.med.imaging.pathology.AbstractPathologySite> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.pathology.AbstractPathologySite> getPathologyAcquisitionSites(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.pathology.AbstractPathologySite.class, 
 				"GetPathologyAcquisitionSitesCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class 
	  			},
				new Object[]{
			 		routingToken
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetPathologyAcquisitionSitesCommand");
		
      
			java.util.List<gov.va.med.imaging.pathology.AbstractPathologySite> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.pathology.PathologyCase> getPathologyCases(
 			gov.va.med.RoutingToken routingToken
 		 			, boolean released
 		 			, int days
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.pathology.PathologyCase.class, 
 				"GetPathologyCasesCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, boolean.class, int.class 
	  			},
				new Object[]{
			 		routingToken,released,days
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetPathologyCasesCommand");
		
      
			java.util.List<gov.va.med.imaging.pathology.PathologyCase> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.pathology.PathologyCase> getPathologyCases(
 			gov.va.med.RoutingToken routingToken
 		 			, boolean released
 		 			, int days
 		 			, java.lang.String requestingSiteId
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.pathology.PathologyCase.class, 
 				"GetPathologyCasesCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, boolean.class, int.class, java.lang.String.class 
	  			},
				new Object[]{
			 		routingToken,released,days,requestingSiteId
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetPathologyCasesCommand");
		
      
			java.util.List<gov.va.med.imaging.pathology.PathologyCase> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.exchange.business.Patient getPatient(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.exchange.business.Patient> command = (Command<gov.va.med.imaging.exchange.business.Patient>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.exchange.business.Patient.class, 
	 				"GetPatientInformationCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class 
		  			},
 					new Object[]{
				 		routingToken,patientIdentifier
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetPatientInformationCommand");
		
      
        gov.va.med.imaging.exchange.business.Patient commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.pathology.PathologyCase> getPatientCases(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 			, java.lang.String requestingSiteId
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.pathology.PathologyCase.class, 
 				"GetPathologyPatientCasesCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class, java.lang.String.class 
	  			},
				new Object[]{
			 		routingToken,patientIdentifier,requestingSiteId
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetPathologyPatientCasesCommand");
		
      
			java.util.List<gov.va.med.imaging.pathology.PathologyCase> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.pathology.PathologyCase> getPatientCases(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.pathology.PathologyCase.class, 
 				"GetPathologyPatientCasesCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.PatientIdentifier.class 
	  			},
				new Object[]{
			 		routingToken,patientIdentifier
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetPathologyPatientCasesCommand");
		
      
			java.util.List<gov.va.med.imaging.pathology.PathologyCase> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.pathology.PathologyCaseUpdateAttributeResult lockPathologyCase(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, boolean lock
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.pathology.PathologyCaseUpdateAttributeResult> command = (Command<gov.va.med.imaging.pathology.PathologyCaseUpdateAttributeResult>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.pathology.PathologyCaseUpdateAttributeResult.class, 
	 				"PostPathologyCaseLockCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.pathology.PathologyCaseURN.class, boolean.class 
		  			},
 					new Object[]{
				 		pathologyCaseUrn,lock
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostPathologyCaseLockCommand");
		
      
        gov.va.med.imaging.pathology.PathologyCaseUpdateAttributeResult commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.pathology.PathologyCaseUpdateAttributeResult addPathologyCaseAssistance(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, gov.va.med.imaging.pathology.enums.PathologyCaseAssistance assistanceType
 		 			, java.lang.String stationNumber
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.pathology.PathologyCaseUpdateAttributeResult> command = (Command<gov.va.med.imaging.pathology.PathologyCaseUpdateAttributeResult>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.pathology.PathologyCaseUpdateAttributeResult.class, 
	 				"PostPathologyCaseAssistanceCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.pathology.PathologyCaseURN.class, gov.va.med.imaging.pathology.enums.PathologyCaseAssistance.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		pathologyCaseUrn,assistanceType,stationNumber
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostPathologyCaseAssistanceCommand");
		
      
        gov.va.med.imaging.pathology.PathologyCaseUpdateAttributeResult commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.pathology.PathologyCaseSpecimen> getPathologyCaseSpecimens(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.pathology.PathologyCaseSpecimen.class, 
 				"GetPathologyCaseSpecimensCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.imaging.pathology.PathologyCaseURN.class 
	  			},
				new Object[]{
			 		pathologyCaseUrn
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetPathologyCaseSpecimensCommand");
		
      
			java.util.List<gov.va.med.imaging.pathology.PathologyCaseSpecimen> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<java.lang.String> getPathologyTemplates(
 			gov.va.med.RoutingToken routingToken
 		 			, java.util.List<java.lang.String> apSections
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 java.lang.String.class, 
 				"GetPathologySiteTemplateCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, java.util.List.class 
	  			},
				new Object[]{
			 		routingToken,apSections
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetPathologySiteTemplateCommand");
		
      
			java.util.List<java.lang.String> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void updateReadingSite(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.pathology.PathologyReadingSite readingSite
 		 			, boolean delete
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Void> command = (Command<java.lang.Void>)getCommandFactory().createCommand(
	 				 java.lang.Void.class, 
	 				"PostPathologyReadingSiteCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.pathology.PathologyReadingSite.class, boolean.class 
		  			},
 					new Object[]{
				 		routingToken,readingSite,delete
		  			}
		  		);
		  		
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostPathologyReadingSiteCommand");
		
		      
		        getRouter().doSynchronously(command);
				return;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void updateAcquisitionSite(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.pathology.PathologyAcquisitionSite acquisitionSite
 		 			, boolean delete
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Void> command = (Command<java.lang.Void>)getCommandFactory().createCommand(
	 				 java.lang.Void.class, 
	 				"PostPathologyAcquisitionSiteCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.pathology.PathologyAcquisitionSite.class, boolean.class 
		  			},
 					new Object[]{
				 		routingToken,acquisitionSite,delete
		  			}
		  		);
		  		
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostPathologyAcquisitionSiteCommand");
		
		      
		        getRouter().doSynchronously(command);
				return;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void saveSiteTemplate(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String apSection
 		 			, java.lang.String xmlTemplate
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Void> command = (Command<java.lang.Void>)getCommandFactory().createCommand(
	 				 java.lang.Void.class, 
	 				"PostPathologySiteTemplateCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,apSection,xmlTemplate
		  			}
		  		);
		  		
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostPathologySiteTemplateCommand");
		
		      
		        getRouter().doSynchronously(command);
				return;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.pathology.PathologyCaseSupplementalReport> getPathologyCaseSupplementalReports(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.pathology.PathologyCaseSupplementalReport.class, 
 				"GetPathologyCaseSupplementalReportsCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.imaging.pathology.PathologyCaseURN.class 
	  			},
				new Object[]{
			 		pathologyCaseUrn
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetPathologyCaseSupplementalReportsCommand");
		
      
			java.util.List<gov.va.med.imaging.pathology.PathologyCaseSupplementalReport> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.String getPathologyCaseReport(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.String> command = (Command<java.lang.String>)getCommandFactory().createCommand(
	 				 java.lang.String.class, 
	 				"GetPathologyCaseReportCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.pathology.PathologyCaseURN.class 
		  			},
 					new Object[]{
				 		pathologyCaseUrn
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetPathologyCaseReportCommand");
		
      
        java.lang.String commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.pathology.PathologyCaseTemplate getPathologyCaseTemplateData(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, java.util.List<java.lang.String> fields
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.pathology.PathologyCaseTemplate> command = (Command<gov.va.med.imaging.pathology.PathologyCaseTemplate>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.pathology.PathologyCaseTemplate.class, 
	 				"GetPathologyCaseTemplateDataCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.pathology.PathologyCaseURN.class, java.util.List.class 
		  			},
 					new Object[]{
				 		pathologyCaseUrn,fields
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetPathologyCaseTemplateDataCommand");
		
      
        gov.va.med.imaging.pathology.PathologyCaseTemplate commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.pathology.enums.PathologyCaseReserveResult reservePathologyCase(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, boolean lock
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.pathology.enums.PathologyCaseReserveResult> command = (Command<gov.va.med.imaging.pathology.enums.PathologyCaseReserveResult>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.pathology.enums.PathologyCaseReserveResult.class, 
	 				"PostPathologyCaseReserveCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.pathology.PathologyCaseURN.class, boolean.class 
		  			},
 					new Object[]{
				 		pathologyCaseUrn,lock
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostPathologyCaseReserveCommand");
		
      
        gov.va.med.imaging.pathology.enums.PathologyCaseReserveResult commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.pathology.enums.PathologyElectronicSignatureNeed checkElectronicSignatureNeeded(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String apSection
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.pathology.enums.PathologyElectronicSignatureNeed> command = (Command<gov.va.med.imaging.pathology.enums.PathologyElectronicSignatureNeed>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.pathology.enums.PathologyElectronicSignatureNeed.class, 
	 				"GetPathologyElectronicSignatureNeedCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,apSection
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetPathologyElectronicSignatureNeedCommand");
		
      
        gov.va.med.imaging.pathology.enums.PathologyElectronicSignatureNeed commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.pathology.PathologyFieldValue> getPathologyFieldValues(
 			gov.va.med.RoutingToken routingToken
 		 			, gov.va.med.imaging.pathology.enums.PathologyField pathologyField
 		 			, java.lang.String searchParameter
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.pathology.PathologyFieldValue.class, 
 				"GetPathologyFieldValuesCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class, gov.va.med.imaging.pathology.enums.PathologyField.class, java.lang.String.class 
	  			},
				new Object[]{
			 		routingToken,pathologyField,searchParameter
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetPathologyFieldValuesCommand");
		
      
			java.util.List<gov.va.med.imaging.pathology.PathologyFieldValue> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void updatePathologyCaseConsultationStatus(
 			gov.va.med.imaging.pathology.PathologyCaseConsultationURN pathologyCaseConsultationUrn
 		 			, gov.va.med.imaging.pathology.enums.PathologyCaseConsultationUpdateStatus pathologyCaseConsultationUpdateStatus
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Void> command = (Command<java.lang.Void>)getCommandFactory().createCommand(
	 				 java.lang.Void.class, 
	 				"PostPathologyCaseConsultationStatusCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.pathology.PathologyCaseConsultationURN.class, gov.va.med.imaging.pathology.enums.PathologyCaseConsultationUpdateStatus.class 
		  			},
 					new Object[]{
				 		pathologyCaseConsultationUrn,pathologyCaseConsultationUpdateStatus
		  			}
		  		);
		  		
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostPathologyCaseConsultationStatusCommand");
		
		      
		        getRouter().doSynchronously(command);
				return;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.pathology.PathologySaveCaseReportResult savePathologyCaseReportFields(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, java.util.List<gov.va.med.imaging.pathology.PathologyCaseReportField> fields
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.pathology.PathologySaveCaseReportResult> command = (Command<gov.va.med.imaging.pathology.PathologySaveCaseReportResult>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.pathology.PathologySaveCaseReportResult.class, 
	 				"PostPathologyCaseReportFieldsCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.pathology.PathologyCaseURN.class, java.util.List.class 
		  			},
 					new Object[]{
				 		pathologyCaseUrn,fields
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostPathologyCaseReportFieldsCommand");
		
      
        gov.va.med.imaging.pathology.PathologySaveCaseReportResult commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void savePathologyCaseSupplementalReport(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, java.lang.String reportContents
 		 			, java.util.Date date
 		 			, boolean verified
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Void> command = (Command<java.lang.Void>)getCommandFactory().createCommand(
	 				 java.lang.Void.class, 
	 				"PostPathologyCaseSupplementalReportCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.pathology.PathologyCaseURN.class, java.lang.String.class, java.util.Date.class, boolean.class 
		  			},
 					new Object[]{
				 		pathologyCaseUrn,reportContents,date,verified
		  			}
		  		);
		  		
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostPathologyCaseSupplementalReportCommand");
		
		      
		        getRouter().doSynchronously(command);
				return;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.pathology.PathologySite> getPathologySites(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.pathology.PathologySite.class, 
 				"GetPathologySitesCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class 
	  			},
				new Object[]{
			 		routingToken
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetPathologySitesCommand");
		
      
			java.util.List<gov.va.med.imaging.pathology.PathologySite> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Integer getLockMinutes(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Integer> command = (Command<java.lang.Integer>)getCommandFactory().createCommand(
	 				 java.lang.Integer.class, 
	 				"GetPathologyLockMinutesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class 
		  			},
 					new Object[]{
				 		routingToken
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetPathologyLockMinutesCommand");
		
      
        java.lang.Integer commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void saveLockMinutes(
 			gov.va.med.RoutingToken routingToken
 		 			, int minutes
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Void> command = (Command<java.lang.Void>)getCommandFactory().createCommand(
	 				 java.lang.Void.class, 
	 				"PostPathologyLockMinutesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, int.class 
		  			},
 					new Object[]{
				 		routingToken,minutes
		  			}
		  		);
		  		
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostPathologyLockMinutesCommand");
		
		      
		        getRouter().doSynchronously(command);
				return;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void saveUserPreferences(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String userId
 		 			, java.lang.String label
 		 			, java.lang.String xml
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Void> command = (Command<java.lang.Void>)getCommandFactory().createCommand(
	 				 java.lang.Void.class, 
	 				"PostPathologyPreferencesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class, java.lang.String.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,userId,label,xml
		  			}
		  		);
		  		
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostPathologyPreferencesCommand");
		
		      
		        getRouter().doSynchronously(command);
				return;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void savePreferences(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String label
 		 			, java.lang.String xml
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Void> command = (Command<java.lang.Void>)getCommandFactory().createCommand(
	 				 java.lang.Void.class, 
	 				"PostPathologyPreferencesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,label,xml
		  			}
		  		);
		  		
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostPathologyPreferencesCommand");
		
		      
		        getRouter().doSynchronously(command);
				return;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.String getUserPreferences(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String userId
 		 			, java.lang.String label
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.String> command = (Command<java.lang.String>)getCommandFactory().createCommand(
	 				 java.lang.String.class, 
	 				"GetPathologyPreferencesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,userId,label
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetPathologyPreferencesCommand");
		
      
        java.lang.String commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.String getPreferences(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String label
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.String> command = (Command<java.lang.String>)getCommandFactory().createCommand(
	 				 java.lang.String.class, 
	 				"GetPathologyPreferencesCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,label
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetPathologyPreferencesCommand");
		
      
        java.lang.String commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.pathology.PathologySnomedCode> getPathologyCaseSnomedCodes(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.pathology.PathologySnomedCode.class, 
 				"GetPathologyCaseSnomedCodesCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.imaging.pathology.PathologyCaseURN.class 
	  			},
				new Object[]{
			 		pathologyCaseUrn
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetPathologyCaseSnomedCodesCommand");
		
      
			java.util.List<gov.va.med.imaging.pathology.PathologySnomedCode> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.String savePathologyCaseMorphologySnomedCode(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, java.lang.String tissueId
 		 			, java.lang.String morphologyId
 		 			, gov.va.med.imaging.pathology.PathologyFieldURN etiologyFieldUrn
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.String> command = (Command<java.lang.String>)getCommandFactory().createCommand(
	 				 java.lang.String.class, 
	 				"PostPathologyCaseMorphologySnomedCodeCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.pathology.PathologyCaseURN.class, java.lang.String.class, java.lang.String.class, gov.va.med.imaging.pathology.PathologyFieldURN.class 
		  			},
 					new Object[]{
				 		pathologyCaseUrn,tissueId,morphologyId,etiologyFieldUrn
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostPathologyCaseMorphologySnomedCodeCommand");
		
      
        java.lang.String commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.String savePathologyCaseSnomedCode(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, java.lang.String tissueId
 		 			, gov.va.med.imaging.pathology.PathologyFieldURN pathologyFieldUrn
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.String> command = (Command<java.lang.String>)getCommandFactory().createCommand(
	 				 java.lang.String.class, 
	 				"PostPathologyCaseSnomedCodeCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.pathology.PathologyCaseURN.class, java.lang.String.class, gov.va.med.imaging.pathology.PathologyFieldURN.class 
		  			},
 					new Object[]{
				 		pathologyCaseUrn,tissueId,pathologyFieldUrn
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostPathologyCaseSnomedCodeCommand");
		
      
        java.lang.String commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.pathology.PathologyCptCodeResult> savePathologyCaseCptCodes(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, gov.va.med.imaging.pathology.PathologyFieldURN locationFieldUrn
 		 			, java.util.List<java.lang.String> cptCodes
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.pathology.PathologyCptCodeResult.class, 
 				"PostPathologyCaseCptCodesCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.imaging.pathology.PathologyCaseURN.class, gov.va.med.imaging.pathology.PathologyFieldURN.class, java.util.List.class 
	  			},
				new Object[]{
			 		pathologyCaseUrn,locationFieldUrn,cptCodes
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("PostPathologyCaseCptCodesCommand");
		
      
			java.util.List<gov.va.med.imaging.pathology.PathologyCptCodeResult> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.pathology.PathologyCptCode> getPathologyCaseCptCodes(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.pathology.PathologyCptCode.class, 
 				"GetPathologyCaseCptCodesCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.imaging.pathology.PathologyCaseURN.class 
	  			},
				new Object[]{
			 		pathologyCaseUrn
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetPathologyCaseCptCodesCommand");
		
      
			java.util.List<gov.va.med.imaging.pathology.PathologyCptCode> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<java.lang.String> getPathologyKeys(
 			gov.va.med.RoutingToken routingToken
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 java.lang.String.class, 
 				"GetPathologyUserKeysCommand",
 				"",
				new Class<?>[]{
				 	gov.va.med.RoutingToken.class 
	  			},
				new Object[]{
			 		routingToken
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetPathologyUserKeysCommand");
		
      
			java.util.List<java.lang.String> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousCollectionMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.util.List<gov.va.med.imaging.pathology.PathologyCase> getSpecificCases(
 			java.util.List<gov.va.med.imaging.pathology.PathologyCaseURN> cases
 		 ) 
 		throws MethodException, ConnectionException
 		{
 			Command<java.util.List> command = getCommandFactory().createCollectionCommand(
 				 java.util.List.class, 
 				 gov.va.med.imaging.pathology.PathologyCase.class, 
 				"GetPathologySpecificCasesCommand",
 				"",
				new Class<?>[]{
				 	java.util.List.class 
	  			},
				new Object[]{
			 		cases
	  			}
	  		);	  		  		
  		
			gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
			  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
			//transactionContext.setCommandClassName("GetPathologySpecificCasesCommand");
		
      
			java.util.List<gov.va.med.imaging.pathology.PathologyCase> commandResult = getRouter().doSynchronously(command);
			return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.Boolean checkPendingConsultationStatus(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String stationNumber
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Boolean> command = (Command<java.lang.Boolean>)getCommandFactory().createCommand(
	 				 java.lang.Boolean.class, 
	 				"GetPathologyPendingConsultationsCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		routingToken,stationNumber
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetPathologyPendingConsultationsCommand");
		
      
        java.lang.Boolean commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.String savePathologyCaseTissues(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, gov.va.med.imaging.pathology.PathologyFieldURN pathologyTissueUrn
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.String> command = (Command<java.lang.String>)getCommandFactory().createCommand(
	 				 java.lang.String.class, 
	 				"PostPathologyCaseTissueCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.pathology.PathologyCaseURN.class, gov.va.med.imaging.pathology.PathologyFieldURN.class 
		  			},
 					new Object[]{
				 		pathologyCaseUrn,pathologyTissueUrn
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostPathologyCaseTissueCommand");
		
      
        java.lang.String commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public gov.va.med.imaging.pathology.PathologyCaseURN copyPathologyCase(
 			gov.va.med.RoutingToken globalRoutingToken
 		 			, gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<gov.va.med.imaging.pathology.PathologyCaseURN> command = (Command<gov.va.med.imaging.pathology.PathologyCaseURN>)getCommandFactory().createCommand(
	 				 gov.va.med.imaging.pathology.PathologyCaseURN.class, 
	 				"PostPathologyCopyCaseCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.RoutingToken.class, gov.va.med.imaging.pathology.PathologyCaseURN.class 
		  			},
 					new Object[]{
				 		globalRoutingToken,pathologyCaseUrn
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostPathologyCopyCaseCommand");
		
      
        gov.va.med.imaging.pathology.PathologyCaseURN commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void deleteSnomedEtiologyCode(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, java.lang.String tissueId
 		 			, java.lang.String snomedId
 		 			, java.lang.String etiologyId
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Void> command = (Command<java.lang.Void>)getCommandFactory().createCommand(
	 				 java.lang.Void.class, 
	 				"DeletePathologyCaseEtiologySnomedCodeCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.pathology.PathologyCaseURN.class, java.lang.String.class, java.lang.String.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		pathologyCaseUrn,tissueId,snomedId,etiologyId
		  			}
		  		);
		  		
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("DeletePathologyCaseEtiologySnomedCodeCommand");
		
		      
		        getRouter().doSynchronously(command);
				return;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void deleteSnomedCode(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, java.lang.String tissueId
 		 			, java.lang.String snomedId
 		 			, gov.va.med.imaging.pathology.enums.PathologyField snomedField
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Void> command = (Command<java.lang.Void>)getCommandFactory().createCommand(
	 				 java.lang.Void.class, 
	 				"DeletePathologyCaseSnomedCodeCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.pathology.PathologyCaseURN.class, java.lang.String.class, java.lang.String.class, gov.va.med.imaging.pathology.enums.PathologyField.class 
		  			},
 					new Object[]{
				 		pathologyCaseUrn,tissueId,snomedId,snomedField
		  			}
		  		);
		  		
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("DeletePathologyCaseSnomedCodeCommand");
		
		      
		        getRouter().doSynchronously(command);
				return;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void deleteTissue(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, java.lang.String tissueId
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Void> command = (Command<java.lang.Void>)getCommandFactory().createCommand(
	 				 java.lang.Void.class, 
	 				"DeletePathologyCaseTissueCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.pathology.PathologyCaseURN.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		pathologyCaseUrn,tissueId
		  			}
		  		);
		  		
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("DeletePathologyCaseTissueCommand");
		
		      
		        getRouter().doSynchronously(command);
				return;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public void saveCaseNote(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, java.lang.String note
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.Void> command = (Command<java.lang.Void>)getCommandFactory().createCommand(
	 				 java.lang.Void.class, 
	 				"PostPathologyCaseNoteCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.pathology.PathologyCaseURN.class, java.lang.String.class 
		  			},
 					new Object[]{
				 		pathologyCaseUrn,note
		  			}
		  		);
		  		
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("PostPathologyCaseNoteCommand");
		
		      
		        getRouter().doSynchronously(command);
				return;
 		}

 		 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FacadeRouterSynchronousMethodImpl.ftl
 	*/
 	@SuppressWarnings("unchecked")
 	public java.lang.String getCaseNote(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 ) 
 		throws MethodException, ConnectionException
 		{
	 			Command<java.lang.String> command = (Command<java.lang.String>)getCommandFactory().createCommand(
	 				 java.lang.String.class, 
	 				"GetPathologyCaseNoteCommand",
	 				"",
 					new Class<?>[]{
				 		 gov.va.med.imaging.pathology.PathologyCaseURN.class 
		  			},
 					new Object[]{
				 		pathologyCaseUrn
		  			}
		  		);
				gov.va.med.imaging.transactioncontext.TransactionContext transactionContext =
				  gov.va.med.imaging.transactioncontext.TransactionContextFactory.get();
				//transactionContext.setCommandClassName("GetPathologyCaseNoteCommand");
		
      
        java.lang.String commandResult = getRouter().doSynchronously(command);
				return commandResult;
 		}

 }