/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: Jun 12,2015
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author       DNS
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone DNS
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
package gov.va.med.imaging.federationdatasource.pathology.proxy.v6;


import org.apache.log4j.Logger;

import java.io.IOException;

import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;
import gov.va.med.imaging.transactioncontext.TransactionContext;
import gov.va.med.imaging.datasource.exceptions.*;
import gov.va.med.imaging.artifactsource.ResolvedArtifactSource;
import gov.va.med.imaging.exchange.business.ResolvedSite;
import gov.va.med.imaging.core.interfaces.exceptions.SecurityCredentialsExpiredException;
import gov.va.med.imaging.core.interfaces.exceptions.SecurityException;
import gov.va.med.imaging.federation.rest.proxy.*;
import gov.va.med.imaging.rest.types.*;
import gov.va.med.imaging.proxy.services.ProxyServices;
import gov.va.med.imaging.federationdatasource.configuration.FederationConfiguration;

import javax.ws.rs.core.MediaType;

import java.util.Map;
import java.util.HashMap;



@SuppressWarnings("unused") 
public class FederationRestPathologyProxyV6Impl
extends FederationRestPathologyProxyV6
{

	private final static Logger logger = Logger.getLogger(FederationRestPathologyProxyV6Impl.class);
	
	public FederationRestPathologyProxyV6Impl(ProxyServices proxyServices, 
			FederationConfiguration federationConfiguration)
	{
		super(proxyServices, federationConfiguration);
	}
	
	
 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyGetMethod.tfl
 	*/
 	@Override
 	public java.util.List<gov.va.med.imaging.pathology.PathologyCase> getCases(
 			gov.va.med.RoutingToken globalRoutingToken
 		 			, boolean released
 		 			, int days
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("getCases, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + globalRoutingToken.toRoutingTokenString() + ", " + "released='" + released + "'" + ", " + "days='" + days + "'" + ") + '.");
		setDataSourceMethodAndVersion("getCases");
		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{routingToken}", globalRoutingToken.toRoutingTokenString());
		urlParameterKeyValues.put("{released}", String.valueOf(released));
		urlParameterKeyValues.put("{days}", String.valueOf(days));
			
		String url = getWebResourceUrl("cases/{routingToken}/{released}/{days}", urlParameterKeyValues ); 				
		FederationRestGetClient getClient = new FederationRestGetClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		gov.va.med.imaging.federation.pathology.rest.types.PathologyFederationCaseType[]	federationResult = getClient.executeRequest(gov.va.med.imaging.federation.pathology.rest.types.PathologyFederationCaseType[].class);
		getLogger().info("getCases, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
		java.util.List<gov.va.med.imaging.pathology.PathologyCase> result = gov.va.med.imaging.federation.pathology.rest.translator.PathologyFederationRestTranslator.translate(federationResult);
		//getLogger().info("getCases, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : result.size()) + "] business objects.");
		getLogger().info("getCases, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : "not null") + "] business objects.");
		return result;
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyGetMethod.tfl
 	*/
 	@Override
 	public java.util.List<gov.va.med.imaging.pathology.PathologyCase> getCases(
 			gov.va.med.RoutingToken globalRoutingToken
 		 			, boolean released
 		 			, int days
 		 			, java.lang.String requestingSiteId
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("getCases, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + globalRoutingToken.toRoutingTokenString() + ", " + "released='" + released + "'" + ", " + "days='" + days + "'" + ", " + "requestingSiteId='" + requestingSiteId + "'" + ") + '.");
		setDataSourceMethodAndVersion("getCases");
		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{routingToken}", globalRoutingToken.toRoutingTokenString());
		urlParameterKeyValues.put("{released}", String.valueOf(released));
		urlParameterKeyValues.put("{days}", String.valueOf(days));
		urlParameterKeyValues.put("{requestingSiteId}", requestingSiteId);
			
		String url = getWebResourceUrl("cases/{routingToken}/{released}/{days}/{requestingSiteId}", urlParameterKeyValues ); 				
		FederationRestGetClient getClient = new FederationRestGetClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		gov.va.med.imaging.federation.pathology.rest.types.PathologyFederationCaseType[]	federationResult = getClient.executeRequest(gov.va.med.imaging.federation.pathology.rest.types.PathologyFederationCaseType[].class);
		getLogger().info("getCases, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
		java.util.List<gov.va.med.imaging.pathology.PathologyCase> result = gov.va.med.imaging.federation.pathology.rest.translator.PathologyFederationRestTranslator.translate(federationResult);
		//getLogger().info("getCases, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : result.size()) + "] business objects.");
		getLogger().info("getCases, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : "not null") + "] business objects.");
		return result;
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyGetMethod.tfl
 	*/
 	@Override
 	public java.util.List<gov.va.med.imaging.pathology.PathologyCase> getPatientCases(
 			gov.va.med.RoutingToken globalRoutingToken
 		 			, gov.va.med.PatientIdentifier patientIdentifier
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("getPatientCases, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + globalRoutingToken.toRoutingTokenString() + ", " + "patientIcn='" + patientIdentifier.getValue() + "'" + ") + '.");
		setDataSourceMethodAndVersion("getPatientCases");
		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{routingToken}", globalRoutingToken.toRoutingTokenString());
		urlParameterKeyValues.put("{patientIcn}", patientIdentifier.getValue());
			
		String url = getWebResourceUrl("cases/patient/{routingToken}/{patientIcn}", urlParameterKeyValues ); 				
		FederationRestGetClient getClient = new FederationRestGetClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		gov.va.med.imaging.federation.pathology.rest.types.PathologyFederationCaseType[]	federationResult = getClient.executeRequest(gov.va.med.imaging.federation.pathology.rest.types.PathologyFederationCaseType[].class);
		getLogger().info("getPatientCases, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
		java.util.List<gov.va.med.imaging.pathology.PathologyCase> result = gov.va.med.imaging.federation.pathology.rest.translator.PathologyFederationRestTranslator.translate(federationResult);
		//getLogger().info("getPatientCases, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : result.size()) + "] business objects.");
		getLogger().info("getPatientCases, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : "not null") + "] business objects.");
		return result;
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyGetMethod.tfl
 	*/
 	@Override
 	public java.util.List<gov.va.med.imaging.pathology.PathologyAcquisitionSite> getAcquisitionSites(
 			gov.va.med.RoutingToken globalRoutingToken
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("getAcquisitionSites, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + globalRoutingToken.toRoutingTokenString() + ") + '.");
		setDataSourceMethodAndVersion("getAcquisitionSites");
		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{routingToken}", globalRoutingToken.toRoutingTokenString());
			
		String url = getWebResourceUrl("sites/acqusition/{routingToken}", urlParameterKeyValues ); 				
		FederationRestGetClient getClient = new FederationRestGetClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		gov.va.med.imaging.federation.pathology.rest.types.PathologyFederationAcquisitionSiteType[]	federationResult = getClient.executeRequest(gov.va.med.imaging.federation.pathology.rest.types.PathologyFederationAcquisitionSiteType[].class);
		getLogger().info("getAcquisitionSites, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
		java.util.List<gov.va.med.imaging.pathology.PathologyAcquisitionSite> result = gov.va.med.imaging.federation.pathology.rest.translator.PathologyFederationRestTranslator.translate(federationResult);
		//getLogger().info("getAcquisitionSites, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : result.size()) + "] business objects.");
		getLogger().info("getAcquisitionSites, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : "not null") + "] business objects.");
		return result;
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyGetMethod.tfl
 	*/
 	@Override
 	public java.util.List<gov.va.med.imaging.pathology.PathologyReadingSite> getReadingSites(
 			gov.va.med.RoutingToken globalRoutingToken
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("getReadingSites, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + globalRoutingToken.toRoutingTokenString() + ") + '.");
		setDataSourceMethodAndVersion("getReadingSites");
		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{routingToken}", globalRoutingToken.toRoutingTokenString());
			
		String url = getWebResourceUrl("sites/reading/{routingToken}", urlParameterKeyValues ); 				
		FederationRestGetClient getClient = new FederationRestGetClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		gov.va.med.imaging.federation.pathology.rest.types.PathologyFederationReadingSiteType[]	federationResult = getClient.executeRequest(gov.va.med.imaging.federation.pathology.rest.types.PathologyFederationReadingSiteType[].class);
		getLogger().info("getReadingSites, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
		java.util.List<gov.va.med.imaging.pathology.PathologyReadingSite> result = gov.va.med.imaging.federation.pathology.rest.translator.PathologyFederationRestTranslator.translate(federationResult);
		//getLogger().info("getReadingSites, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : result.size()) + "] business objects.");
		getLogger().info("getReadingSites, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : "not null") + "] business objects.");
		return result;
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyPostMethod.tfl
 	*/
 	@Override
 	public void updateReadingSite(
 			gov.va.med.RoutingToken globalRoutingToken
 		 			, gov.va.med.imaging.pathology.PathologyReadingSite readingSite
 		 			, boolean delete
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("updateReadingSite, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + globalRoutingToken.toRoutingTokenString() + ", " + "delete='" + delete + "'" + ") + '.");
		setDataSourceMethodAndVersion("updateReadingSite");
		
		Object site = gov.va.med.imaging.federation.pathology.rest.translator.PathologyFederationRestTranslator.translate(readingSite);		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{routingToken}", globalRoutingToken.toRoutingTokenString());
		urlParameterKeyValues.put("{delete}", String.valueOf(delete));
			
		String url = getWebResourceUrl("sites/reading/{routingToken}/{delete}", urlParameterKeyValues ); 				
		FederationRestPostClient postClient = new FederationRestPostClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		RestBooleanReturnType	federationResult = postClient.executeRequest(RestBooleanReturnType.class, site);
		getLogger().info("updateReadingSite, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
			// do nothing
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyPostMethod.tfl
 	*/
 	@Override
 	public void updateAcquisitionSite(
 			gov.va.med.RoutingToken globalRoutingToken
 		 			, gov.va.med.imaging.pathology.PathologyAcquisitionSite acquisitionSite
 		 			, boolean delete
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("updateAcquisitionSite, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + globalRoutingToken.toRoutingTokenString() + ", " + "delete='" + delete + "'" + ") + '.");
		setDataSourceMethodAndVersion("updateAcquisitionSite");
		
		Object site = gov.va.med.imaging.federation.pathology.rest.translator.PathologyFederationRestTranslator.translate(acquisitionSite);		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{routingToken}", globalRoutingToken.toRoutingTokenString());
		urlParameterKeyValues.put("{delete}", String.valueOf(delete));
			
		String url = getWebResourceUrl("sites/acquisition/{routingToken}/{delete}", urlParameterKeyValues ); 				
		FederationRestPostClient postClient = new FederationRestPostClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		RestBooleanReturnType	federationResult = postClient.executeRequest(RestBooleanReturnType.class, site);
		getLogger().info("updateAcquisitionSite, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
			// do nothing
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyPostMethod.tfl
 	*/
 	@Override
 	public void saveUserPreferences(
 			gov.va.med.RoutingToken globalRoutingToken
 		 			, java.lang.String userId
 		 			, java.lang.String label
 		 			, java.lang.String xml
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("saveUserPreferences, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + userId + ", " + label + ") + '.");
		setDataSourceMethodAndVersion("saveUserPreferences");
		
		Object xmlString = RestCoreTranslator.translate(xml);		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{routingToken}", globalRoutingToken.toRoutingTokenString());
		urlParameterKeyValues.put("{userId}", userId);
		urlParameterKeyValues.put("{label}", label);
			
		String url = getWebResourceUrl("preferences/{routingToken}/{label}/{userId}", urlParameterKeyValues ); 				
		FederationRestPostClient postClient = new FederationRestPostClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		RestBooleanReturnType	federationResult = postClient.executeRequest(RestBooleanReturnType.class, xmlString);
		getLogger().info("saveUserPreferences, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
			// do nothing
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyPostMethod.tfl
 	*/
 	@Override
 	public void savePreferences(
 			gov.va.med.RoutingToken globalRoutingToken
 		 			, java.lang.String label
 		 			, java.lang.String xml
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("savePreferences, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + label + ") + '.");
		setDataSourceMethodAndVersion("savePreferences");
		
		Object xmlString = RestCoreTranslator.translate(xml);		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{routingToken}", globalRoutingToken.toRoutingTokenString());
		urlParameterKeyValues.put("{label}", label);
			
		String url = getWebResourceUrl("preferences/{routingToken}/{label}", urlParameterKeyValues ); 				
		FederationRestPostClient postClient = new FederationRestPostClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		RestBooleanReturnType	federationResult = postClient.executeRequest(RestBooleanReturnType.class, xmlString);
		getLogger().info("savePreferences, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
			// do nothing
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyGetMethod.tfl
 	*/
 	@Override
 	public java.lang.String getUserPreferences(
 			gov.va.med.RoutingToken globalRoutingToken
 		 			, java.lang.String userId
 		 			, java.lang.String label
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("getUserPreferences, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + userId + ", " + label + ") + '.");
		setDataSourceMethodAndVersion("getUserPreferences");
		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{routingToken}", globalRoutingToken.toRoutingTokenString());
		urlParameterKeyValues.put("{userId}", userId);
		urlParameterKeyValues.put("{label}", label);
			
		String url = getWebResourceUrl("preferences/{routingToken}/{label}/{userId}", urlParameterKeyValues ); 				
		FederationRestGetClient getClient = new FederationRestGetClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		RestStringType	federationResult = getClient.executeRequest(RestStringType.class);
		getLogger().info("getUserPreferences, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
		java.lang.String result = RestCoreTranslator.translate(federationResult);
		//getLogger().info("getUserPreferences, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : result.size()) + "] business objects.");
		getLogger().info("getUserPreferences, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : "not null") + "] business objects.");
		return result;
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyGetMethod.tfl
 	*/
 	@Override
 	public java.lang.String getPreferences(
 			gov.va.med.RoutingToken globalRoutingToken
 		 			, java.lang.String label
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("getPreferences, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + label + ") + '.");
		setDataSourceMethodAndVersion("getPreferences");
		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{routingToken}", globalRoutingToken.toRoutingTokenString());
		urlParameterKeyValues.put("{label}", label);
			
		String url = getWebResourceUrl("preferences/{routingToken}/{label}", urlParameterKeyValues ); 				
		FederationRestGetClient getClient = new FederationRestGetClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		RestStringType	federationResult = getClient.executeRequest(RestStringType.class);
		getLogger().info("getPreferences, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
		java.lang.String result = RestCoreTranslator.translate(federationResult);
		//getLogger().info("getPreferences, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : result.size()) + "] business objects.");
		getLogger().info("getPreferences, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : "not null") + "] business objects.");
		return result;
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyGetMethod.tfl
 	*/
 	@Override
 	public java.util.List<gov.va.med.imaging.pathology.PathologySnomedCode> getCaseSnomedCodes(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("getCaseSnomedCodes, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + "caseId='" + pathologyCaseUrn.toString() + "'" + ") + '.");
		setDataSourceMethodAndVersion("getCaseSnomedCodes");
		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{caseId}", pathologyCaseUrn.toString());
			
		String url = getWebResourceUrl("snomed/{caseId}", urlParameterKeyValues ); 				
		FederationRestGetClient getClient = new FederationRestGetClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		gov.va.med.imaging.federation.pathology.rest.types.PathologyFederationSnomedCodeType[]	federationResult = getClient.executeRequest(gov.va.med.imaging.federation.pathology.rest.types.PathologyFederationSnomedCodeType[].class);
		getLogger().info("getCaseSnomedCodes, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
		java.util.List<gov.va.med.imaging.pathology.PathologySnomedCode> result = gov.va.med.imaging.federation.pathology.rest.translator.PathologyFederationRestTranslator.translate(federationResult);
		//getLogger().info("getCaseSnomedCodes, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : result.size()) + "] business objects.");
		getLogger().info("getCaseSnomedCodes, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : "not null") + "] business objects.");
		return result;
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyPostMethod.tfl
 	*/
 	@Override
 	public java.lang.String saveCaseSnomedCode(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, java.lang.String tissueId
 		 			, gov.va.med.imaging.pathology.PathologyFieldURN pathologyFieldUrn
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("saveCaseSnomedCode, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + "caseId='" + pathologyCaseUrn.toString() + "'" + ", " + "tissueId='" + tissueId + "'" + ", " + "fieldId='" + pathologyFieldUrn.toString() + "'" + ") + '.");
		setDataSourceMethodAndVersion("saveCaseSnomedCode");
		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{caseId}", pathologyCaseUrn.toString());
		urlParameterKeyValues.put("{tissueId}", tissueId);
		urlParameterKeyValues.put("{fieldId}", pathologyFieldUrn.toString());
			
		String url = getWebResourceUrl("snomed/{caseId}/{tissueId}/{fieldId}", urlParameterKeyValues ); 				
		FederationRestPostClient postClient = new FederationRestPostClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		RestStringType	federationResult = postClient.executeRequest(RestStringType.class, new RestNullPostType());
		getLogger().info("saveCaseSnomedCode, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
		java.lang.String result = RestCoreTranslator.translate(federationResult);
		//getLogger().info("saveCaseSnomedCode, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : result.size()) + "] business objects.");
		getLogger().info("saveCaseSnomedCode, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : "not null") + "] business objects.");
		return result;
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyPostMethod.tfl
 	*/
 	@Override
 	public java.lang.String saveCaseSnomedCodeForMorphology(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, java.lang.String tissueId
 		 			, java.lang.String morphologyId
 		 			, gov.va.med.imaging.pathology.PathologyFieldURN etiologyFieldUrn
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("saveCaseSnomedCodeForMorphology, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + "caseId='" + pathologyCaseUrn.toString() + "'" + ", " + "tissue='" + tissueId + "'" + ", " + "morphology='" + morphologyId + "'" + ", " + "etiology='" + etiologyFieldUrn.toString() + "'" + ") + '.");
		setDataSourceMethodAndVersion("saveCaseSnomedCodeForMorphology");
		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{caseId}", pathologyCaseUrn.toString());
		urlParameterKeyValues.put("{tissueId}", tissueId);
		urlParameterKeyValues.put("{morphologyId}", morphologyId);
		urlParameterKeyValues.put("{etiologyFieldId}", etiologyFieldUrn.toString());
			
		String url = getWebResourceUrl("snomed/morphology/{caseId}/{tissueId}/{morphologyId}/{etiologyFieldId}", urlParameterKeyValues ); 				
		FederationRestPostClient postClient = new FederationRestPostClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		RestStringType	federationResult = postClient.executeRequest(RestStringType.class, new RestNullPostType());
		getLogger().info("saveCaseSnomedCodeForMorphology, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
		java.lang.String result = RestCoreTranslator.translate(federationResult);
		//getLogger().info("saveCaseSnomedCodeForMorphology, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : result.size()) + "] business objects.");
		getLogger().info("saveCaseSnomedCodeForMorphology, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : "not null") + "] business objects.");
		return result;
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyPostMethod.tfl
 	*/
 	@Override
 	public java.util.List<gov.va.med.imaging.pathology.PathologyCptCodeResult> saveCaseCptCodes(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, gov.va.med.imaging.pathology.PathologyFieldURN locationFieldUrn
 		 			, java.util.List<java.lang.String> cptCodes
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("saveCaseCptCodes, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + "caseId='" + pathologyCaseUrn.toString() + "'" + ", " + "locationId='" + locationFieldUrn.toString() + "'" + ") + '.");
		setDataSourceMethodAndVersion("saveCaseCptCodes");
		
		Object cptArray = RestCoreTranslator.translateStrings(cptCodes);		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{caseId}", pathologyCaseUrn.toString());
		urlParameterKeyValues.put("{locationId}", locationFieldUrn.toString());
			
		String url = getWebResourceUrl("cpt/{caseId}/{locationId}", urlParameterKeyValues ); 				
		FederationRestPostClient postClient = new FederationRestPostClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		gov.va.med.imaging.federation.pathology.rest.types.PathologyFederationCptCodeResultType[]	federationResult = postClient.executeRequest(gov.va.med.imaging.federation.pathology.rest.types.PathologyFederationCptCodeResultType[].class, cptArray);
		getLogger().info("saveCaseCptCodes, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
		java.util.List<gov.va.med.imaging.pathology.PathologyCptCodeResult> result = gov.va.med.imaging.federation.pathology.rest.translator.PathologyFederationRestTranslator.translate(federationResult);
		//getLogger().info("saveCaseCptCodes, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : result.size()) + "] business objects.");
		getLogger().info("saveCaseCptCodes, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : "not null") + "] business objects.");
		return result;
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyGetMethod.tfl
 	*/
 	@Override
 	public java.lang.String getPathologyCaseReport(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("getPathologyCaseReport, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + "caseId='" + pathologyCaseUrn.toString() + "'" + ") + '.");
		setDataSourceMethodAndVersion("getPathologyCaseReport");
		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{caseId}", pathologyCaseUrn.toString());
			
		String url = getWebResourceUrl("case/report/{caseId}", urlParameterKeyValues ); 				
		FederationRestGetClient getClient = new FederationRestGetClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		RestStringType	federationResult = getClient.executeRequest(RestStringType.class);
		getLogger().info("getPathologyCaseReport, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
		java.lang.String result = RestCoreTranslator.translate(federationResult);
		//getLogger().info("getPathologyCaseReport, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : result.size()) + "] business objects.");
		getLogger().info("getPathologyCaseReport, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : "not null") + "] business objects.");
		return result;
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyGetMethod.tfl
 	*/
 	@Override
 	public java.util.List<gov.va.med.imaging.pathology.PathologyCaseSupplementalReport> getCaseSupplementalReports(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("getCaseSupplementalReports, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + "caseId='" + pathologyCaseUrn.toString() + "'" + ") + '.");
		setDataSourceMethodAndVersion("getCaseSupplementalReports");
		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{caseId}", pathologyCaseUrn.toString());
			
		String url = getWebResourceUrl("case/supplementalreport/{caseId}", urlParameterKeyValues ); 				
		FederationRestGetClient getClient = new FederationRestGetClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		gov.va.med.imaging.federation.pathology.rest.types.PathologyFederationCaseSupplementalReportType[]	federationResult = getClient.executeRequest(gov.va.med.imaging.federation.pathology.rest.types.PathologyFederationCaseSupplementalReportType[].class);
		getLogger().info("getCaseSupplementalReports, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
		java.util.List<gov.va.med.imaging.pathology.PathologyCaseSupplementalReport> result = gov.va.med.imaging.federation.pathology.rest.translator.PathologyFederationRestTranslator.translate(federationResult);
		//getLogger().info("getCaseSupplementalReports, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : result.size()) + "] business objects.");
		getLogger().info("getCaseSupplementalReports, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : "not null") + "] business objects.");
		return result;
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyPostMethod.tfl
 	*/
 	@Override
 	public gov.va.med.imaging.pathology.PathologyCaseTemplate getCaseTemplateData(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, java.util.List<java.lang.String> fields
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("getCaseTemplateData, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + "caseId='" + pathologyCaseUrn.toString() + "'" + ") + '.");
		setDataSourceMethodAndVersion("getCaseTemplateData");
		
		Object fieldArray = RestCoreTranslator.translateStrings(fields);		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{caseId}", pathologyCaseUrn.toString());
			
		String url = getWebResourceUrl("case/template/{caseId}", urlParameterKeyValues ); 				
		FederationRestPostClient postClient = new FederationRestPostClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		gov.va.med.imaging.federation.pathology.rest.types.PathologyFederationCaseTemplateType	federationResult = postClient.executeRequest(gov.va.med.imaging.federation.pathology.rest.types.PathologyFederationCaseTemplateType.class, fieldArray);
		getLogger().info("getCaseTemplateData, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
		gov.va.med.imaging.pathology.PathologyCaseTemplate result = gov.va.med.imaging.federation.pathology.rest.translator.PathologyFederationRestTranslator.translate(federationResult);
		//getLogger().info("getCaseTemplateData, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : result.size()) + "] business objects.");
		getLogger().info("getCaseTemplateData, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : "not null") + "] business objects.");
		return result;
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyPostMethod.tfl
 	*/
 	@Override
 	public gov.va.med.imaging.pathology.enums.PathologyCaseReserveResult reserveCase(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, boolean lock
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("reserveCase, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + "caseId='" + pathologyCaseUrn.toString() + "'" + ", " + lock + ") + '.");
		setDataSourceMethodAndVersion("reserveCase");
		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{caseId}", pathologyCaseUrn.toString());
		urlParameterKeyValues.put("{lock}", String.valueOf(lock));
			
		String url = getWebResourceUrl("case/reserve/{caseId}/{lock}", urlParameterKeyValues ); 				
		FederationRestPostClient postClient = new FederationRestPostClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		gov.va.med.imaging.federation.pathology.rest.types.PathologyFederationCaseReserveResultType	federationResult = postClient.executeRequest(gov.va.med.imaging.federation.pathology.rest.types.PathologyFederationCaseReserveResultType.class, new RestNullPostType());
		getLogger().info("reserveCase, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
		gov.va.med.imaging.pathology.enums.PathologyCaseReserveResult result = gov.va.med.imaging.federation.pathology.rest.translator.PathologyFederationRestTranslator.translate(federationResult);
		//getLogger().info("reserveCase, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : result.size()) + "] business objects.");
		getLogger().info("reserveCase, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : "not null") + "] business objects.");
		return result;
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyGetMethod.tfl
 	*/
 	@Override
 	public gov.va.med.imaging.pathology.enums.PathologyElectronicSignatureNeed checkElectronicSignatureNeeded(
 			gov.va.med.RoutingToken routingToken
 		 			, java.lang.String apSection
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("checkElectronicSignatureNeeded, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + routingToken + ", " + apSection + ") + '.");
		setDataSourceMethodAndVersion("checkElectronicSignatureNeeded");
		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{routingToken}", routingToken.toRoutingTokenString());
		urlParameterKeyValues.put("{apSection}", apSection);
			
		String url = getWebResourceUrl("electronicSignature/{routingToken}/{apSection}", urlParameterKeyValues ); 				
		FederationRestGetClient getClient = new FederationRestGetClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		gov.va.med.imaging.federation.pathology.rest.types.PathologyFederationElectronicSignatureNeedType	federationResult = getClient.executeRequest(gov.va.med.imaging.federation.pathology.rest.types.PathologyFederationElectronicSignatureNeedType.class);
		getLogger().info("checkElectronicSignatureNeeded, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
		gov.va.med.imaging.pathology.enums.PathologyElectronicSignatureNeed result = gov.va.med.imaging.federation.pathology.rest.translator.PathologyFederationRestTranslator.translate(federationResult);
		//getLogger().info("checkElectronicSignatureNeeded, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : result.size()) + "] business objects.");
		getLogger().info("checkElectronicSignatureNeeded, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : "not null") + "] business objects.");
		return result;
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyPostMethod.tfl
 	*/
 	@Override
 	public java.util.List<gov.va.med.imaging.pathology.PathologyFieldValue> getPathologyFields(
 			gov.va.med.RoutingToken globalRoutingToken
 		 			, gov.va.med.imaging.pathology.enums.PathologyField pathologyField
 		 			, java.lang.String searchParameter
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("getPathologyFields, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + globalRoutingToken + ", " + pathologyField + ") + '.");
		setDataSourceMethodAndVersion("getPathologyFields");
		
		Object field = gov.va.med.imaging.federation.pathology.rest.translator.PathologyFederationRestTranslator.translate(pathologyField);		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{routingToken}", globalRoutingToken.toRoutingTokenString());
		urlParameterKeyValues.put("{field}", field.toString());
		urlParameterKeyValues.put("{searchParam}", searchParameter);
			
		String url = getWebResourceUrl("fields/{routingToken}/{field}", urlParameterKeyValues ); 				
		FederationRestPostClient postClient = new FederationRestPostClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		gov.va.med.imaging.federation.pathology.rest.types.PathologyFederationFieldValueType[]	federationResult = postClient.executeRequest(gov.va.med.imaging.federation.pathology.rest.types.PathologyFederationFieldValueType[].class, searchParameter);
		getLogger().info("getPathologyFields, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
		java.util.List<gov.va.med.imaging.pathology.PathologyFieldValue> result = gov.va.med.imaging.federation.pathology.rest.translator.PathologyFederationRestTranslator.translate(federationResult);
		//getLogger().info("getPathologyFields, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : result.size()) + "] business objects.");
		getLogger().info("getPathologyFields, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : "not null") + "] business objects.");
		return result;
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyGetMethod.tfl
 	*/
 	@Override
 	public void updateConsultationStatus(
 			gov.va.med.imaging.pathology.PathologyCaseConsultationURN pathologyCaseConsultationUrn
 		 			, gov.va.med.imaging.pathology.enums.PathologyCaseConsultationUpdateStatus consultationUpdateStatus
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("updateConsultationStatus, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + "consultation='" + pathologyCaseConsultationUrn.toString() + "'" + ", " + "status='" + consultationUpdateStatus + "'" + ") + '.");
		setDataSourceMethodAndVersion("updateConsultationStatus");
		
		Object status = gov.va.med.imaging.federation.pathology.rest.translator.PathologyFederationRestTranslator.translate(consultationUpdateStatus);		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{consultationId}", pathologyCaseConsultationUrn.toString());
		urlParameterKeyValues.put("{status}", String.valueOf(status));
			
		String url = getWebResourceUrl("consultation/{consultationId}/{status}", urlParameterKeyValues ); 				
		FederationRestGetClient getClient = new FederationRestGetClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		RestBooleanReturnType	federationResult = getClient.executeRequest(RestBooleanReturnType.class);
		getLogger().info("updateConsultationStatus, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
			// do nothing
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyPostMethod.tfl
 	*/
 	@Override
 	public gov.va.med.imaging.pathology.PathologySaveCaseReportResult saveCaseReportFields(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, java.util.List<gov.va.med.imaging.pathology.PathologyCaseReportField> fields
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("saveCaseReportFields, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + pathologyCaseUrn.toString() + ") + '.");
		setDataSourceMethodAndVersion("saveCaseReportFields");
		
		Object reportFields = gov.va.med.imaging.federation.pathology.rest.translator.PathologyFederationRestTranslator.translateCaseReportFields(fields);		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{caseId}", pathologyCaseUrn.toString());
			
		String url = getWebResourceUrl("case/report/fields/{caseId}", urlParameterKeyValues ); 				
		FederationRestPostClient postClient = new FederationRestPostClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		gov.va.med.imaging.federation.pathology.rest.types.PathologyFederationSaveCaseReportResultType	federationResult = postClient.executeRequest(gov.va.med.imaging.federation.pathology.rest.types.PathologyFederationSaveCaseReportResultType.class, reportFields);
		getLogger().info("saveCaseReportFields, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
		gov.va.med.imaging.pathology.PathologySaveCaseReportResult result = gov.va.med.imaging.federation.pathology.rest.translator.PathologyFederationRestTranslator.translate(federationResult);
		//getLogger().info("saveCaseReportFields, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : result.size()) + "] business objects.");
		getLogger().info("saveCaseReportFields, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : "not null") + "] business objects.");
		return result;
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyPostMethod.tfl
 	*/
 	@Override
 	public void saveCaseSupplementalReport(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, java.lang.String reportContents
 		 			, java.util.Date date
 		 			, boolean verified
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("saveCaseSupplementalReport, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + pathologyCaseUrn.toString() + ", " + "verified='" + verified + "'" + ", " + "date='" + date + "'" + ") + '.");
		setDataSourceMethodAndVersion("saveCaseSupplementalReport");
		
		Object report = gov.va.med.imaging.federation.pathology.rest.translator.PathologyFederationRestTranslator.translate(reportContents,date);		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{caseId}", pathologyCaseUrn.toString());
		urlParameterKeyValues.put("{verified}", String.valueOf(verified));
			
		String url = getWebResourceUrl("case/supplementalreport/{caseId}/{verified}", urlParameterKeyValues ); 				
		FederationRestPostClient postClient = new FederationRestPostClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		RestBooleanReturnType	federationResult = postClient.executeRequest(RestBooleanReturnType.class, report);
		getLogger().info("saveCaseSupplementalReport, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
			// do nothing
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyGetMethod.tfl
 	*/
 	@Override
 	public java.util.List<gov.va.med.imaging.pathology.PathologySite> getSites(
 			gov.va.med.RoutingToken globalRoutingToken
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("getSites, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + globalRoutingToken.toRoutingTokenString() + ") + '.");
		setDataSourceMethodAndVersion("getSites");
		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{routingToken}", globalRoutingToken.toRoutingTokenString());
			
		String url = getWebResourceUrl("sites/{routingToken}", urlParameterKeyValues ); 				
		FederationRestGetClient getClient = new FederationRestGetClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		gov.va.med.imaging.federation.pathology.rest.types.PathologyFederationSiteType[]	federationResult = getClient.executeRequest(gov.va.med.imaging.federation.pathology.rest.types.PathologyFederationSiteType[].class);
		getLogger().info("getSites, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
		java.util.List<gov.va.med.imaging.pathology.PathologySite> result = gov.va.med.imaging.federation.pathology.rest.translator.PathologyFederationRestTranslator.translate(federationResult);
		//getLogger().info("getSites, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : result.size()) + "] business objects.");
		getLogger().info("getSites, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : "not null") + "] business objects.");
		return result;
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyGetMethod.tfl
 	*/
 	@Override
 	public java.lang.Integer getLockExpiresMinutes(
 			gov.va.med.RoutingToken globalRoutingToken
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("getLockExpiresMinutes, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + globalRoutingToken.toRoutingTokenString() + ") + '.");
		setDataSourceMethodAndVersion("getLockExpiresMinutes");
		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{routingToken}", globalRoutingToken.toRoutingTokenString());
			
		String url = getWebResourceUrl("lock/expired/{routingToken}", urlParameterKeyValues ); 				
		FederationRestGetClient getClient = new FederationRestGetClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		RestIntegerType	federationResult = getClient.executeRequest(RestIntegerType.class);
		getLogger().info("getLockExpiresMinutes, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
		java.lang.Integer result = RestCoreTranslator.translate(federationResult);
		//getLogger().info("getLockExpiresMinutes, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : result.size()) + "] business objects.");
		getLogger().info("getLockExpiresMinutes, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : "not null") + "] business objects.");
		return result;
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyPostMethod.tfl
 	*/
 	@Override
 	public void setLockExpiresMinutes(
 			gov.va.med.RoutingToken globalRoutingToken
 		 			, int minutes
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("setLockExpiresMinutes, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + globalRoutingToken.toRoutingTokenString() + ", " + "minutes='" + minutes + "'" + ") + '.");
		setDataSourceMethodAndVersion("setLockExpiresMinutes");
		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{routingToken}", globalRoutingToken.toRoutingTokenString());
		urlParameterKeyValues.put("{minutes}", String.valueOf(minutes));
			
		String url = getWebResourceUrl("lock/expired/{routingToken}/{minutes}", urlParameterKeyValues ); 				
		FederationRestPostClient postClient = new FederationRestPostClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		RestBooleanReturnType	federationResult = postClient.executeRequest(RestBooleanReturnType.class, new RestNullPostType());
		getLogger().info("setLockExpiresMinutes, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
			// do nothing
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyGetMethod.tfl
 	*/
 	@Override
 	public java.util.List<gov.va.med.imaging.pathology.PathologyCptCode> getCaseCptCodes(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("getCaseCptCodes, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + pathologyCaseUrn.toString() + ") + '.");
		setDataSourceMethodAndVersion("getCaseCptCodes");
		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{caseId}", pathologyCaseUrn.toString());
			
		String url = getWebResourceUrl("cpt/{caseId}", urlParameterKeyValues ); 				
		FederationRestGetClient getClient = new FederationRestGetClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		gov.va.med.imaging.federation.pathology.rest.types.PathologyFederationCptCodeType[]	federationResult = getClient.executeRequest(gov.va.med.imaging.federation.pathology.rest.types.PathologyFederationCptCodeType[].class);
		getLogger().info("getCaseCptCodes, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
		java.util.List<gov.va.med.imaging.pathology.PathologyCptCode> result = gov.va.med.imaging.federation.pathology.rest.translator.PathologyFederationRestTranslator.translate(federationResult);
		//getLogger().info("getCaseCptCodes, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : result.size()) + "] business objects.");
		getLogger().info("getCaseCptCodes, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : "not null") + "] business objects.");
		return result;
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyGetMethod.tfl
 	*/
 	@Override
 	public java.util.List<java.lang.String> getPathologyUserKeys(
 			gov.va.med.RoutingToken globalRoutingToken
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("getPathologyUserKeys, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + globalRoutingToken.toRoutingTokenString() + ") + '.");
		setDataSourceMethodAndVersion("getPathologyUserKeys");
		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{routingToken}", globalRoutingToken.toRoutingTokenString());
			
		String url = getWebResourceUrl("user/keys/{routingToken}", urlParameterKeyValues ); 				
		FederationRestGetClient getClient = new FederationRestGetClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		RestStringArrayType	federationResult = getClient.executeRequest(RestStringArrayType.class);
		getLogger().info("getPathologyUserKeys, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
		java.util.List<java.lang.String> result = RestCoreTranslator.translate(federationResult);
		//getLogger().info("getPathologyUserKeys, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : result.size()) + "] business objects.");
		getLogger().info("getPathologyUserKeys, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : "not null") + "] business objects.");
		return result;
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyPostMethod.tfl
 	*/
 	@Override
 	public java.util.List<gov.va.med.imaging.pathology.PathologyCase> getSpecificCases(
 			java.util.List<gov.va.med.imaging.pathology.PathologyCaseURN> cases
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("getSpecificCases, Transaction [" + transactionContext.getTransactionId() + "] initiated () + '.");
		setDataSourceMethodAndVersion("getSpecificCases");
		
		Object urns = gov.va.med.imaging.federation.pathology.rest.translator.PathologyFederationRestTranslator.translateCaseUrns(cases);		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
			
		String url = getWebResourceUrl("cases", urlParameterKeyValues ); 				
		FederationRestPostClient postClient = new FederationRestPostClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		gov.va.med.imaging.federation.pathology.rest.types.PathologyFederationCaseType[]	federationResult = postClient.executeRequest(gov.va.med.imaging.federation.pathology.rest.types.PathologyFederationCaseType[].class, urns);
		getLogger().info("getSpecificCases, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
		java.util.List<gov.va.med.imaging.pathology.PathologyCase> result = gov.va.med.imaging.federation.pathology.rest.translator.PathologyFederationRestTranslator.translate(federationResult);
		//getLogger().info("getSpecificCases, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : result.size()) + "] business objects.");
		getLogger().info("getSpecificCases, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : "not null") + "] business objects.");
		return result;
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyGetMethod.tfl
 	*/
 	@Override
 	public java.lang.Boolean checkPendingConsultationStatus(
 			gov.va.med.RoutingToken globalRoutingToken
 		 			, java.lang.String stationNumber
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("checkPendingConsultationStatus, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + "stationNumber='" + stationNumber + "'" + ") + '.");
		setDataSourceMethodAndVersion("checkPendingConsultationStatus");
		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{routingToken}", globalRoutingToken.toRoutingTokenString());
		urlParameterKeyValues.put("{stationNumber}", stationNumber);
			
		String url = getWebResourceUrl("consultations/{routingToken}/{stationNumber}", urlParameterKeyValues ); 				
		FederationRestGetClient getClient = new FederationRestGetClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		RestBooleanReturnType	federationResult = getClient.executeRequest(RestBooleanReturnType.class);
		getLogger().info("checkPendingConsultationStatus, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
		java.lang.Boolean result = RestCoreTranslator.translate(federationResult);
		//getLogger().info("checkPendingConsultationStatus, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : result.size()) + "] business objects.");
		getLogger().info("checkPendingConsultationStatus, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : "not null") + "] business objects.");
		return result;
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyPostMethod.tfl
 	*/
 	@Override
 	public java.lang.String saveCaseTissues(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, gov.va.med.imaging.pathology.PathologyFieldURN tissueFieldUrn
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("saveCaseTissues, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + "caseId='" + pathologyCaseUrn.toString() + "'" + ", " + "tissueId='" + tissueFieldUrn.toString() + "'" + ") + '.");
		setDataSourceMethodAndVersion("saveCaseTissues");
		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{caseId}", pathologyCaseUrn.toString());
		urlParameterKeyValues.put("{tissueId}", tissueFieldUrn.toString());
			
		String url = getWebResourceUrl("tissues/{caseId}/{tissueId}", urlParameterKeyValues ); 				
		FederationRestPostClient postClient = new FederationRestPostClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		RestStringType	federationResult = postClient.executeRequest(RestStringType.class, new RestNullPostType());
		getLogger().info("saveCaseTissues, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
		java.lang.String result = RestCoreTranslator.translate(federationResult);
		//getLogger().info("saveCaseTissues, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : result.size()) + "] business objects.");
		getLogger().info("saveCaseTissues, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : "not null") + "] business objects.");
		return result;
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyPostMethod.tfl
 	*/
 	@Override
 	public gov.va.med.imaging.pathology.PathologyCaseURN copyCase(
 			gov.va.med.RoutingToken globalRoutingToken
 		 			, gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("copyCase, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + "routingToken='" + globalRoutingToken.toRoutingTokenString() + "'" + ", " + "caseId='" + pathologyCaseUrn.toString() + "'" + ") + '.");
		setDataSourceMethodAndVersion("copyCase");
		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{routingToken}", globalRoutingToken.toRoutingTokenString());
		urlParameterKeyValues.put("{caseId}", pathologyCaseUrn.toString());
			
		String url = getWebResourceUrl("case/copy/{routingToken}/{caseId}", urlParameterKeyValues ); 				
		FederationRestPostClient postClient = new FederationRestPostClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		RestStringType	federationResult = postClient.executeRequest(RestStringType.class, new RestNullPostType());
		getLogger().info("copyCase, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
		gov.va.med.imaging.pathology.PathologyCaseURN result = gov.va.med.imaging.federation.pathology.rest.translator.PathologyFederationRestTranslator.translateCaseId(federationResult);
		//getLogger().info("copyCase, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : result.size()) + "] business objects.");
		getLogger().info("copyCase, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : "not null") + "] business objects.");
		return result;
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyPostMethod.tfl
 	*/
 	@Override
 	public void deleteTissue(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, java.lang.String tissueId
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("deleteTissue, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + "caseId='" + pathologyCaseUrn.toString() + "'" + ", " + "tissueId='" + tissueId + "'" + ") + '.");
		setDataSourceMethodAndVersion("deleteTissue");
		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{caseId}", pathologyCaseUrn.toString());
		urlParameterKeyValues.put("{tissueId}", tissueId);
			
		String url = getWebResourceUrl("tissues/delete/{caseId}/{tissueId}", urlParameterKeyValues ); 				
		FederationRestPostClient postClient = new FederationRestPostClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		RestBooleanReturnType	federationResult = postClient.executeRequest(RestBooleanReturnType.class, new RestNullPostType());
		getLogger().info("deleteTissue, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
			// do nothing
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyPostMethod.tfl
 	*/
 	@Override
 	public void deleteSnomedCode(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, java.lang.String tissueId
 		 			, java.lang.String snomedId
 		 			, gov.va.med.imaging.pathology.enums.PathologyField snomedField
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("deleteSnomedCode, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + "caseId='" + pathologyCaseUrn.toString() + "'" + ", " + "tissueId='" + tissueId + "'" + ", " + "snomedId='" + snomedId + "'" + ", " + "snomedField='" + snomedField.name() + "'" + ") + '.");
		setDataSourceMethodAndVersion("deleteSnomedCode");
		
		Object field = gov.va.med.imaging.federation.pathology.rest.translator.PathologyFederationRestTranslator.translate(snomedField);		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{caseId}", pathologyCaseUrn.toString());
		urlParameterKeyValues.put("{tissueId}", tissueId);
		urlParameterKeyValues.put("{snomedId}", snomedId);
		urlParameterKeyValues.put("{field}", field.toString());
			
		String url = getWebResourceUrl("snomed/delete/{caseId}/{tissueId}/{snomedId}/{field}", urlParameterKeyValues ); 				
		FederationRestPostClient postClient = new FederationRestPostClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		RestBooleanReturnType	federationResult = postClient.executeRequest(RestBooleanReturnType.class, new RestNullPostType());
		getLogger().info("deleteSnomedCode, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
			// do nothing
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyPostMethod.tfl
 	*/
 	@Override
 	public void deleteSnomedEtiologyCode(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, java.lang.String tissueId
 		 			, java.lang.String snomedId
 		 			, java.lang.String etiologyId
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("deleteSnomedEtiologyCode, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + "caseId='" + pathologyCaseUrn.toString() + "'" + ", " + "tissueId='" + tissueId + "'" + ", " + "snomedId='" + snomedId + "'" + ", " + "etiologyId='" + etiologyId + "'" + ") + '.");
		setDataSourceMethodAndVersion("deleteSnomedEtiologyCode");
		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{caseId}", pathologyCaseUrn.toString());
		urlParameterKeyValues.put("{tissueId}", tissueId);
		urlParameterKeyValues.put("{snomedId}", snomedId);
		urlParameterKeyValues.put("{etiologyId}", etiologyId);
			
		String url = getWebResourceUrl("snomed/etiology/delete/{caseId}/{tissueId}/{snomedId}/{etiologyId}", urlParameterKeyValues ); 				
		FederationRestPostClient postClient = new FederationRestPostClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		RestBooleanReturnType	federationResult = postClient.executeRequest(RestBooleanReturnType.class, new RestNullPostType());
		getLogger().info("deleteSnomedEtiologyCode, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
			// do nothing
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyPostMethod.tfl
 	*/
 	@Override
 	public void saveCaseNote(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 			, java.lang.String note
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("saveCaseNote, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + "caseId='" + pathologyCaseUrn.toString() + "'" + ") + '.");
		setDataSourceMethodAndVersion("saveCaseNote");
		
		Object n = RestCoreTranslator.translate(note);		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{caseId}", pathologyCaseUrn.toString());
			
		String url = getWebResourceUrl("case/note/{caseId}", urlParameterKeyValues ); 				
		FederationRestPostClient postClient = new FederationRestPostClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		RestBooleanReturnType	federationResult = postClient.executeRequest(RestBooleanReturnType.class, n);
		getLogger().info("saveCaseNote, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
			// do nothing
	}

 	 	/*
 	* Generated method, modifications will be overwritten when project is built
 	*
 	* The template for this method may be found in FederationDataSourceProxyGetMethod.tfl
 	*/
 	@Override
 	public java.lang.String getCaseNote(
 			gov.va.med.imaging.pathology.PathologyCaseURN pathologyCaseUrn
 		 ) 
	throws MethodException, ConnectionException
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		getLogger().info("getCaseNote, Transaction [" + transactionContext.getTransactionId() + "] initiated (" + "caseId='" + pathologyCaseUrn.toString() + "'" + ") + '.");
		setDataSourceMethodAndVersion("getCaseNote");
		
		
		Map<String, String> urlParameterKeyValues = new HashMap<String, String>();
		urlParameterKeyValues.put("{caseId}", pathologyCaseUrn.toString());
			
		String url = getWebResourceUrl("case/note/{caseId}", urlParameterKeyValues ); 				
		FederationRestGetClient getClient = new FederationRestGetClient(url, MediaType.APPLICATION_XML_TYPE, federationConfiguration);
		RestStringType	federationResult = getClient.executeRequest(RestStringType.class);
		getLogger().info("getCaseNote, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (federationResult == null ? "null" :  "not null") + "] federation result object.");
		
		java.lang.String result = RestCoreTranslator.translate(federationResult);
		//getLogger().info("getCaseNote, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : result.size()) + "] business objects.");
		getLogger().info("getCaseNote, Transaction [" + transactionContext.getTransactionId() + "] returned [" + (result == null ? "null" : "not null") + "] business objects.");
		return result;
	}

}