/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * Date Created: May 10, 2010
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author     DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */
 package gov.va.med.imaging.pathology.commands.datasource;
 
 import java.util.Date;
 import org.apache.log4j.*;
 import gov.va.med.imaging.*;
 import gov.va.med.imaging.core.interfaces.exceptions.*;
 import gov.va.med.imaging.datasource.*;
 import gov.va.med.imaging.core.interfaces.router.Command;
 import gov.va.med.imaging.core.interfaces.router.AsynchronousCommandResultListener;
 import gov.va.med.imaging.core.router.AbstractDataSourceCommandImpl;
 import javax.annotation.Generated;
 
 @SuppressWarnings("unused")
 public class GetPathologySpecificCasesDataSourceCommandImpl
 extends AbstractDataSourceCommandImpl<java.util.List<gov.va.med.imaging.pathology.PathologyCase>,gov.va.med.imaging.pathology.datasource.PathologyDataSourceSpi>
 {
 	private final static long serialVersionUID = 1L;
 
 	private final gov.va.med.RoutingToken routingToken;
 	private final java.util.List<gov.va.med.imaging.pathology.PathologyCaseURN> cases;
 
 	public GetPathologySpecificCasesDataSourceCommandImpl(
 			gov.va.med.RoutingToken routingToken
 		 			, java.util.List<gov.va.med.imaging.pathology.PathologyCaseURN> cases
 		)
 	{
	 	this.routingToken = routingToken;	 	
	 	this.cases = cases;	 	
 	}
 	
 	@Override
	protected java.util.List<gov.va.med.imaging.pathology.PathologyCase> getCommandResult(gov.va.med.imaging.pathology.datasource.PathologyDataSourceSpi spi)
	throws ConnectionException, MethodException
	{
	 			return spi.getSpecificCases(cases);
	}
	
	@Override
	public gov.va.med.RoutingToken getRoutingToken()
	{
		return routingToken;	
	}

	@Override
	protected String getSiteNumber()
	{
		return getRoutingToken().getRepositoryUniqueId();
	}

	@Override
	protected Class<gov.va.med.imaging.pathology.datasource.PathologyDataSourceSpi> getSpiClass()
	{
		return gov.va.med.imaging.pathology.datasource.PathologyDataSourceSpi.class;
	}
 
 	@Override
	protected String getSpiMethodName()
	{
		return "getSpecificCases";
	}
	
	@Override
	protected Class<?>[] getSpiMethodParameterTypes()
	{			
	 	return new Class<?> [] {java.util.List.class};		
	}
	
	@Override
	protected Object[] getSpiMethodParameters()
	{
	 	return new Object [] {cases};		
	}
	
	@Override
	protected java.util.List<gov.va.med.imaging.pathology.PathologyCase> postProcessResult(java.util.List<gov.va.med.imaging.pathology.PathologyCase> result)
	{
		return PathologyDataSourceHelper.postProcessCasesResult(result);
	}
 }
