/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Apr 16, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.passthrough.rest.translator;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import gov.va.med.imaging.exchange.business.PassthroughInputMethod;
import gov.va.med.imaging.exchange.business.PassthroughParameter;
import gov.va.med.imaging.passthrough.rest.types.PassthroughMethodType;
import gov.va.med.imaging.passthrough.rest.types.PassthroughParameterType;
import gov.va.med.imaging.passthrough.rest.types.PassthroughParameterTypeType;

/**
 * @author       DNS
 *
 */
public class PassthroughRestTranslator
{
	
	private static Map<gov.va.med.imaging.exchange.business.PassthroughParameterType, PassthroughParameterTypeType> passthroughParameterTypeMap;
	
	static
	{
		passthroughParameterTypeMap = 
			new HashMap<gov.va.med.imaging.exchange.business.PassthroughParameterType, PassthroughParameterTypeType>();
		passthroughParameterTypeMap.put(gov.va.med.imaging.exchange.business.PassthroughParameterType.list, 
				PassthroughParameterTypeType.list);
		passthroughParameterTypeMap.put(gov.va.med.imaging.exchange.business.PassthroughParameterType.literal, 
				PassthroughParameterTypeType.literal);
		passthroughParameterTypeMap.put(gov.va.med.imaging.exchange.business.PassthroughParameterType.reference, 
				PassthroughParameterTypeType.reference);
	}
	
	
	public static PassthroughInputMethod translate(PassthroughMethodType method)
	{
		PassthroughInputMethod result = new PassthroughInputMethod(method.getMethodName());
		
		if(method.getParameters() != null && method.getParameters().getParameter() != null && method.getParameters().getParameter().length > 0)		
		{
			for(PassthroughParameterType parameter : method.getParameters().getParameter())
			{
				result.getParameters().add(translate(parameter));
			}			
		}
		
		return result;
	}
	
	private static PassthroughParameter translate(PassthroughParameterType parameter)
	{
		return new PassthroughParameter(parameter.getIndex(), parameter.getValue(), 
				(parameter.getMultiples() == null ? null : parameter.getMultiples().getMultiple()), 
				translate(parameter.getParameterType()));
	}
	
	private static gov.va.med.imaging.exchange.business.PassthroughParameterType translate(PassthroughParameterTypeType parameterType)
	{
		if(parameterType != null)
		{
			for(Entry<gov.va.med.imaging.exchange.business.PassthroughParameterType, PassthroughParameterTypeType> entry : passthroughParameterTypeMap.entrySet())
			{
				if(entry.getValue() == parameterType)
				{
					return entry.getKey();
				}
			}
		}
		
		return gov.va.med.imaging.exchange.business.PassthroughParameterType.literal;
	}

}
