/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Apr 16, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (DNS0.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.passthrough.rest;

import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.passthrough.commands.PassthroughRemoteMethodCommand;
import gov.va.med.imaging.passthrough.rest.types.PassthroughMethodType;
import gov.va.med.imaging.passthrough.rest.types.PassthroughParameterMultiplesType;
import gov.va.med.imaging.passthrough.rest.types.PassthroughParameterType;
import gov.va.med.imaging.passthrough.rest.types.PassthroughParameterTypeType;
import gov.va.med.imaging.passthrough.rest.types.PassthroughParametersType;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

/**
 * @author       DNS
 *
 */
@Path("")
public class PassthroughService
{

	@GET
	@Produces(MediaType.TEXT_PLAIN)
	@Path("passthrough/{siteId}/{methodName}/{context}")
	public String executePassthroughMethod(
			@PathParam("siteId") String siteId, 
			@PathParam("methodName")String methodName,
			@PathParam("context")String context)
	throws MethodException, ConnectionException
	{
		return new PassthroughRemoteMethodCommand(siteId, methodName, context).execute();
	}
	
	@POST
	@Produces(MediaType.TEXT_PLAIN)
	@Consumes(MediaType.APPLICATION_XML)
	@Path("passthrough/{siteId}/{context}")
	public String executePassthroughMethod(
			@PathParam("siteId") String siteId, 
			@PathParam("context")String context,
			PassthroughMethodType method)
	throws MethodException, ConnectionException
	{
		return new PassthroughRemoteMethodCommand(siteId, context, method).execute();
	}
	
	@GET
	@Produces(MediaType.APPLICATION_XML)
	@Path("sample")
	public PassthroughMethodType sample()
	{
		PassthroughMethodType result = new PassthroughMethodType("MAG TEST RPC");
		PassthroughParameterType [] parameters = new PassthroughParameterType[2];
		parameters[0] = new PassthroughParameterType(0, "123", null, PassthroughParameterTypeType.literal);
		PassthroughParameterMultiplesType multiples = new PassthroughParameterMultiplesType();
		multiples.setMultiple(new String [] {"val1", "val2"});
		parameters[1] = new PassthroughParameterType(1, null, multiples, 
				PassthroughParameterTypeType.list);
		PassthroughParametersType parametersType = new PassthroughParametersType();
		parametersType.setParameter(parameters);
		result.setParameters(parametersType);
		return result;
	}
}
