/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Apr 16, 2012
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:        DNS
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone DNS.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.passthrough.commands;

import gov.va.med.RoutingToken;
import gov.va.med.exceptions.RoutingTokenFormatException;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.exchange.RoutingTokenHelper;
import gov.va.med.imaging.exchange.translation.exceptions.TranslationException;
import gov.va.med.imaging.passthrough.rest.translator.PassthroughRestTranslator;
import gov.va.med.imaging.passthrough.rest.types.PassthroughMethodType;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;
import gov.va.med.imaging.web.commands.WebserviceInputParameterTransactionContextField;

import java.util.HashMap;
import java.util.Map;

/**
 * @author       DNS
 *
 */
public class PassthroughRemoteMethodCommand
extends AbstractPassthroughCommand<String, String>
{
	private final String siteId;
	private final PassthroughMethodType method;
	private final String context;
	
	public PassthroughRemoteMethodCommand(String siteId, String context, 
			PassthroughMethodType method)
	{
		super("remoteMethodPassthrough");
		this.siteId = siteId;
		this.method = method;
		this.context = context;
	}
	
	public PassthroughRemoteMethodCommand(String siteId, String methodName, String context)
	{
		this(siteId, context, new PassthroughMethodType(methodName));
	}

	public String getSiteId()
	{
		return siteId;
	}

	public String getContext()
	{
		return context;
	}

	public PassthroughMethodType getMethod()
	{
		return method;
	}

	@Override
	protected String executeRouterCommand() 
	throws MethodException, ConnectionException
	{
		try
		{
			TransactionContextFactory.get().setImagingSecurityContextType(getContext());
			RoutingToken routingToken =
				RoutingTokenHelper.createSiteAppropriateRoutingToken(getSiteId());
			return getRouter().postPassthroughMethod(routingToken, PassthroughRestTranslator.translate(getMethod()));
		}
		catch(RoutingTokenFormatException rtfX)
		{
			throw new MethodException(rtfX);
		}
	}

	@Override
	protected String getMethodParameterValuesString()
	{
		return "for method '" + getMethod().getMethodName() + "' at site '" + getSiteId() + "'";
	}

	@Override
	protected String translateRouterResult(String routerResult)
			throws TranslationException, MethodException
	{
		return routerResult;
	}

	@Override
	protected Class<String> getResultClass()
	{
		return String.class;
	}

	@Override
	protected Map<WebserviceInputParameterTransactionContextField, String> getTransactionContextFields()
	{
		Map<WebserviceInputParameterTransactionContextField, String> transactionContextFields = 
			new HashMap<WebserviceInputParameterTransactionContextField, String>();
		
		transactionContextFields.put(WebserviceInputParameterTransactionContextField.quality, transactionContextNaValue);
		transactionContextFields.put(WebserviceInputParameterTransactionContextField.urn, transactionContextNaValue);
		transactionContextFields.put(WebserviceInputParameterTransactionContextField.queryFilter, transactionContextNaValue);

		return transactionContextFields;
	}

	@Override
	public Integer getEntriesReturned(String translatedResult)
	{
		return translatedResult == null ? 0 : 1;
	}

}
