package gov.va.med.imaging.dicom.rdsr;

import gov.va.med.imaging.core.annotations.routerfacade.FacadeRouterInterface;
import gov.va.med.imaging.core.annotations.routerfacade.FacadeRouterInterfaceCommandTester;
import gov.va.med.imaging.core.annotations.routerfacade.FacadeRouterMethod;
import gov.va.med.imaging.core.interfaces.FacadeRouter;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.exchange.business.dicom.rdsr.Dose;

import java.util.List;

/**
 * 
 * @author DNS
 *
 */
@FacadeRouterInterface
@FacadeRouterInterfaceCommandTester
public interface RDSRRouter extends FacadeRouter
{
	
	@FacadeRouterMethod(asynchronous=false)
	public List<Dose> getRadiationDoseDetails(String patientDfn, String accessionNumber)
			throws MethodException, ConnectionException;

}
