/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * @date Apr 27, 2010
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author DNS
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (DNS.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */

package gov.va.med;

import gov.va.med.GenericDataGenerator.Mode;
import gov.va.med.NetworkSimulatingInputStream.DELAY_MODE;
import gov.va.med.NetworkSimulatingInputStream.EXCEPTION_MODE;


/**
 * Just a DataGenerator that collects all of the DataGenerator implementations
 * into one.
 * 
 * @author DNS
 *
 */
public class MasterDataGenerator
extends GenericDataGenerator
{

	/**
	 * @param mode
	 * @param ioExceptionMode
	 * @param delayMode
	 */
	public MasterDataGenerator(DataGenerationConfiguration configuration)
	{
		super(configuration);
		
		registerDataGenerator(new ClinicalDisplayDataGenerator(configuration));
		registerDataGenerator(new LoggingDataGenerator(configuration));
		registerDataGenerator(new PassthroughDataGenerator(configuration));
		registerDataGenerator(new VistaDataGenerator(configuration));
		registerDataGenerator(new VistaRadDataGenerator(configuration));
	}

}
