/**
 * MIX Web App Rest service definitions
 * Date Created: Nov 30, 2016
 * Developer:  vacotittoc
 */
package gov.va.med.imaging.mix.webservices.rest;

import java.text.ParseException;
import java.util.List;

import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.exceptions.URNFormatException;
import gov.va.med.imaging.exchange.business.Study;
import gov.va.med.imaging.exchange.business.StudySetResult;
import gov.va.med.imaging.exchange.translation.exceptions.TranslationException;
//import gov.va.med.imaging.encryption.exceptions.AesEncryptionException;
import gov.va.med.imaging.mix.webservices.commands.v1.MixGetReportAndShallowStudyListCommandV1; // MixGetStudyListCommandV1;
import gov.va.med.imaging.mix.webservices.commands.v1.MixGetStudyTreeCommandV1;
import gov.va.med.imaging.mix.webservices.fhir.types.v1.DiagnosticReport;
import gov.va.med.imaging.mix.webservices.fhir.types.v1.ImagingStudy;
import gov.va.med.imaging.mix.webservices.translator.v1.MixTranslator;
import gov.va.med.imaging.mix.webservices.translator.v1.MixTranslatorV1;
//import gov.va.med.imaging.rest.types.RestBooleanReturnType;
//import gov.va.med.imaging.rest.types.RestStringType;
//import gov.va.med.imaging.tomcat.vistarealm.encryption.EncryptionToken;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;
import gov.va.med.imaging.transactioncontext.TransactionContextHttpHeaders;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
//import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

/**
 * @author vacotittoc
 *
 */
@Path("mix")
public class MixServices
{
	// pass 1 level 1 (flavor 1)
	@GET
	@Path("DiagnosticReport/subject?value={patientId}&assigner={assignerId}?fromDate={fromDate}&toDate={toDate}") 
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.TEXT_PLAIN)
	public Response getReportAndShallowStudyList(			
			@PathParam("patientId") String patientId,
			@PathParam("assignerId") String assignerId,
			@PathParam("fromDate") String fromDate,
			@PathParam("toDate") String toDate)
	throws MethodException, ConnectionException
	{
		// ICN, "VHA" and "yyyy-MM-dd"-s are expected; modalities=null
		return wrapResponse(new MixGetReportAndShallowStudyListCommandV1(patientId, assignerId, fromDate, toDate, null).execute());
	}

	// pass 1 level 1 (flavor 2)
	@GET
	@Path("DiagnosticReport/subject?value={patientId}&assigner={assignerId}?fromDate={fromDate}&toDate={toDate}&modalities={modalities}") 
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.TEXT_PLAIN)
	public Response getReportAndShallowStudyListbyModalities(			
			@PathParam("patientId") String patientId,
			@PathParam("assignerId") String assignerId,
			@PathParam("fromDate") String fromDate,
			@PathParam("toDate") String toDate,
			@PathParam("modalities") String modalities)
	throws MethodException, ConnectionException
	{
		// ICN, "VHA", "yyyy-MM-dd"-s and .separated list of modalities (to include) are expected
		return wrapResponse(new MixGetReportAndShallowStudyListCommandV1(patientId, assignerId, fromDate, toDate, modalities).execute());
	}
	
	// pass 1 level 2
	@GET
	@Path("ImagingStudy?uid={studyUid}")
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.TEXT_PLAIN)
	public Response getStudyTree(			
			@PathParam("studyUid") String studyUid)
	throws MethodException, ConnectionException
	{
		// DICOM Study UID expected
		return wrapResponse(convertStudy(new MixGetStudyTreeCommandV1(studyUid).execute()));
	}
	
//	// pass 2 TN
//	@GET
//	@Path("RetrieveThumbnail?requestType=WADO&studyUID={studyUid}&seriesUID={seriesUid}&objectUID={instanceUid}")
//	@Produces(MediaType.APPLICATION_OCTET_STREAM)
//	@Consumes(MediaType.TEXT_PLAIN)
//	public Response getThumbnailImage(			
//			@PathParam("studyUid") String studyUid,
//			@PathParam("seriesUid") String seriesUid,
//			@PathParam("instanceUid") String instanceUid)
//	throws MethodException, ConnectionException
//	{
//		// 3 DICOM UIDs are expected
//		return wrapResponse(new MixGetThumbnailImageCommandV1(studyUid, seriesUid, instanceUid).execute());
//	}
//	
//	// pass 2 Ref/Diag
//	@GET
//	@Path("RetrieveInstance/studies/{studyUid}/series/{seriesUid}/instances/{instanceUid}&imageQuality={iQ}&transferSyntax={transferSyntaxUID}&accept={contentType}")
//	@Produces(MediaType.APPLICATION_OCTET_STREAM)
//	@Consumes(MediaType.TEXT_PLAIN)
//	public Response getDicomJ2KImage(			
//			@PathParam("studyUid") String studyUid,
//			@PathParam("seriesUid") String seriesUid,
//			@PathParam("instanceUid") String instanceUid,
//			@PathParam("imageQuality") String imageQuality,
//			@PathParam("transferSyntaxUID") String transferSyntaxUID,
//			@PathParam("contentType") String contentType)
//	throws MethodException, ConnectionException
//	{
//		// 4 DICOM UIDs, 70 or 90 and "application/dicom+jp2" are expected
//		return wrapResponse(new MixGetDicomJ2KImageCommand(studyUid, seriesUid, instanceUid, imageQuality, transferSyntaxUID, contentType).execute());
//	}
	
	
	private ImagingStudy convertStudy(Study study)
	throws MethodException
	{
		ImagingStudy imagingStudy= null;
		
		try {
			imagingStudy = MixTranslator.translateStudy(study);
		} 
		catch (URNFormatException ufe) {
			throw new MethodException("URN format exception during study translation: " + ufe.getMessage());
		}
		catch (ParseException pe) {
			throw new MethodException("URN parse exception during study translation: " + pe.getMessage());
		}
		return imagingStudy;
	}
	
	protected List<DiagnosticReport> convertStudySetResult(StudySetResult studySetresult)
	throws MethodException
	{
		List<DiagnosticReport> diagnosticReports = null;
		try {
			diagnosticReports = MixTranslatorV1.convertStudies(studySetresult);
		}
		catch (TranslationException te) {
			throw new MethodException("StudySetResult translation exception: " + te.getMessage());
		}
		return diagnosticReports;
	}

	private Response wrapResponse(Object result)
	throws MethodException
	{
		return Response.status(Status.OK).header(TransactionContextHttpHeaders.httpHeaderMachineName, 
				TransactionContextFactory.get().getMachineName()).entity(result).build();
	}

}
