package gov.va.med.imaging.mix.rest.proxy;

import java.util.Map;

import org.apache.log4j.Logger;

import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.mix.proxy.AbstractMixProxy;
import gov.va.med.imaging.mix.proxy.IMixProxy;
import gov.va.med.imaging.url.mix.configuration.MIXConfiguration;
import gov.va.med.imaging.proxy.rest.RestProxyCommon;
import gov.va.med.imaging.mix.rest.endpoints.MixImageWADORestUri;
import gov.va.med.imaging.proxy.services.ProxyServiceType;
import gov.va.med.imaging.proxy.services.ProxyServices;

/**
 * @author vacotittoc
 *
 */
public abstract class AbstractMixRestImageProxy 
extends AbstractMixProxy 
implements IMixProxy 
{	
	protected Logger getLogger()
	{
		return logger;
	}
	
	public AbstractMixRestImageProxy(ProxyServices proxyServices, 
			MIXConfiguration mixConfiguration)
	{
		super(proxyServices, mixConfiguration);
	}
	
//	protected abstract String getRestServicePath();
//	protected abstract ProxyServiceType getProxyServiceType();

	protected String getRestServicePath()
	{
		return MixImageWADORestUri.mixServicePath;
	}
	protected ProxyServiceType getProxyServiceType()
	{
		return ProxyServiceType.image;
	}
	
	public String getWebResourceUrl(String methodUri, Map<String, String> urlParameterKeyValues) // was protected...
	throws ConnectionException
	{
		StringBuilder url = new StringBuilder();
		url.append(proxyServices.getProxyService(getProxyServiceType()).getConnectionURL());
		//url.append("http://localhost:8080/FederationWebApp/restservices/");
		url.append(getRestServicePath());
		url.append("/");
		url.append(RestProxyCommon.replaceMethodUriWithValues(methodUri, urlParameterKeyValues));		
		
		return url.toString();
	}
}
