package gov.va.med.imaging.mix.rest.proxy;

import javax.ws.rs.core.MediaType;

import gov.va.med.imaging.url.mix.configuration.MIXConfiguration;
import gov.va.med.imaging.proxy.rest.AbstractRestClient;
import gov.va.med.imaging.transactioncontext.TransactionContext;
import gov.va.med.imaging.transactioncontext.TransactionContextFactory;
import gov.va.med.imaging.transactioncontext.TransactionContextHttpHeaders;

/**
 * @author vacotittoc
 *
 */
public abstract class AbstractMixRestClient
extends AbstractRestClient
{
	private final static int defaultMetadataTimeoutMs = 600000;

	public AbstractMixRestClient(String url, String mediaType, 
			MIXConfiguration mixConfiguration)
	{
		super(url, mediaType, getMetadataTimeoutMs(mixConfiguration));
	}
	
	public AbstractMixRestClient(String url, MediaType mediaType, 
			MIXConfiguration federationConfiguration)
	{
		this(url, mediaType.toString(), federationConfiguration);
	}

	@Override
	protected void addTransactionHeaders()
	{
		TransactionContext transactionContext = TransactionContextFactory.get();
		
		String duz = transactionContext.getDuz();
    	if(duz != null && duz.length() > 0)
    		request.header( TransactionContextHttpHeaders.httpHeaderDuz, duz);
    	
    	String fullname = transactionContext.getFullName();
    	if(fullname != null && fullname.length() > 0)
    		request.header( TransactionContextHttpHeaders.httpHeaderFullName, fullname);

    	String sitename = transactionContext.getSiteName();
    	if(sitename != null && sitename.length() > 0)
    		request.header( TransactionContextHttpHeaders.httpHeaderSiteName, sitename);

    	String sitenumber = transactionContext.getSiteNumber();
    	if(sitenumber != null && sitenumber.length() > 0)
    		request.header( TransactionContextHttpHeaders.httpHeaderSiteNumber, sitenumber);
    	
    	String ssn = transactionContext.getSsn();
    	if(ssn != null && ssn.length() > 0)
    		request.header( TransactionContextHttpHeaders.httpHeaderSSN, ssn);
    	
    	String securityToken = transactionContext.getBrokerSecurityToken();
    	if(securityToken != null && securityToken.length() > 0)
    		request.header(TransactionContextHttpHeaders.httpHeaderBrokerSecurityTokenId, securityToken);
    	
    	String cacheLocationId = transactionContext.getCacheLocationId();
    	if(cacheLocationId != null && cacheLocationId.length() > 0)
    		request.header(TransactionContextHttpHeaders.httpHeaderCacheLocationId, cacheLocationId);
    	
    	String userDivision = transactionContext.getUserDivision();
    	if(userDivision != null && userDivision.length() > 0)
    		request.header(TransactionContextHttpHeaders.httpHeaderUserDivision, userDivision);	
    	
    	String transactionId = transactionContext.getTransactionId();
    	if(transactionId != null && transactionId.length() > 0)
    		request.header(TransactionContextHttpHeaders.httpHeaderTransactionId, transactionId);
    	
    	String requestingVixSiteNumber = transactionContext.getVixSiteNumber();
    	if(requestingVixSiteNumber != null && requestingVixSiteNumber.length() > 0)
    		request.header(TransactionContextHttpHeaders.httpHeaderRequestingVixSiteNumber, requestingVixSiteNumber);
    	
    	String imagingSecurityContextType = transactionContext.getImagingSecurityContextType();
    	if(imagingSecurityContextType != null && imagingSecurityContextType.length() > 0)
    		request.header(TransactionContextHttpHeaders.httpHeaderOptionContext, imagingSecurityContextType);
	}

	private static int getMetadataTimeoutMs(MIXConfiguration mixConfiguration)
	{
		if(mixConfiguration != null)
		{
			return mixConfiguration.getMetadataTimeout();
		}
		return defaultMetadataTimeoutMs;
	}
}
