package gov.va.med.imaging.url.mix.configuration;

import gov.va.med.imaging.url.mix.exceptions.MIXConfigurationException;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;

/**
 * 
 * @author DNS DNS
 *
 */
public class MIXConfiguration
implements Serializable
{
	private final static long serialVersionUID = 1L;

	private static final String DEFAULT_DAS_USERNAME = "vixuser";
	private static final String DEFAULT_DAS_PASSWORD = "vixvix1.";
	public static final String DEFAULT_DAS_SITE = "200";
	
	public final static String defaultDODXChangeApplication = "VaImagingExchange"; // "mix" ??
	public final static String defaultDODMetadataXChangePath1 = "/ImageMetadataService.asmx"; // "/mix/diagnosticReport/subject" (FHIR) -- pass 1 level 1
	public final static String defaultDODMetadataXChangePath2 = "/ImageMetadataService.asmx"; // "/mix/ImagingStudy" (FHIR) -- pass 1 level 2
	public final static String defaultDODImageXChangePath1 = "/RetrieveImage.ashx"; // "/mix/RetrieveThumbnail" (WADO-URI) -- pass 2 (TN)
	public final static String defaultDODImageXChangePath2 = "/RetrieveImage.ashx"; // "/mix/RetrieveInstance" (WADO-RS) -- pass 2 (Ref/Diag)
	public final static String defaultDODImageHost = "";
	public final static int defaultDODImagePort = 0;
	
	public final static String defaultImageXChangeApplication = "MIXWebApp";//"ImagingExchangeWebApp";
	public final static String defaultImageMetadataXChangePath1 = "/mix/diagnosticReport/subject"; // (FHIR) -- pass 1 level 1
	public final static String defaultImageMetadataXChangePath2 = "/mix/ImagingStudy"; // (FHIR) -- pass 1 level 2
	public final static String defaultImageXChangePath1 = "/mix/RetrieveThumbnail";	// (WADO-URI) -- pass 2 (TN)
	public final static String defaultImageXChangePath2 = "/mix/retrieveInstance";	// (WADO-RS) -- pass 2 (Ref/Diag)
	public final static String defaultImageHost = "";
	public final static int defaultImagePort = 0;
	
	private final static Logger logger = Logger.getLogger(MIXConfiguration.class);
	
	private List<MIXSiteConfiguration> configurations;
	private List<String> emptyStudyModalities;
	private int metadataTimeout;
	
	public final static int defaultMetadataTimeout = 45000;
	
	/**
	 * 
	 */
	public MIXConfiguration() 
	{
		super();
		configurations = new ArrayList<MIXSiteConfiguration>();
		emptyStudyModalities = new ArrayList<String>();
		metadataTimeout = defaultMetadataTimeout; // 45 sec
	}
	
	public static MIXConfiguration createDefaultMixConfiguration(String [] vaSites, 
			String dasUsername, String dasPassword, List<MIXSiteConfiguration> alienSites,
			List<String> emptyStudyModalities, int metadataTimeout)
	throws MIXConfigurationException
	{
		MIXConfiguration mixConfiguration = new MIXConfiguration();
		if(vaSites != null)
		{
			for(String vaSite : vaSites)
			{				
				if(vaSite != null)
				{
					System.out.println("Adding VA template for site [" + vaSite + "]");
					MIXSiteConfiguration site = 
						new MIXSiteConfiguration(
							vaSite, "", "", 
							defaultImageXChangeApplication, 
							defaultImageMetadataXChangePath1, 
							defaultImageMetadataXChangePath2, 
							defaultImageXChangePath1,
							defaultImageXChangePath2,
							true,
							defaultImageHost,
							defaultImagePort);
					
					mixConfiguration.addSiteConfiguration(site);
				}
			}
		}
		mixConfiguration.createDODSite(dasUsername, dasPassword);
		if(alienSites != null)
		{
			for(MIXSiteConfiguration alienSiteConfig : alienSites)
			{
				alienSiteConfig.setImagePath1(defaultDODImageXChangePath1);
				alienSiteConfig.setImagePath2(defaultDODImageXChangePath2);
				alienSiteConfig.setMetadataPath1(defaultDODMetadataXChangePath1);
				alienSiteConfig.setMetadataPath2(defaultDODMetadataXChangePath2);
				alienSiteConfig.setXChangeApplication(defaultDODXChangeApplication);
				mixConfiguration.addSiteConfiguration(alienSiteConfig);
			}
		}
		//xchangeConfiguration.emptyStudyModalities.add("PR"); // we know PR studies from the DoD have 0 images
		mixConfiguration.emptyStudyModalities.addAll(emptyStudyModalities);
		mixConfiguration.metadataTimeout = metadataTimeout;
		return mixConfiguration;
	}

	/**
	 * Create an MIXConfiguration instance with a DOD and multiple VA site
	 * entries.
	 * 
	 * @param vaSites
	 * @return
	 * @throws MIXConfigurationException
	 */
	public static MIXConfiguration createDefaultMixConfiguration(String[] vaSites)
	throws MIXConfigurationException
	{
		MIXConfiguration mixConfiguration = new MIXConfiguration();
		/*
		xchangeConfiguration.setDasPassword(DEFAULT_DAS_PASSWORD);
		xchangeConfiguration.setDasUsername(DEFAULT_DAS_USERNAME);
		*/
		
		if(vaSites != null)
		{
			for(String vaSite : vaSites)
			{
				System.out.println("Adding VA template for site [" + vaSite + "]");
				if(vaSite != null)
				{
					MIXSiteConfiguration site = 
						new MIXSiteConfiguration(
							vaSite, "", "", 
							defaultImageXChangeApplication, 
							defaultImageMetadataXChangePath1, 
							defaultImageMetadataXChangePath2, 
							defaultImageXChangePath1,
							defaultImageXChangePath2,
							true,
							defaultImageHost,
							defaultImagePort);
					
					mixConfiguration.addSiteConfiguration(site);
				}
			}
		}
		
		mixConfiguration.createDODSite();		
		return mixConfiguration;
	}	
	
	private void createDODSite()
	{
		MIXSiteConfiguration site = new MIXSiteConfiguration(DEFAULT_DAS_SITE, 
				DEFAULT_DAS_USERNAME, DEFAULT_DAS_PASSWORD, defaultDODXChangeApplication,
				defaultDODMetadataXChangePath1, defaultDODMetadataXChangePath2,
				defaultDODImageXChangePath1, defaultDODImageXChangePath1, false,
				defaultDODImageHost, defaultDODImagePort);
		addSiteConfiguration(site);
	}
	
	private void createDODSite(String dasUsername, String dasPassword)
	{
		String username = DEFAULT_DAS_USERNAME;
		String password = DEFAULT_DAS_PASSWORD;
		if(dasUsername != null)
			username = dasUsername;
		if(dasPassword != null)
			password = dasPassword;		
		System.out.println("Adding DOD Site with username [" + username + "] and password [" + password + "]");
		MIXSiteConfiguration site = new MIXSiteConfiguration(DEFAULT_DAS_SITE, 
				username, password, defaultDODXChangeApplication,
				defaultDODMetadataXChangePath1, defaultDODMetadataXChangePath2,
				defaultDODImageXChangePath1, defaultDODImageXChangePath1, false,
				defaultDODImageHost, defaultDODImagePort);
		addSiteConfiguration(site);
	}
	
	private void addSiteConfiguration(MIXSiteConfiguration site)
	{
		this.configurations.add(site);
	}

	public MIXSiteConfiguration getSiteConfiguration(String preferredSiteNumber, String alternateSiteNumber)
	throws MIXConfigurationException
	{		
		logger.debug("Searching for MIX data source site configuration [" + preferredSiteNumber + "]");
		for(int i = 0; i < configurations.size(); i++)
		{
			MIXSiteConfiguration site = configurations.get(i);
			if((site != null) && (site.equals(preferredSiteNumber)))
			{
				logger.debug("Found MIX data source site configuration [" + preferredSiteNumber + "]");
				return site;
			}
		}
		logger.warn("Unable to find preferred site [" + preferredSiteNumber + "] in MIX configuration");
		if((alternateSiteNumber != null) && (alternateSiteNumber.length() > 0))
		{
			logger.debug("Searching for MIX data source site configuration with alternative site [" + alternateSiteNumber + "]");
			for(int i = 0; i < configurations.size(); i++)
			{
				MIXSiteConfiguration site = configurations.get(i);
				if((site != null) && (site.equals(alternateSiteNumber)))
				{
					logger.debug("Found MIX data source site configuration for alternate site [" + alternateSiteNumber + "]");
					return site;
				}
			}
		}
		String msg = "Unable to find preferred site [" + preferredSiteNumber + "]";
		if((alternateSiteNumber != null) && (alternateSiteNumber.length() > 0))
			msg += " or alternate site number [" + alternateSiteNumber + "]";
		msg += " in MIX configuration";
		throw new MIXConfigurationException(msg);
	}

	/**
	 * return an unmodifiable List of configurations
	 * @return
	 */
	public List<MIXSiteConfiguration> getConfigurations() 
	{
		return configurations;
	}

	public void setConfigurations(List<MIXSiteConfiguration> configurations) 
	{
		this.configurations = configurations;
	}

	public List<String> getEmptyStudyModalities()
	{
		return emptyStudyModalities;
	}

	public void setEmptyStudyModalities(List<String> emptyStudyModalities)
	{
		this.emptyStudyModalities = emptyStudyModalities;
	}

	public int getMetadataTimeout()
	{
		return metadataTimeout;
	}

	public void setMetadataTimeout(int metadataTimeout)
	{
		this.metadataTimeout = metadataTimeout;
	}	
}
