/**
 * Package: MAG - VistA Imaging
 * WARNING: Per VHA Directive 2004-038, this routine should not be modified.
 * @date Jul 6, 2010
 * Site Name:  Washington OI Field Office, Silver Spring, MD
 * @author vhaiswbeckec
 * @version 1.0
 *
 * ----------------------------------------------------------------
 * Property of the US Government.
 * No permission to copy or redistribute this software is given.
 * Use of unreleased versions of this software requires the user
 * to execute a written test agreement with the VistA Imaging
 * Development Office of the Department of Veterans Affairs,
 * telephone (301) 734-0100.
 * 
 * The Food and Drug Administration classifies this software as
 * a Class II medical device.  As such, it may not be changed
 * in any way.  Modifications to this software may result in an
 * adulterated medical device under 21CFR820, the use of which
 * is considered to be a violation of US Federal Statutes.
 * ----------------------------------------------------------------
 */

package gov.va.med.imaging.transactionlogger.log4j.datasource;

import gov.va.med.imaging.access.TransactionLogEntry;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import junit.framework.TestCase;

/**
 * @author vhaiswbeckec
 *
 */
public class TransactionLoggerLocalDataSourceServiceTest
	extends TestCase
{
	private TransactionLoggerLog4jDataSourceService service;
	
	/**
	 * @see junit.framework.TestCase#setUp()
	 */
	@Override
	protected void setUp() throws Exception
	{
		service = new TransactionLoggerLog4jDataSourceService();
	}

	/**
	 * Test method for {@link gov.va.med.imaging.transactionlogger.log4j.datasource.TransactionLoggerLog4jDataSourceService#writeLogEntry(gov.va.med.imaging.access.TransactionLogEntry)}.
	 * @throws ConnectionException 
	 * @throws MethodException 
	 */
	public void testWriteLogEntry() 
	throws MethodException, ConnectionException
	{
		TransactionLogEntry entry = new MockTransactionLogEntry();
		service.writeLogEntry(entry);
	}

}
