/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Aug 18, 2009
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:  vhaiswwerfej
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.transactionlogger.log4j.datasource;

import gov.va.med.imaging.access.TransactionLogEntry;
import gov.va.med.imaging.access.TransactionLogWriter;
import gov.va.med.imaging.core.interfaces.exceptions.ConnectionException;
import gov.va.med.imaging.core.interfaces.exceptions.MethodException;
import gov.va.med.imaging.datasource.TransactionLoggerDataSourceSpi;
import gov.va.med.imaging.datasource.exceptions.UnsupportedServiceMethodException;
import gov.va.med.imaging.exchange.enums.DatasourceProtocol;
import gov.va.med.imaging.exchange.enums.ImageQuality;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

/**
 * Transaction logger Log4J Implementation. This can be configured
 * to drop all the log messages in the bit bucket also.
 * 
 * @author vhaiswbeckec
 *
 */
public class TransactionLoggerLog4jDataSourceService 
implements TransactionLoggerDataSourceSpi
{
	
	public static TransactionLoggerLog4jDataSourceService create()
	throws InvocationTargetException
	{
		return new TransactionLoggerLog4jDataSourceService();
	}

	private final Logger transactionLogger;
	
	public TransactionLoggerLog4jDataSourceService()
	throws InvocationTargetException
	{
		super ();
		
		try
		{
			InputStream inStream = this.getClass().getClassLoader().getResourceAsStream("gov/va/med/imaging/transactionlogger/log4j/datasource/log4j.properties");
			Properties log4jProperties = new Properties();
			log4jProperties.load(inStream);
			PropertyConfigurator.configure(log4jProperties);
			transactionLogger = Logger.getLogger("TransactionLogger");
		}
		catch (IOException x)
		{
			throw new InvocationTargetException(x);
		}
	}

	/**
	 * @see gov.va.med.imaging.datasource.TransactionLoggerDataSource#writeLogEntry(gov.va.med.imaging.access.TransactionLogEntry)
	 */
	@Override
	public void writeLogEntry(TransactionLogEntry entry) 
	throws MethodException, ConnectionException
	{
		transactionLogger.info(entry);
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.datasource.TransactionLoggerDataSourceSpi#getAllLogEntries()
	 */
	@Override
	public void getAllLogEntries(TransactionLogWriter writer) 
	throws MethodException, ConnectionException
	{
		throw new UnsupportedServiceMethodException(TransactionLoggerDataSourceSpi.class, "getAllLogEntries");
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.datasource.TransactionLoggerDataSourceSpi#getLogEntries(java.util.Date, java.util.Date, gov.va.med.imaging.exchange.enums.ImageQuality, java.lang.String, java.lang.String, gov.va.med.imaging.exchange.enums.DatasourceProtocol, java.lang.String, java.lang.String, java.lang.String, java.lang.Boolean, java.lang.Integer, java.lang.Integer)
	 */
	@Override
	public void getLogEntries(TransactionLogWriter writer,
			Date startDate, Date endDate, ImageQuality imageQuality,
		String user, String modality, DatasourceProtocol datasourceProtocol, String errorMessage, String imageUrn,
		String transactionId, Boolean forward, Integer startIndex, Integer endIndex) throws MethodException,
		ConnectionException
	{
		throw new UnsupportedServiceMethodException(TransactionLoggerDataSourceSpi.class, "getLogEntries");
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.datasource.TransactionLoggerDataSourceSpi#getLogEntries(java.lang.String, java.lang.String)
	 */
	@Override
	public void getLogEntries(TransactionLogWriter writer,
			String fieldName, String fieldValue) throws MethodException,
		ConnectionException
	{
		throw new UnsupportedServiceMethodException(TransactionLoggerDataSourceSpi.class, "getLogEntries");
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.datasource.TransactionLoggerDataSourceSpi#purgeLogEntries(java.lang.Integer)
	 */
	@Override
	public void purgeLogEntries(Integer maxDaysAllowed) throws MethodException, ConnectionException
	{
		throw new UnsupportedServiceMethodException(TransactionLoggerDataSourceSpi.class, "purgeLogEntries");
	}

	/* (non-Javadoc)
	 * @see gov.va.med.imaging.datasource.DataSourceSpi#setConfiguration(java.lang.Object)
	 */
	@Override
	public void setConfiguration(Object configuration){}
}
