/**
 * 
  Package: MAG - VistA Imaging
  WARNING: Per VHA Directive 2004-038, this routine should not be modified.
  Date Created: Aug 18, 2009
  Site Name:  Washington OI Field Office, Silver Spring, MD
  Developer:  vhaiswwerfej
  Description: 

        ;; +--------------------------------------------------------------------+
        ;; Property of the US Government.
        ;; No permission to copy or redistribute this software is given.
        ;; Use of unreleased versions of this software requires the user
        ;;  to execute a written test agreement with the VistA Imaging
        ;;  Development Office of the Department of Veterans Affairs,
        ;;  telephone (301) 734-0100.
        ;;
        ;; The Food and Drug Administration classifies this software as
        ;; a Class II medical device.  As such, it may not be changed
        ;; in any way.  Modifications to this software may result in an
        ;; adulterated medical device under 21CFR820, the use of which
        ;; is considered to be a violation of US Federal Statutes.
        ;; +--------------------------------------------------------------------+

 */
package gov.va.med.imaging.transactionlogger.log4j.datasource;

import gov.va.med.imaging.datasource.ProviderService;
import gov.va.med.imaging.datasource.Provider;
import gov.va.med.imaging.datasource.TransactionLoggerDataSourceSpi;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;

/**
 * @author vhaiswwerfej
 *
 */
public class TransactionLoggerLog4jDataSourceProvider 
extends Provider
{
	private static final String PROVIDER_NAME = "TransactionLoggerLog4jDataSource";
	private static final double PROVIDER_VERSION = 1.0d;
	private static final String PROVIDER_INFO = 
		"Implements: \n" + 
		"TransactionLoggerDataSource SPI \n" + 
		"configured with a local Log4J properties.";

	private static final long serialVersionUID = 1L;
	
	private final SortedSet<ProviderService> services;
	
	public TransactionLoggerLog4jDataSourceProvider()
	{
		this(PROVIDER_NAME, PROVIDER_VERSION, PROVIDER_INFO);
	}
	
	public TransactionLoggerLog4jDataSourceProvider(String name, double version, String info)
	{
		super(name, version, info);
		services = new TreeSet<ProviderService>();
		services.add(
			new ProviderService(
				this, 
				TransactionLoggerDataSourceSpi.class,  
				(byte)0, 
				TransactionLoggerLog4jDataSourceService.class)
		);
	}
	
	@Override
	public SortedSet<ProviderService> getServices()
	{
		return Collections.unmodifiableSortedSet(services);
	}
}
